/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsIf;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNode;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsReturn;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.kotlin.js.translate.utils.mutator.Mutator;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

public final class FunctionBodyTranslator
extends AbstractTranslator {
    @NotNull
    private final FunctionDescriptor descriptor;
    @NotNull
    private final KtDeclarationWithBody declaration;

    @NotNull
    public static JsBlock translateFunctionBody(@NotNull FunctionDescriptor descriptor2, @NotNull KtDeclarationWithBody declarationWithBody, @NotNull TranslationContext functionBodyContext) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "translateFunctionBody"));
        }
        if (declarationWithBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationWithBody", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "translateFunctionBody"));
        }
        if (functionBodyContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionBodyContext", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "translateFunctionBody"));
        }
        JsBlock jsBlock = new FunctionBodyTranslator(descriptor2, declarationWithBody, functionBodyContext).translate();
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "translateFunctionBody"));
        }
        return jsBlock;
    }

    @NotNull
    public static List<JsStatement> setDefaultValueForArguments(@NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext functionBodyContext) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "setDefaultValueForArguments"));
        }
        if (functionBodyContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionBodyContext", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "setDefaultValueForArguments"));
        }
        List<ValueParameterDescriptor> valueParameters = descriptor2.getValueParameters();
        ArrayList<JsStatement> result2 = new ArrayList<JsStatement>(valueParameters.size());
        for (ValueParameterDescriptor valueParameter : valueParameters) {
            if (!DescriptorUtilsKt.hasDefaultValue(valueParameter)) continue;
            JsNameRef jsNameRef = functionBodyContext.getNameForDescriptor(valueParameter).makeRef();
            KtExpression defaultArgument = BindingUtils.getDefaultArgument(valueParameter);
            JsBlock defaultArgBlock = new JsBlock();
            JsExpression defaultValue = Translation.translateAsExpression(defaultArgument, functionBodyContext, defaultArgBlock);
            JsStatement assignStatement = JsAstUtils.assignment(jsNameRef, defaultValue).makeStmt();
            JsStatement thenStatement = JsAstUtils.mergeStatementInBlockIfNeeded(assignStatement, defaultArgBlock);
            JsBinaryOperation checkArgIsUndefined = JsAstUtils.equality(jsNameRef, Namer.getUndefinedExpression());
            JsIf jsIf = JsAstUtils.newJsIf(checkArgIsUndefined, thenStatement);
            result2.add(jsIf);
        }
        ArrayList<JsStatement> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "setDefaultValueForArguments"));
        }
        return arrayList;
    }

    private FunctionBodyTranslator(@NotNull FunctionDescriptor descriptor2, @NotNull KtDeclarationWithBody declaration, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "<init>"));
        }
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "<init>"));
        }
        super(context);
        this.descriptor = descriptor2;
        this.declaration = declaration;
    }

    @NotNull
    private JsBlock translate() {
        KtExpression jetBodyExpression = this.declaration.getBodyExpression();
        assert (jetBodyExpression != null) : "Cannot translate a body of an abstract function.";
        JsBlock jsBlock = new JsBlock();
        if (!(this.descriptor instanceof ConstructorDescriptor) || ((ConstructorDescriptor)this.descriptor).isPrimary()) {
            jsBlock.getStatements().addAll(FunctionBodyTranslator.setDefaultValueForArguments(this.descriptor, this.context()));
        }
        jsBlock.getStatements().addAll(this.mayBeWrapWithReturn(Translation.translateExpression(jetBodyExpression, this.context(), jsBlock)).getStatements());
        JsBlock jsBlock2 = jsBlock;
        if (jsBlock2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "translate"));
        }
        return jsBlock2;
    }

    @NotNull
    private JsBlock mayBeWrapWithReturn(@NotNull JsNode body) {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "mayBeWrapWithReturn"));
        }
        if (!this.mustAddReturnToGeneratedFunctionBody()) {
            JsBlock jsBlock = JsAstUtils.convertToBlock(body);
            if (jsBlock == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "mayBeWrapWithReturn"));
            }
            return jsBlock;
        }
        JsBlock jsBlock = JsAstUtils.convertToBlock(this.lastExpressionReturned(body));
        if (jsBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "mayBeWrapWithReturn"));
        }
        return jsBlock;
    }

    private boolean mustAddReturnToGeneratedFunctionBody() {
        KotlinType functionReturnType = this.descriptor.getReturnType();
        assert (functionReturnType != null) : "Function return typed type must be resolved.";
        return !this.declaration.hasBlockBody() && !KotlinBuiltIns.isUnit(functionReturnType);
    }

    @NotNull
    private JsNode lastExpressionReturned(@NotNull JsNode body) {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "lastExpressionReturned"));
        }
        JsStatement jsStatement = LastExpressionMutator.mutateLastExpression(body, new Mutator(){

            @Override
            @NotNull
            public JsNode mutate(@NotNull JsNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator$1", "mutate"));
                }
                if (!(node instanceof JsExpression)) {
                    JsNode jsNode = node;
                    if (jsNode == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator$1", "mutate"));
                    }
                    return jsNode;
                }
                JsReturn jsReturn = new JsReturn((JsExpression)node);
                MetadataProperties.setReturnTarget(jsReturn, FunctionBodyTranslator.this.descriptor);
                JsReturn jsReturn2 = jsReturn;
                if (jsReturn2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator$1", "mutate"));
                }
                return jsReturn2;
            }
        });
        if (jsStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/utils/FunctionBodyTranslator", "lastExpressionReturned"));
        }
        return jsStatement;
    }
}

