/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeatureSettings;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.SimpleDeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/CoroutineModifierChecker;", "Lorg/jetbrains/kotlin/resolve/SimpleDeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlin-compiler"})
public final class CoroutineModifierChecker
implements SimpleDeclarationChecker {
    public static final CoroutineModifierChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (!(declarationDescriptor instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
        if (functionDescriptor == null) {
            return;
        }
        FunctionDescriptor functionDescriptor2 = functionDescriptor;
        if (!(declaration instanceof KtDeclarationWithBody)) {
            return;
        }
        KotlinLookupLocation location2 = new KotlinLookupLocation(declaration);
        Iterable iterable = functionDescriptor2.getValueParameters();
        Iterable iterable2 = ((KtDeclarationWithBody)declaration).getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(iterable2, "declaration.valueParameters");
        for (Pair pair : CollectionsKt.zip(iterable, iterable2)) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            KotlinType controller;
            ValueParameterDescriptor parameterDescriptor = (ValueParameterDescriptor)pair.component1();
            KtParameter parameterDeclaration = (KtParameter)pair.component2();
            if (!parameterDescriptor.isCoroutine()) continue;
            PsiElement psiElement = parameterDeclaration.getModifierList();
            if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.COROUTINE_KEYWORD)) == null) {
                continue;
            }
            PsiElement coroutineModifier = psiElement;
            Function1<String, Unit> report$ = new Function1<String, Unit>(diagnosticHolder, coroutineModifier){
                final /* synthetic */ DiagnosticSink $diagnosticHolder;
                final /* synthetic */ PsiElement $coroutineModifier;

                public final void invoke(@NotNull String message) {
                    Intrinsics.checkParameterIsNotNull(message, "message");
                    this.$diagnosticHolder.report(Errors.INAPPLICABLE_MODIFIER.on(this.$coroutineModifier, KtTokens.COROUTINE_KEYWORD, message));
                }
                {
                    this.$diagnosticHolder = diagnosticSink;
                    this.$coroutineModifier = psiElement;
                    super(1);
                }
            };
            if (!FunctionTypesKt.isExtensionFunctionType(parameterDescriptor.getType())) {
                report$.invoke("parameter should have function type with extension like 'Controller.() -> Continuation<Unit>'");
                continue;
            }
            KotlinType kotlinType = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameterDescriptor.type");
            KotlinType returnType2 = FunctionTypesKt.getReturnTypeFromFunctionType(kotlinType);
            if (returnType2.isMarkedNullable() || !CoroutineUtilKt.isValidContinuation(returnType2) || !TypeUtilsKt.isUnit(CollectionsKt.single(returnType2.getArguments()).getType())) {
                report$.invoke("parameter should have function type like 'Controller.() -> Continuation<Unit>' (Continuation<Unit> for return type is necessary)");
                continue;
            }
            if (functionDescriptor2.isInline() && !parameterDescriptor.isNoinline()) {
                report$.invoke("coroutine parameter of inline function should be marked as 'noinline'");
                continue;
            }
            KotlinType kotlinType2 = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "parameterDescriptor.type");
            if (FunctionTypesKt.getReceiverTypeFromFunctionType(kotlinType2) == null) {
                Intrinsics.throwNpe();
            }
            MemberScope memberScope2 = controller.getMemberScope();
            Name name = OperatorNameConventions.COROUTINE_HANDLE_RESULT;
            Intrinsics.checkExpressionValueIsNotNull(name, "OperatorNameConventions.COROUTINE_HANDLE_RESULT");
            Iterable iterable3 = memberScope2.getContributedFunctions(name, location2);
            void var16_16 = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                SimpleFunctionDescriptor it = (SimpleFunctionDescriptor)element$iv$iv;
                if (!it.isOperator()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List handleResultFunctions = (List)destination$iv$iv;
            if (handleResultFunctions.size() <= 1) continue;
            report$.invoke("only one operator handleResult should be declared for controller, but " + handleResultFunctions.size() + " found");
        }
    }

    private CoroutineModifierChecker() {
        INSTANCE = this;
    }

    static {
        new CoroutineModifierChecker();
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageFeatureSettings languageFeatureSettings) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(languageFeatureSettings, "languageFeatureSettings");
        SimpleDeclarationChecker.DefaultImpls.check(this, declaration, descriptor2, diagnosticHolder, bindingContext, languageFeatureSettings);
    }
}

