/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.ArrayDeque;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.SubtypePathNode;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedureCallbacks;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0001H\u0002\u00a8\u0006\u0007"}, d2={"findCorrespondingSupertype", "Lorg/jetbrains/kotlin/types/KotlinType;", "subtype", "supertype", "typeCheckingProcedureCallbacks", "Lorg/jetbrains/kotlin/types/checker/TypeCheckingProcedureCallbacks;", "approximate", "kotlin-compiler"})
public final class UtilsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final KotlinType findCorrespondingSupertype(@NotNull KotlinType subtype, @NotNull KotlinType supertype, @NotNull TypeCheckingProcedureCallbacks typeCheckingProcedureCallbacks) {
        Intrinsics.checkParameterIsNotNull(subtype, "subtype");
        Intrinsics.checkParameterIsNotNull(supertype, "supertype");
        Intrinsics.checkParameterIsNotNull(typeCheckingProcedureCallbacks, "typeCheckingProcedureCallbacks");
        ArrayDeque<SubtypePathNode> queue = new ArrayDeque<SubtypePathNode>();
        queue.add(new SubtypePathNode(subtype, null));
        TypeConstructor supertypeConstructor = supertype.getConstructor();
        while (!queue.isEmpty()) {
            SubtypePathNode lastPathNode = (SubtypePathNode)queue.poll();
            KotlinType currentSubtype = lastPathNode.getType();
            TypeConstructor constructor = currentSubtype.getConstructor();
            if (typeCheckingProcedureCallbacks.assertEqualTypeConstructors(constructor, supertypeConstructor)) {
                KotlinType substituted = currentSubtype;
                boolean isAnyMarkedNullable = currentSubtype.isMarkedNullable();
                for (SubtypePathNode currentPathNode = lastPathNode.getPrevious(); currentPathNode != null; currentPathNode = currentPathNode.getPrevious()) {
                    boolean bl;
                    KotlinType currentType;
                    block8: {
                        void $receiver$iv;
                        currentType = currentPathNode.getType();
                        Iterable iterable = currentType.getArguments();
                        for (Object element$iv : $receiver$iv) {
                            TypeProjection it = (TypeProjection)element$iv;
                            if (!(Intrinsics.areEqual((Object)it.getProjectionKind(), (Object)Variance.INVARIANT) ^ true)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                    if (bl) {
                        substituted = UtilsKt.approximate(CapturedTypeConstructorKt.wrapWithCapturingSubstitution$default(TypeConstructorSubstitution.Companion.create(currentType), false, 1, null).buildSubstitutor().safeSubstitute(substituted, Variance.INVARIANT));
                    } else {
                        Intrinsics.checkExpressionValueIsNotNull(TypeConstructorSubstitution.Companion.create(currentType).buildSubstitutor().safeSubstitute(substituted, Variance.INVARIANT), "TypeConstructorSubstitut\u2026uted, Variance.INVARIANT)");
                    }
                    isAnyMarkedNullable = isAnyMarkedNullable || currentType.isMarkedNullable();
                }
                if (!typeCheckingProcedureCallbacks.assertEqualTypeConstructors(substituted.getConstructor(), supertypeConstructor)) {
                    throw (Throwable)((Object)new AssertionError((Object)("Type constructors should be equals!" + ("substitutedSuperType: " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(substituted) + ", ") + ("foundSupertype: " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(currentSubtype) + ", ") + ("supertype: " + DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(supertype)))));
                }
                return TypeUtils.makeNullableAsSpecified(substituted, isAnyMarkedNullable);
            }
            Iterator<KotlinType> iterator2 = constructor.getSupertypes().iterator();
            while (iterator2.hasNext()) {
                KotlinType immediateSupertype;
                KotlinType kotlinType = immediateSupertype = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "immediateSupertype");
                queue.add(new SubtypePathNode(kotlinType, lastPathNode));
            }
        }
        return null;
    }

    private static final KotlinType approximate(@NotNull KotlinType $receiver) {
        return CapturedTypeApproximationKt.approximateCapturedTypes($receiver).getUpper();
    }
}

