/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.SamConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.SamConstructorDescriptorKindExclude;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.EMPTY_MEMBER_INDEX;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaClassDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaPackageFragment;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticScope;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.MemberIndex;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaField;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMethod;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPackage;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNullable;
import kotlin.reflect.jvm.internal.impl.storage.NullableLazyValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LazyJavaPackageScope
extends LazyJavaStaticScope {
    private final NullableLazyValue<Set<String>> knownClassNamesInPackage;
    private final MemoizedFunctionToNullable<FindClassRequest, ClassDescriptor> classes;
    private final JavaPackage jPackage;
    @NotNull
    private final LazyJavaPackageFragment ownerDescriptor;

    private final KotlinClassLookupResult resolveKotlinBinaryClass(KotlinJvmBinaryClass kotlinClass) {
        KotlinClassLookupResult kotlinClassLookupResult;
        if (kotlinClass == null) {
            return KotlinClassLookupResult.NotFound.INSTANCE;
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        if (!header.getMetadataVersion().isCompatible()) {
            this.getC().getComponents().getErrorReporter().reportIncompatibleMetadataVersion(kotlinClass.getClassId(), kotlinClass.getLocation(), header.getMetadataVersion());
            kotlinClassLookupResult = KotlinClassLookupResult.NotFound.INSTANCE;
        } else {
            ClassDescriptor descriptor2;
            kotlinClassLookupResult = Intrinsics.areEqual((Object)((Object)header.getKind()), (Object)((Object)KotlinClassHeader.Kind.CLASS)) ? ((descriptor2 = this.getC().getComponents().getDeserializedDescriptorResolver().resolveClass(kotlinClass)) != null ? (KotlinClassLookupResult)new KotlinClassLookupResult.Found(descriptor2) : (KotlinClassLookupResult)KotlinClassLookupResult.NotFound.INSTANCE) : (KotlinClassLookupResult)KotlinClassLookupResult.SyntheticClass.INSTANCE;
        }
        return kotlinClassLookupResult;
    }

    @Override
    @Nullable
    public ClassDescriptor getContributedClassifier(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        return this.findClassifier(name, null);
    }

    private final ClassDescriptor findClassifier(Name name, JavaClass javaClass) {
        if (!SpecialNames.isSafeIdentifier(name)) {
            return null;
        }
        Set knownClassNamesInPackage2 = (Set)this.knownClassNamesInPackage.invoke();
        if (javaClass == null && knownClassNamesInPackage2 != null && knownClassNamesInPackage2.contains(name.asString()) ^ true) {
            return null;
        }
        return (ClassDescriptor)this.classes.invoke(new FindClassRequest(name, javaClass));
    }

    @Nullable
    public final ClassDescriptor findClassifierByJavaClass$kotlin_core(@NotNull JavaClass javaClass) {
        Intrinsics.checkParameterIsNotNull((Object)javaClass, (String)"javaClass");
        return this.findClassifier(javaClass.getName(), javaClass);
    }

    @Override
    @NotNull
    public Collection<PropertyDescriptor> getContributedVariables(@NotNull Name name, @NotNull LookupLocation location) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    protected MemberIndex computeMemberIndex() {
        return new MemberIndex(this){
            private final /* synthetic */ EMPTY_MEMBER_INDEX $delegate_0;
            final /* synthetic */ LazyJavaPackageScope this$0;

            @NotNull
            public Collection<Name> getMethodNames(@NotNull Function1<? super Name, Boolean> nameFilter) {
                Intrinsics.checkParameterIsNotNull(nameFilter, (String)"nameFilter");
                return this.this$0.getClassNames(DescriptorKindFilter.CLASSIFIERS, nameFilter);
            }
            {
                this.this$0 = $outer;
                this.$delegate_0 = EMPTY_MEMBER_INDEX.INSTANCE;
            }

            @Nullable
            public JavaField findFieldByName(@NotNull Name name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return this.$delegate_0.findFieldByName(name);
            }

            @NotNull
            public Collection<JavaMethod> findMethodsByName(@NotNull Name name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return this.$delegate_0.findMethodsByName(name);
            }

            @NotNull
            public Collection<Name> getAllFieldNames() {
                return this.$delegate_0.getAllFieldNames();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Collection<Name> getClassNames(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        void destination$iv$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)kindFilter, (String)"kindFilter");
        Intrinsics.checkParameterIsNotNull(nameFilter, (String)"nameFilter");
        if (!kindFilter.acceptsKinds(DescriptorKindFilter.Companion.getNON_SINGLETON_CLASSIFIERS_MASK())) {
            return CollectionsKt.emptyList();
        }
        Iterable $receiver$iv = this.jPackage.getClasses(nameFilter);
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        void var6_6 = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Name name;
            Object element$iv$iv = element$iv$iv$iv;
            JavaClass klass = (JavaClass)element$iv$iv;
            if ((klass.isKotlinLightClass() ? (Name)null : klass.getName()) == null) continue;
            name = name;
            Name it$iv$iv = name;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    protected Collection<Name> getFunctionNames(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkParameterIsNotNull((Object)kindFilter, (String)"kindFilter");
        Intrinsics.checkParameterIsNotNull(nameFilter, (String)"nameFilter");
        if (kindFilter.getExcludes().contains(SamConstructorDescriptorKindExclude.INSTANCE)) {
            return CollectionsKt.emptyList();
        }
        return super.getFunctionNames(kindFilter, nameFilter);
    }

    @Override
    protected void computeNonDeclaredFunctions(@NotNull Collection<SimpleFunctionDescriptor> result, @NotNull Name name) {
        block0: {
            Intrinsics.checkParameterIsNotNull(result, (String)"result");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            SamConstructorDescriptor samConstructorDescriptor = this.getC().getComponents().getSamConversionResolver().resolveSamConstructor(this.getOwnerDescriptor(), (Function0<? extends ClassifierDescriptor>)((Function0)new Function0<ClassDescriptor>(this, name){
                final /* synthetic */ LazyJavaPackageScope this$0;
                final /* synthetic */ Name $name;

                @Nullable
                public final ClassDescriptor invoke() {
                    return this.this$0.getContributedClassifier(this.$name, NoLookupLocation.FOR_ALREADY_TRACKED);
                }
                {
                    this.this$0 = lazyJavaPackageScope;
                    this.$name = name;
                    super(0);
                }
            }));
            if (samConstructorDescriptor == null) break block0;
            SamConstructorDescriptor samConstructorDescriptor2 = samConstructorDescriptor;
            SamConstructorDescriptor it = samConstructorDescriptor2;
            result.add(it);
        }
    }

    @NotNull
    protected List<Name> getPropertyNames(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkParameterIsNotNull((Object)kindFilter, (String)"kindFilter");
        Intrinsics.checkParameterIsNotNull(nameFilter, (String)"nameFilter");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkParameterIsNotNull((Object)kindFilter, (String)"kindFilter");
        Intrinsics.checkParameterIsNotNull(nameFilter, (String)"nameFilter");
        return this.computeDescriptors(kindFilter, nameFilter, NoLookupLocation.WHEN_GET_ALL_DESCRIPTORS);
    }

    @Override
    @NotNull
    protected LazyJavaPackageFragment getOwnerDescriptor() {
        return this.ownerDescriptor;
    }

    public LazyJavaPackageScope(@NotNull LazyJavaResolverContext c, @NotNull JavaPackage jPackage, @NotNull LazyJavaPackageFragment ownerDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)jPackage, (String)"jPackage");
        Intrinsics.checkParameterIsNotNull((Object)ownerDescriptor, (String)"ownerDescriptor");
        super(c);
        this.jPackage = jPackage;
        this.ownerDescriptor = ownerDescriptor;
        this.knownClassNamesInPackage = c.getStorageManager().createNullableLazyValue((Function0)new Function0<Set<? extends String>>(this, c){
            final /* synthetic */ LazyJavaPackageScope this$0;
            final /* synthetic */ LazyJavaResolverContext $c;

            @Nullable
            public final Set<String> invoke() {
                return this.$c.getComponents().getFinder().knownClassNamesInPackage(this.this$0.getOwnerDescriptor().getFqName());
            }
            {
                this.this$0 = lazyJavaPackageScope;
                this.$c = lazyJavaResolverContext;
                super(0);
            }
        });
        this.classes = c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<FindClassRequest, ClassDescriptor>(this, c){
            final /* synthetic */ LazyJavaPackageScope this$0;
            final /* synthetic */ LazyJavaResolverContext $c;

            @Nullable
            public final ClassDescriptor invoke(@NotNull FindClassRequest request) {
                ClassDescriptor classDescriptor;
                KotlinClassLookupResult kotlinResult;
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                ClassId classId = new ClassId(this.this$0.getOwnerDescriptor().getFqName(), request.getName());
                KotlinJvmBinaryClass kotlinBinaryClass = request.getJavaClass() != null ? this.$c.getComponents().getKotlinClassFinder().findKotlinClass(request.getJavaClass()) : this.$c.getComponents().getKotlinClassFinder().findKotlinClass(classId);
                KotlinClassLookupResult kotlinClassLookupResult = kotlinResult = LazyJavaPackageScope.access$resolveKotlinBinaryClass(this.this$0, kotlinBinaryClass);
                if (kotlinClassLookupResult instanceof KotlinClassLookupResult.Found) {
                    classDescriptor = ((KotlinClassLookupResult.Found)kotlinResult).getDescriptor();
                } else if (kotlinClassLookupResult instanceof KotlinClassLookupResult.SyntheticClass) {
                    classDescriptor = null;
                } else if (kotlinClassLookupResult instanceof KotlinClassLookupResult.NotFound) {
                    LazyJavaClassDescriptor lazyJavaClassDescriptor;
                    JavaClass javaClass;
                    JavaClass javaClass2 = request.getJavaClass();
                    if (javaClass2 == null) {
                        javaClass2 = this.$c.getComponents().getFinder().findClass(classId);
                    }
                    JavaClass javaClass3 = javaClass = javaClass2;
                    if (javaClass3 != null) {
                        JavaClass javaClass4 = javaClass3;
                        JavaClass it = javaClass4;
                        lazyJavaClassDescriptor = new LazyJavaClassDescriptor(this.$c, this.this$0.getOwnerDescriptor(), it, null, 8, null);
                    } else {
                        lazyJavaClassDescriptor = null;
                    }
                    classDescriptor = lazyJavaClassDescriptor;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return classDescriptor;
            }
            {
                this.this$0 = lazyJavaPackageScope;
                this.$c = lazyJavaResolverContext;
                super(1);
            }
        });
    }

    @NotNull
    public static final /* synthetic */ KotlinClassLookupResult access$resolveKotlinBinaryClass(LazyJavaPackageScope $this, @Nullable KotlinJvmBinaryClass kotlinClass) {
        return $this.resolveKotlinBinaryClass(kotlinClass);
    }

    private static abstract class KotlinClassLookupResult {
        private KotlinClassLookupResult() {
        }

        public /* synthetic */ KotlinClassLookupResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class Found
        extends KotlinClassLookupResult {
            @NotNull
            private final ClassDescriptor descriptor;

            @NotNull
            public final ClassDescriptor getDescriptor() {
                return this.descriptor;
            }

            public Found(@NotNull ClassDescriptor descriptor2) {
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                super(null);
                this.descriptor = descriptor2;
            }
        }

        public static final class NotFound
        extends KotlinClassLookupResult {
            public static final NotFound INSTANCE;

            private NotFound() {
                super(null);
                INSTANCE = this;
            }

            static {
                new NotFound();
            }
        }

        public static final class SyntheticClass
        extends KotlinClassLookupResult {
            public static final SyntheticClass INSTANCE;

            private SyntheticClass() {
                super(null);
                INSTANCE = this;
            }

            static {
                new SyntheticClass();
            }
        }
    }

    private static final class FindClassRequest {
        @NotNull
        private final Name name;
        @Nullable
        private final JavaClass javaClass;

        public boolean equals(@Nullable Object other) {
            return other instanceof FindClassRequest && Intrinsics.areEqual((Object)this.name, (Object)((FindClassRequest)other).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @NotNull
        public final Name getName() {
            return this.name;
        }

        @Nullable
        public final JavaClass getJavaClass() {
            return this.javaClass;
        }

        public FindClassRequest(@NotNull Name name, @Nullable JavaClass javaClass) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.name = name;
            this.javaClass = javaClass;
        }
    }
}

