/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterUtilsKt;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.AbstractTypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeserializedTypeAliasDescriptor
extends AbstractTypeAliasDescriptor
implements DeserializedMemberDescriptor {
    @NotNull
    private SimpleType underlyingType;
    @NotNull
    private SimpleType expandedType;
    private List<? extends TypeParameterDescriptor> typeConstructorParameters;
    @NotNull
    private final ProtoBuf.TypeAlias proto;
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final TypeTable typeTable;
    @Nullable
    private final SourceElement containerSource;

    @Override
    @NotNull
    public SimpleType getUnderlyingType() {
        SimpleType simpleType2 = this.underlyingType;
        if (simpleType2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"underlyingType");
        }
        return simpleType2;
    }

    private void setUnderlyingType(SimpleType simpleType2) {
        this.underlyingType = simpleType2;
    }

    @Override
    @NotNull
    public SimpleType getExpandedType() {
        SimpleType simpleType2 = this.expandedType;
        if (simpleType2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"expandedType");
        }
        return simpleType2;
    }

    private void setExpandedType(SimpleType simpleType2) {
        this.expandedType = simpleType2;
    }

    public final void initialize(@NotNull List<? extends TypeParameterDescriptor> declaredTypeParameters, @NotNull SimpleType underlyingType, @NotNull SimpleType expandedType) {
        Intrinsics.checkParameterIsNotNull(declaredTypeParameters, (String)"declaredTypeParameters");
        Intrinsics.checkParameterIsNotNull((Object)underlyingType, (String)"underlyingType");
        Intrinsics.checkParameterIsNotNull((Object)expandedType, (String)"expandedType");
        this.initialize(declaredTypeParameters);
        this.setUnderlyingType(underlyingType);
        this.setExpandedType(expandedType);
        this.typeConstructorParameters = TypeParameterUtilsKt.computeConstructorTypeParameters(this);
    }

    @Override
    @NotNull
    public TypeAliasDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        Intrinsics.checkParameterIsNotNull((Object)substitutor, (String)"substitutor");
        if (substitutor.isEmpty()) {
            return this;
        }
        DeclarationDescriptor declarationDescriptor = this.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"containingDeclaration");
        Annotations annotations2 = this.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull((Object)annotations2, (String)"annotations");
        Name name = this.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
        DeserializedTypeAliasDescriptor substituted = new DeserializedTypeAliasDescriptor(declarationDescriptor, annotations2, name, this.getVisibility(), this.getProto(), this.getNameResolver(), this.getTypeTable(), this.getContainerSource());
        substituted.initialize(this.getDeclaredTypeParameters(), TypeSubstitutionKt.asSimpleType(substitutor.safeSubstitute(this.getUnderlyingType(), Variance.INVARIANT)), TypeSubstitutionKt.asSimpleType(substitutor.safeSubstitute(this.getExpandedType(), Variance.INVARIANT)));
        return substituted;
    }

    @Override
    @NotNull
    protected List<TypeParameterDescriptor> getTypeConstructorTypeParameters() {
        List<TypeParameterDescriptor> list = this.typeConstructorParameters;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"typeConstructorParameters");
        }
        return list;
    }

    @Override
    @NotNull
    public ProtoBuf.TypeAlias getProto() {
        return this.proto;
    }

    @Override
    @NotNull
    public NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @Override
    @NotNull
    public TypeTable getTypeTable() {
        return this.typeTable;
    }

    @Override
    @Nullable
    public SourceElement getContainerSource() {
        return this.containerSource;
    }

    public DeserializedTypeAliasDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, @NotNull Name name, @NotNull Visibility visibility, @NotNull ProtoBuf.TypeAlias proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, @Nullable SourceElement containerSource) {
        Intrinsics.checkParameterIsNotNull((Object)containingDeclaration, (String)"containingDeclaration");
        Intrinsics.checkParameterIsNotNull((Object)annotations2, (String)"annotations");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)visibility, (String)"visibility");
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)typeTable, (String)"typeTable");
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"SourceElement.NO_SOURCE");
        super(containingDeclaration, annotations2, name, sourceElement, visibility);
        this.proto = proto;
        this.nameResolver = nameResolver;
        this.typeTable = typeTable;
        this.containerSource = containerSource;
    }
}

