/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.AbstractFileAccess;
import org.gradle.cache.internal.CacheCoordinator;
import org.gradle.cache.internal.CacheDecorator;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.DefaultMultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.FileAccess;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.LockTimeoutException;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.UnitOfWorkParticipant;
import org.gradle.cache.internal.btree.BTreePersistentIndexedCache;
import org.gradle.cache.internal.cacheops.CacheAccessOperationsStack;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DefaultCacheAccess
implements CacheCoordinator {
    private static final Logger LOG = Logging.getLogger(DefaultCacheAccess.class);
    private final String cacheDisplayName;
    private final File lockTarget;
    private final File baseDir;
    private final FileLockManager lockManager;
    private final CacheInitializationAction initializationAction;
    private final FileAccess fileAccess = new UnitOfWorkFileAccess();
    private final Set<MultiProcessSafePersistentIndexedCache> caches = new HashSet<MultiProcessSafePersistentIndexedCache>();
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private Thread owner;
    private LockOptions lockOptions;
    private FileLock fileLock;
    private FileLock.State stateAtOpen;
    private boolean contended;
    private final CacheAccessOperationsStack operations;
    private int cacheClosedCount;

    public DefaultCacheAccess(String cacheDisplayName, File lockTarget, File baseDir, FileLockManager lockManager, CacheInitializationAction initializationAction) {
        this.cacheDisplayName = cacheDisplayName;
        this.lockTarget = lockTarget;
        this.baseDir = baseDir;
        this.lockManager = lockManager;
        this.initializationAction = initializationAction;
        this.operations = new CacheAccessOperationsStack();
    }

    @Override
    public void open(LockOptions lockOptions) {
        this.lock.lock();
        try {
            if (this.lockOptions != null) {
                throw new IllegalStateException(String.format("Cannot open the %s, as it has already been opened.", this.cacheDisplayName));
            }
            this.lockOptions = lockOptions;
            if (lockOptions.getMode() == FileLockManager.LockMode.None) {
                return;
            }
            if (this.fileLock != null) {
                throw new IllegalStateException("File lock " + this.lockTarget + " is already open.");
            }
            this.fileLock = this.lockManager.lock(this.lockTarget, lockOptions, this.cacheDisplayName);
            boolean rebuild = this.initializationAction.requiresInitialization(this.fileLock);
            if (rebuild) {
                if (lockOptions.getMode() == FileLockManager.LockMode.Exclusive) {
                    this.fileLock.writeFile(new Runnable(){

                        public void run() {
                            DefaultCacheAccess.this.initializationAction.initialize(DefaultCacheAccess.this.fileLock);
                        }
                    });
                } else {
                    for (int tries = 0; rebuild && tries < 3; ++tries) {
                        this.fileLock.close();
                        this.fileLock = this.lockManager.lock(this.lockTarget, lockOptions.withMode(FileLockManager.LockMode.Exclusive), this.cacheDisplayName, "Initialize cache");
                        rebuild = this.initializationAction.requiresInitialization(this.fileLock);
                        if (rebuild) {
                            this.fileLock.writeFile(new Runnable(){

                                public void run() {
                                    DefaultCacheAccess.this.initializationAction.initialize(DefaultCacheAccess.this.fileLock);
                                }
                            });
                        }
                        this.fileLock.close();
                        this.fileLock = this.lockManager.lock(this.lockTarget, lockOptions, this.cacheDisplayName);
                        rebuild = this.initializationAction.requiresInitialization(this.fileLock);
                    }
                    if (rebuild) {
                        throw new CacheOpenException(String.format("Failed to initialize %s", this.cacheDisplayName));
                    }
                }
            }
            this.stateAtOpen = this.fileLock.getState();
            this.takeOwnership(String.format("Access %s", this.cacheDisplayName));
        }
        catch (Throwable throwable) {
            if (this.fileLock != null) {
                this.fileLock.close();
                this.fileLock = null;
            }
            throw UncheckedException.throwAsUncheckedException((Throwable)throwable);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFileLock() {
        try {
            ++this.cacheClosedCount;
            try {
                new CompositeStoppable().add(this.caches).stop();
                FileLock.State state = this.fileLock.getState();
                for (MultiProcessSafePersistentIndexedCache cache : this.caches) {
                    cache.onEndWork(state);
                }
            }
            finally {
                this.fileLock.close();
            }
        }
        finally {
            this.fileLock = null;
            this.stateAtOpen = null;
            this.contended = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.lock();
        try {
            if (this.owner == null) {
                this.owner = Thread.currentThread();
            } else if (this.lockOptions.getMode() != FileLockManager.LockMode.Shared && this.owner != Thread.currentThread()) {
                throw new IllegalStateException(String.format("Cannot close %s as it is currently being used by another thread.", this.cacheDisplayName));
            }
            if (this.fileLock != null) {
                this.closeFileLock();
            }
            if (this.cacheClosedCount != 1) {
                LOG.debug("Cache {} was closed {} times.", (Object)this.cacheDisplayName, (Object)this.cacheClosedCount);
            }
        }
        finally {
            this.lockOptions = null;
            this.owner = null;
            this.lock.unlock();
        }
    }

    @Override
    public void useCache(String operationDisplayName, Runnable action) {
        this.useCache(operationDisplayName, Factories.toFactory((Runnable)action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T useCache(String operationDisplayName, Factory<? extends T> factory) {
        if (this.lockOptions != null && this.lockOptions.getMode() == FileLockManager.LockMode.Shared) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
        boolean wasStarted = false;
        this.lock.lock();
        try {
            this.takeOwnership(operationDisplayName);
            wasStarted = this.onStartWork();
        }
        finally {
            this.lock.unlock();
        }
        try {
            Object object = factory.create();
            return (T)object;
        }
        finally {
            this.lock.lock();
            try {
                try {
                    if (wasStarted) {
                        this.onEndWork();
                    }
                }
                finally {
                    this.releaseOwnership();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeOwnership(String operationDisplayName) {
        this.lock.lock();
        try {
            while (this.owner != null && this.owner != Thread.currentThread()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            this.owner = Thread.currentThread();
            this.operations.pushCacheAction(operationDisplayName);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseOwnership() {
        this.lock.lock();
        try {
            this.operations.popCacheAction();
            if (!this.operations.isInCacheAction()) {
                this.owner = null;
                this.condition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T longRunningOperation(String operationDisplayName, Factory<? extends T> action) {
        boolean wasEnded = this.startLongRunningOperation(operationDisplayName);
        try {
            Object object = action.create();
            return (T)object;
        }
        finally {
            this.finishLongRunningOperation(wasEnded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startLongRunningOperation(String operationDisplayName) {
        boolean wasEnded;
        this.lock.lock();
        try {
            if (this.lockOptions == null || this.lockOptions.getMode() == FileLockManager.LockMode.Shared) {
                throw new UnsupportedOperationException("Not supported for this lock mode.");
            }
            if (this.operations.isInCacheAction()) {
                this.checkThreadIsOwner();
                wasEnded = this.onEndWork();
                this.owner = null;
                this.condition.signalAll();
            } else {
                wasEnded = false;
            }
            this.operations.pushLongRunningOperation(operationDisplayName);
        }
        finally {
            this.lock.unlock();
        }
        return wasEnded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishLongRunningOperation(boolean wasEnded) {
        this.lock.lock();
        try {
            this.operations.popLongRunningOperation();
            if (this.operations.isInCacheAction()) {
                this.restoreOwner();
                if (wasEnded) {
                    this.onStartWork();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkThreadIsOwner() {
        this.lock.lock();
        try {
            if (this.owner != Thread.currentThread()) {
                throw new IllegalStateException(String.format("Cannot start long running operation, as the %s has not been locked.", this.cacheDisplayName));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreOwner() {
        this.lock.lock();
        try {
            while (this.owner != null) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            this.owner = Thread.currentThread();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void longRunningOperation(String operationDisplayName, Runnable action) {
        this.longRunningOperation(operationDisplayName, Factories.toFactory((Runnable)action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> MultiProcessSafePersistentIndexedCache<K, V> newCache(final PersistentIndexedCacheParameters<K, V> parameters) {
        final File cacheFile = new File(this.baseDir, parameters.getCacheName() + ".bin");
        Factory indexedCacheFactory = new Factory<BTreePersistentIndexedCache<K, V>>(){

            public BTreePersistentIndexedCache<K, V> create() {
                return DefaultCacheAccess.this.doCreateCache(cacheFile, parameters.getKeySerializer(), parameters.getValueSerializer());
            }
        };
        DefaultMultiProcessSafePersistentIndexedCache indexedCache = new DefaultMultiProcessSafePersistentIndexedCache(indexedCacheFactory, this.fileAccess);
        CacheDecorator decorator = parameters.getCacheDecorator();
        indexedCache = decorator == null ? indexedCache : decorator.decorate(cacheFile.getAbsolutePath(), parameters.getCacheName(), indexedCache);
        this.lock.lock();
        try {
            this.caches.add(indexedCache);
            if (this.fileLock != null) {
                String description = this.operations.isInCacheAction() ? this.operations.getDescription() : "cache creation";
                indexedCache.onStartWork(description, this.stateAtOpen);
            }
        }
        finally {
            this.lock.unlock();
        }
        return indexedCache;
    }

    <K, V> BTreePersistentIndexedCache<K, V> doCreateCache(File cacheFile, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new BTreePersistentIndexedCache<K, V>(cacheFile, keySerializer, valueSerializer);
    }

    private boolean onStartWork() {
        if (this.fileLock != null) {
            return false;
        }
        this.fileLock = this.lockManager.lock(this.lockTarget, this.lockOptions.withMode(FileLockManager.LockMode.Exclusive), this.cacheDisplayName, this.operations.getDescription());
        if (this.initializationAction.requiresInitialization(this.fileLock)) {
            this.fileLock.writeFile(new Runnable(){

                public void run() {
                    DefaultCacheAccess.this.initializationAction.initialize(DefaultCacheAccess.this.fileLock);
                }
            });
        }
        this.stateAtOpen = this.fileLock.getState();
        for (UnitOfWorkParticipant unitOfWorkParticipant : this.caches) {
            unitOfWorkParticipant.onStartWork(this.operations.getDescription(), this.stateAtOpen);
        }
        this.lockManager.allowContention(this.fileLock, this.whenContended());
        return true;
    }

    private boolean onEndWork() {
        if (this.fileLock == null) {
            return false;
        }
        if (this.contended || this.fileLock.getMode() == FileLockManager.LockMode.Shared) {
            this.closeFileLock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock getLock() {
        this.lock.lock();
        try {
            if (Thread.currentThread() != this.owner) {
                throw new IllegalStateException(String.format("The %s has not been locked for this thread. File lock: %s, owner: %s", this.cacheDisplayName, this.fileLock != null, this.owner));
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.fileLock;
    }

    Runnable whenContended() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DefaultCacheAccess.this.lock.lock();
                try {
                    LOG.debug("Detected file lock contention of {} (fileLock={}, contended={}, owner={})", new Object[]{DefaultCacheAccess.this.cacheDisplayName, DefaultCacheAccess.this.fileLock != null, DefaultCacheAccess.this.contended, DefaultCacheAccess.this.owner});
                    if (DefaultCacheAccess.this.fileLock == null) {
                        return;
                    }
                    if (DefaultCacheAccess.this.owner != null) {
                        DefaultCacheAccess.this.contended = true;
                        return;
                    }
                    DefaultCacheAccess.this.takeOwnership("Other process requested access to " + DefaultCacheAccess.this.cacheDisplayName);
                    try {
                        DefaultCacheAccess.this.closeFileLock();
                    }
                    finally {
                        DefaultCacheAccess.this.releaseOwnership();
                    }
                }
                finally {
                    DefaultCacheAccess.this.lock.unlock();
                }
            }
        };
    }

    Thread getOwner() {
        return this.owner;
    }

    FileAccess getFileAccess() {
        return this.fileAccess;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnitOfWorkFileAccess
    extends AbstractFileAccess {
        private UnitOfWorkFileAccess() {
        }

        public String toString() {
            return DefaultCacheAccess.this.cacheDisplayName;
        }

        @Override
        public <T> T readFile(Factory<? extends T> action) throws LockTimeoutException {
            return DefaultCacheAccess.this.getLock().readFile(action);
        }

        @Override
        public void updateFile(Runnable action) throws LockTimeoutException {
            DefaultCacheAccess.this.getLock().updateFile(action);
        }

        @Override
        public void writeFile(Runnable action) throws LockTimeoutException {
            DefaultCacheAccess.this.getLock().writeFile(action);
        }
    }
}

