/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.composite.internal.CompositeProjectComponentArtifactMetadata;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;

public class IncludedBuildDependencyMetadataBuilder {
    private final CompositeBuildContext context;

    public IncludedBuildDependencyMetadataBuilder(CompositeBuildContext context) {
        this.context = context;
    }

    public void build(IncludedBuildInternal build) {
        GradleInternal gradle = build.getConfiguredBuild();
        for (Project project : gradle.getRootProject().getAllprojects()) {
            this.registerProject((IncludedBuild)build, (ProjectInternal)project);
        }
    }

    private void registerProject(IncludedBuild build, ProjectInternal project) {
        LocalComponentRegistry localComponentRegistry = (LocalComponentRegistry)project.getServices().get(LocalComponentRegistry.class);
        ProjectComponentIdentifier originalIdentifier = DefaultProjectComponentIdentifier.newProjectId((Project)project);
        DefaultLocalComponentMetadata originalComponent = (DefaultLocalComponentMetadata)localComponentRegistry.getComponent(originalIdentifier);
        ProjectComponentIdentifier componentIdentifier = DefaultProjectComponentIdentifier.newProjectId((IncludedBuild)build, (String)project.getPath());
        LocalComponentMetadata compositeComponent = this.createCompositeCopy(build, componentIdentifier, originalComponent);
        this.context.register(componentIdentifier, compositeComponent, project.getProjectDir());
        for (LocalComponentArtifactMetadata artifactMetaData : localComponentRegistry.getAdditionalArtifacts(originalIdentifier)) {
            this.context.registerAdditionalArtifact(componentIdentifier, this.createCompositeCopy(componentIdentifier, artifactMetaData));
        }
    }

    private LocalComponentMetadata createCompositeCopy(IncludedBuild build, ProjectComponentIdentifier componentIdentifier, DefaultLocalComponentMetadata originalComponentMetadata) {
        DefaultLocalComponentMetadata compositeComponentMetadata = new DefaultLocalComponentMetadata(originalComponentMetadata.getId(), (ComponentIdentifier)componentIdentifier, originalComponentMetadata.getStatus());
        for (String configurationName : originalComponentMetadata.getConfigurationNames()) {
            DefaultLocalComponentMetadata.DefaultLocalConfigurationMetadata originalConfiguration = originalComponentMetadata.getConfiguration(configurationName);
            compositeComponentMetadata.addConfiguration(configurationName, originalConfiguration.getDescription(), originalConfiguration.getExtendsFrom(), originalConfiguration.getHierarchy(), originalConfiguration.isVisible(), originalConfiguration.isTransitive(), (TaskDependency)new DefaultTaskDependency());
            Set<String> targetTasks = this.determineTargetTasks((LocalConfigurationMetadata)originalConfiguration);
            Set artifacts = originalConfiguration.getArtifacts();
            for (ComponentArtifactMetadata originalArtifact : artifacts) {
                File artifactFile = ((LocalComponentArtifactMetadata)originalArtifact).getFile();
                CompositeProjectComponentArtifactMetadata artifact = new CompositeProjectComponentArtifactMetadata(componentIdentifier, originalArtifact.getName(), artifactFile, targetTasks);
                compositeComponentMetadata.addArtifact(configurationName, (ComponentArtifactMetadata)artifact);
            }
        }
        for (LocalOriginDependencyMetadata dependency : originalComponentMetadata.getDependencies()) {
            if (dependency.getSelector() instanceof ProjectComponentSelector) {
                ProjectComponentSelector requested = (ProjectComponentSelector)dependency.getSelector();
                dependency = dependency.withTarget((ComponentSelector)DefaultProjectComponentSelector.newSelector((IncludedBuild)build, (ProjectComponentSelector)requested));
            }
            compositeComponentMetadata.addDependency(dependency);
        }
        for (Exclude exclude : originalComponentMetadata.getExcludeRules()) {
            compositeComponentMetadata.addExclude(exclude);
        }
        return compositeComponentMetadata;
    }

    private LocalComponentArtifactMetadata createCompositeCopy(ProjectComponentIdentifier project, LocalComponentArtifactMetadata artifactMetaData) {
        File artifactFile = artifactMetaData.getFile();
        return new CompositeProjectComponentArtifactMetadata(project, artifactMetaData.getName(), artifactFile, this.getArtifactTasks((ComponentArtifactMetadata)artifactMetaData));
    }

    private Set<String> determineTargetTasks(LocalConfigurationMetadata configuration) {
        LinkedHashSet taskNames = Sets.newLinkedHashSet();
        for (ComponentArtifactMetadata artifactMetaData : configuration.getArtifacts()) {
            this.addArtifactTasks(taskNames, artifactMetaData);
        }
        return taskNames;
    }

    private Set<String> getArtifactTasks(ComponentArtifactMetadata artifactMetaData) {
        LinkedHashSet taskNames = Sets.newLinkedHashSet();
        this.addArtifactTasks(taskNames, artifactMetaData);
        return taskNames;
    }

    private void addArtifactTasks(Set<String> taskNames, ComponentArtifactMetadata artifactMetaData) {
        if (artifactMetaData instanceof Buildable) {
            Buildable publishArtifact = (Buildable)artifactMetaData;
            Set dependencies = publishArtifact.getBuildDependencies().getDependencies(null);
            for (Task dependency : dependencies) {
                taskNames.add(dependency.getPath());
            }
        }
    }
}

