/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.platform;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.language.scala.ScalaPlatform;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.util.VersionNumber;

public enum PlayMajorVersion {
    PLAY_2_2_X("2.2.x", "2.10"),
    PLAY_2_3_X("2.3.x", "2.11", "2.10"),
    PLAY_2_4_X("2.4.x", "2.11", "2.10"),
    PLAY_2_5_X("2.5.x", "2.11");

    private final String name;
    private final List<String> compatibleScalaVersions;

    private PlayMajorVersion(String name, String ... compatibleScalaVersions) {
        this.name = name;
        this.compatibleScalaVersions = Lists.newArrayList((Object[])compatibleScalaVersions);
    }

    public void validateCompatible(ScalaPlatform scalaPlatform) {
        if (!this.compatibleScalaVersions.contains(scalaPlatform.getScalaCompatibilityVersion())) {
            throw new InvalidUserDataException(String.format("Play versions %s are not compatible with Scala platform %s. Compatible Scala platforms are %s.", this.name, scalaPlatform.getScalaCompatibilityVersion(), this.compatibleScalaVersions));
        }
    }

    public String getDefaultScalaPlatform() {
        return this.compatibleScalaVersions.get(0);
    }

    public static PlayMajorVersion forPlatform(PlayPlatform targetPlatform) {
        String playVersion = targetPlatform.getPlayVersion();
        return PlayMajorVersion.forPlayVersion(playVersion);
    }

    public static PlayMajorVersion forPlayVersion(String playVersion) {
        VersionNumber versionNumber = VersionNumber.parse((String)playVersion);
        if (versionNumber.getMajor() == 2) {
            switch (versionNumber.getMinor()) {
                case 2: {
                    return PLAY_2_2_X;
                }
                case 3: {
                    return PLAY_2_3_X;
                }
                case 4: {
                    return PLAY_2_4_X;
                }
                case 5: {
                    return PLAY_2_5_X;
                }
            }
            throw PlayMajorVersion.invalidVersion(playVersion);
        }
        throw PlayMajorVersion.invalidVersion(playVersion);
    }

    private static InvalidUserDataException invalidVersion(String playVersion) {
        return new InvalidUserDataException(String.format("Not a supported Play version: %s. This plugin is compatible with: [2.5.x, 2.4.x, 2.3.x, 2.2.x].", playVersion));
    }
}

