/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.testing.DefaultTestMethodDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.testng.TestNGConfigurationListener;
import org.gradle.api.internal.tasks.testing.testng.UnrepresentableParameterException;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.id.IdGenerator;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;

public class TestNGTestResultProcessorAdapter
implements ISuiteListener,
ITestListener,
TestNGConfigurationListener {
    private final TestResultProcessor resultProcessor;
    private final IdGenerator<?> idGenerator;
    private final TimeProvider timeProvider;
    private final Object lock = new Object();
    private final Map<ITestContext, Object> testId = new HashMap<ITestContext, Object>();
    private final Map<ISuite, Object> suiteId = new HashMap<ISuite, Object>();
    private final Map<ITestResult, Object> testMethodId = new HashMap<ITestResult, Object>();
    private final Map<ITestNGMethod, Object> testMethodParentId = new HashMap<ITestNGMethod, Object>();
    private final Set<ITestResult> failedConfigurations = new HashSet<ITestResult>();

    public TestNGTestResultProcessorAdapter(TestResultProcessor resultProcessor, IdGenerator<?> idGenerator, TimeProvider timeProvider) {
        this.resultProcessor = resultProcessor;
        this.idGenerator = idGenerator;
        this.timeProvider = timeProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart(ISuite suite) {
        DefaultTestSuiteDescriptor testInternal;
        Object object = this.lock;
        synchronized (object) {
            if (this.suiteId.containsKey(suite)) {
                return;
            }
            testInternal = new DefaultTestSuiteDescriptor(this.idGenerator.generateId(), suite.getName());
            this.suiteId.put(suite, testInternal.getId());
        }
        this.resultProcessor.started((TestDescriptorInternal)testInternal, new TestStartEvent(this.timeProvider.getCurrentTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinish(ISuite suite) {
        Object id;
        Object object = this.lock;
        synchronized (object) {
            id = this.suiteId.remove(suite);
            if (id == null) {
                return;
            }
        }
        this.resultProcessor.completed(id, new TestCompleteEvent(this.timeProvider.getCurrentTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart(ITestContext iTestContext) {
        Object parentId;
        DefaultTestSuiteDescriptor testInternal;
        Object object = this.lock;
        synchronized (object) {
            testInternal = new DefaultTestSuiteDescriptor(this.idGenerator.generateId(), iTestContext.getName());
            parentId = this.suiteId.get(iTestContext.getSuite());
            this.testId.put(iTestContext, testInternal.getId());
            for (ITestNGMethod method : iTestContext.getAllTestMethods()) {
                this.testMethodParentId.put(method, testInternal.getId());
            }
        }
        this.resultProcessor.started((TestDescriptorInternal)testInternal, new TestStartEvent(iTestContext.getStartDate().getTime(), parentId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinish(ITestContext iTestContext) {
        Object id;
        Object object = this.lock;
        synchronized (object) {
            id = this.testId.remove(iTestContext);
            for (ITestNGMethod method : iTestContext.getAllTestMethods()) {
                this.testMethodParentId.remove(method);
            }
        }
        this.resultProcessor.completed(id, new TestCompleteEvent(iTestContext.getEndDate().getTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTestStart(ITestResult iTestResult) {
        Object parentId;
        DefaultTestMethodDescriptor testInternal;
        Object object = this.lock;
        synchronized (object) {
            String name = this.calculateTestCaseName(iTestResult);
            testInternal = new DefaultTestMethodDescriptor(this.idGenerator.generateId(), iTestResult.getTestClass().getName(), name);
            Object oldTestId = this.testMethodId.put(iTestResult, testInternal.getId());
            assert (oldTestId == null) : "Apparently some other test has started but it hasn't finished. Expect the resultProcessor to break. Don't expect to see this assertion stack trace due to the current architecture";
            parentId = this.testMethodParentId.get(iTestResult.getMethod());
            assert (parentId != null);
        }
        this.resultProcessor.started((TestDescriptorInternal)testInternal, new TestStartEvent(iTestResult.getStartMillis(), parentId));
        if (iTestResult.getThrowable() instanceof UnrepresentableParameterException) {
            throw (UnrepresentableParameterException)((Object)iTestResult.getThrowable());
        }
    }

    private String calculateTestCaseName(ITestResult iTestResult) {
        Object[] parameters = iTestResult.getParameters();
        String name = iTestResult.getName();
        if (parameters != null && parameters.length > 0) {
            StringBuilder builder = new StringBuilder(name).append("[").append(iTestResult.getMethod().getCurrentInvocationCount()).append("]");
            StringBuilder paramsListBuilder = new StringBuilder("(");
            int i = 0;
            for (Object parameter : parameters) {
                if (parameter == null) {
                    paramsListBuilder.append("null");
                } else {
                    try {
                        paramsListBuilder.append(parameter.toString());
                    }
                    catch (Exception e) {
                        iTestResult.setThrowable((Throwable)((Object)new UnrepresentableParameterException(iTestResult, i, e)));
                        return builder.toString();
                    }
                }
                if (++i >= parameters.length) continue;
                paramsListBuilder.append(", ");
            }
            paramsListBuilder.append(")");
            return builder.append(paramsListBuilder.toString()).toString();
        }
        return name;
    }

    public void onTestSuccess(ITestResult iTestResult) {
        this.onTestFinished(iTestResult, TestResult.ResultType.SUCCESS);
    }

    public void onTestFailure(ITestResult iTestResult) {
        this.onTestFinished(iTestResult, TestResult.ResultType.FAILURE);
    }

    public void onTestSkipped(ITestResult iTestResult) {
        this.onTestFinished(iTestResult, TestResult.ResultType.SKIPPED);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
        this.onTestFinished(iTestResult, TestResult.ResultType.SUCCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTestFinished(ITestResult iTestResult, TestResult.ResultType resultType) {
        Object testId;
        TestStartEvent startEvent = null;
        Object object = this.lock;
        synchronized (object) {
            testId = this.testMethodId.remove(iTestResult);
            if (testId == null) {
                testId = this.idGenerator.generateId();
                Object parentId = this.testMethodParentId.get(iTestResult.getMethod());
                startEvent = new TestStartEvent(iTestResult.getStartMillis(), parentId);
            }
        }
        if (startEvent != null) {
            this.resultProcessor.started((TestDescriptorInternal)new DefaultTestMethodDescriptor(testId, iTestResult.getTestClass().getName(), iTestResult.getName()), startEvent);
        }
        if (resultType == TestResult.ResultType.FAILURE) {
            this.resultProcessor.failure(testId, iTestResult.getThrowable());
        }
        this.resultProcessor.completed(testId, new TestCompleteEvent(iTestResult.getEndMillis(), resultType));
    }

    @Override
    public void onConfigurationSuccess(ITestResult testResult) {
    }

    @Override
    public void onConfigurationSkip(ITestResult testResult) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConfigurationFailure(ITestResult testResult) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.failedConfigurations.add(testResult)) {
                return;
            }
        }
        DefaultTestMethodDescriptor test = new DefaultTestMethodDescriptor(this.idGenerator.generateId(), testResult.getMethod().getTestClass().getName(), testResult.getMethod().getMethodName());
        this.resultProcessor.started((TestDescriptorInternal)test, new TestStartEvent(testResult.getStartMillis()));
        this.resultProcessor.failure(test.getId(), testResult.getThrowable());
        this.resultProcessor.completed(test.getId(), new TestCompleteEvent(testResult.getEndMillis(), TestResult.ResultType.FAILURE));
    }

    @Override
    public void beforeConfiguration(ITestResult tr) {
    }
}

