/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OrderSensitive;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.util.ConfigureUtil;

public class War
extends Jar {
    public static final String WAR_EXTENSION = "war";
    private static final Spec<File> IS_DIRECTORY = new Spec<File>(){

        public boolean isSatisfiedBy(File element) {
            return element.isDirectory();
        }
    };
    private static final Spec<File> IS_FILE = new Spec<File>(){

        public boolean isSatisfiedBy(File element) {
            return element.isFile();
        }
    };
    private File webXml;
    private FileCollection classpath;
    private final DefaultCopySpec webInf;

    public War() {
        this.setExtension(WAR_EXTENSION);
        this.setMetadataCharset("UTF-8");
        this.webInf = (DefaultCopySpec)this.getRootSpec().addChildBeforeSpec(this.getMainSpec()).into((Object)"WEB-INF");
        this.webInf.into((Object)"classes", (Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.from(new Object[]{new Callable<Iterable<File>>(){

                    @Override
                    public Iterable<File> call() {
                        FileCollection classpath = War.this.getClasspath();
                        return classpath != null ? classpath.filter(IS_DIRECTORY) : Collections.emptyList();
                    }
                }});
            }
        });
        this.webInf.into((Object)"lib", (Action)new Action<CopySpec>(){

            public void execute(CopySpec it) {
                it.from(new Object[]{new Callable<Iterable<File>>(){

                    @Override
                    public Iterable<File> call() {
                        FileCollection classpath = War.this.getClasspath();
                        return classpath != null ? classpath.filter(IS_FILE) : Collections.emptyList();
                    }
                }});
            }
        });
        this.webInf.into((Object)"", (Action)new Action<CopySpec>(){

            public void execute(CopySpec it) {
                it.from(new Object[]{new Callable<File>(){

                    @Override
                    public File call() {
                        return War.this.getWebXml();
                    }
                }});
                it.rename((Transformer)new Transformer<String, String>(){

                    public String transform(String it) {
                        return "web.xml";
                    }
                });
            }
        });
    }

    @Internal
    public CopySpec getWebInf() {
        return this.webInf.addChild();
    }

    public CopySpec webInf(Closure configureClosure) {
        return (CopySpec)ConfigureUtil.configure((Closure)configureClosure, (Object)this.getWebInf());
    }

    @OrderSensitive
    @InputFiles
    @Optional
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(Object classpath) {
        this.classpath = this.getProject().files(new Object[]{classpath});
    }

    public void classpath(Object ... classpath) {
        FileCollection oldClasspath = this.getClasspath();
        this.classpath = this.getProject().files(new Object[]{oldClasspath != null ? oldClasspath : new ArrayList(), classpath});
    }

    @InputFile
    @Optional
    public File getWebXml() {
        return this.webXml;
    }

    public void setWebXml(File webXml) {
        this.webXml = webXml;
    }
}

