/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop.cext;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.interop.cext.CExtNodes;
import org.jruby.truffle.interop.cext.CExtString;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=CExtNodes.class)
public final class CExtNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(NUM2INTNodeFactory.getInstance(), NUM2UINTNodeFactory.getInstance(), NUM2LONGNodeFactory.getInstance(), NUM2ULONGNodeFactory.getInstance(), NUM2DBLNodeFactory.getInstance(), FIX2INTNodeFactory.getInstance(), FIX2UINTNodeFactory.getInstance(), FIX2LONGNodeFactory.getInstance(), INT2NUMNodeFactory.getInstance(), INT2FIXNodeFactory.getInstance(), UINT2NUMNodeFactory.getInstance(), LONG2NUMNodeFactory.getInstance(), ULONG2NUMNodeFactory.getInstance(), LONG2FIXNodeFactory.getInstance(), Long2IntFactory.getInstance(), CExtStringNodeFactory.getInstance(), ToRubyStringNodeFactory.getInstance(), BlockGivenNodeFactory.getInstance(), GetBlockNodeFactory.getInstance(), ConstGetFromNodeFactory.getInstance(), IOHandleNodeFactory.getInstance());
    }

    @GeneratedBy(value=CExtNodes.IOHandleNode.class)
    public static final class IOHandleNodeFactory
    extends NodeFactoryBase<CExtNodes.IOHandleNode> {
        private static IOHandleNodeFactory iOHandleNodeFactoryInstance;

        private IOHandleNodeFactory() {
            super(CExtNodes.IOHandleNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.IOHandleNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return IOHandleNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.IOHandleNode> getInstance() {
            if (iOHandleNodeFactoryInstance == null) {
                iOHandleNodeFactoryInstance = new IOHandleNodeFactory();
            }
            return iOHandleNodeFactoryInstance;
        }

        public static CExtNodes.IOHandleNode create(RubyNode[] arguments) {
            return new IOHandleNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.IOHandleNode.class)
        public static final class IOHandleNodeGen
        extends CExtNodes.IOHandleNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private IOHandleNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyIO(arguments0Value_)) {
                    return this.ioHandle(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=CExtNodes.ConstGetFromNode.class)
    public static final class ConstGetFromNodeFactory
    extends NodeFactoryBase<CExtNodes.ConstGetFromNode> {
        private static ConstGetFromNodeFactory constGetFromNodeFactoryInstance;

        private ConstGetFromNodeFactory() {
            super(CExtNodes.ConstGetFromNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode.class, RubyNode.class}});
        }

        @Override
        public CExtNodes.ConstGetFromNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return ConstGetFromNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.ConstGetFromNode> getInstance() {
            if (constGetFromNodeFactoryInstance == null) {
                constGetFromNodeFactoryInstance = new ConstGetFromNodeFactory();
            }
            return constGetFromNodeFactoryInstance;
        }

        public static CExtNodes.ConstGetFromNode create(RubyNode module, RubyNode name) {
            return new ConstGetFromNodeGen(module, name);
        }

        @GeneratedBy(value=CExtNodes.ConstGetFromNode.class)
        public static final class ConstGetFromNodeGen
        extends CExtNodes.ConstGetFromNode {
            @Node.Child
            private RubyNode module_;
            @Node.Child
            private RubyNode name_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ConstGetFromNodeGen(RubyNode module, RubyNode name) {
                this.module_ = module;
                this.name_ = this.coerceToString(name);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String nameValue_;
                DynamicObject moduleValue_;
                try {
                    moduleValue_ = this.module_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object nameValue = this.name_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), nameValue);
                }
                try {
                    nameValue_ = ConstGetFromNodeGen.expectString(this.name_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(moduleValue_, ex.getResult());
                }
                return this.constGetFrom(frameValue, moduleValue_, nameValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object moduleValue, Object nameValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.module_, this.name_}, moduleValue, nameValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=CExtNodes.GetBlockNode.class)
    public static final class GetBlockNodeFactory
    extends NodeFactoryBase<CExtNodes.GetBlockNode> {
        private static GetBlockNodeFactory getBlockNodeFactoryInstance;

        private GetBlockNodeFactory() {
            super(CExtNodes.GetBlockNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.GetBlockNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetBlockNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.GetBlockNode> getInstance() {
            if (getBlockNodeFactoryInstance == null) {
                getBlockNodeFactoryInstance = new GetBlockNodeFactory();
            }
            return getBlockNodeFactoryInstance;
        }

        public static CExtNodes.GetBlockNode create(RubyNode[] arguments) {
            return new GetBlockNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.GetBlockNode.class)
        public static final class GetBlockNodeGen
        extends CExtNodes.GetBlockNode {
            private GetBlockNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.getBlock();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=CExtNodes.BlockGivenNode.class)
    public static final class BlockGivenNodeFactory
    extends NodeFactoryBase<CExtNodes.BlockGivenNode> {
        private static BlockGivenNodeFactory blockGivenNodeFactoryInstance;

        private BlockGivenNodeFactory() {
            super(CExtNodes.BlockGivenNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.BlockGivenNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return BlockGivenNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.BlockGivenNode> getInstance() {
            if (blockGivenNodeFactoryInstance == null) {
                blockGivenNodeFactoryInstance = new BlockGivenNodeFactory();
            }
            return blockGivenNodeFactoryInstance;
        }

        public static CExtNodes.BlockGivenNode create(RubyNode[] arguments) {
            return new BlockGivenNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.BlockGivenNode.class)
        public static final class BlockGivenNodeGen
        extends CExtNodes.BlockGivenNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private BlockGivenNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static MaterializedFrame expectMaterializedFrame(Object value) throws UnexpectedResultException {
                if (value instanceof MaterializedFrame) {
                    return (MaterializedFrame)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="blockGiven(NotProvided)", value=CExtNodes.BlockGivenNode.class)
            private static final class BlockGiven1Node_
            extends BaseNode_ {
                BlockGiven1Node_(BlockGivenNodeGen root) {
                    super(root, 2);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    NotProvided arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.blockGiven(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof NotProvided) {
                        NotProvided arguments0Value_ = (NotProvided)arguments0Value;
                        return this.root.blockGiven(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BlockGivenNodeGen root) {
                    return new BlockGiven1Node_(root);
                }
            }

            @GeneratedBy(methodName="blockGiven(MaterializedFrame, ConditionProfile)", value=CExtNodes.BlockGivenNode.class)
            private static final class BlockGiven0Node_
            extends BaseNode_ {
                private final ConditionProfile blockProfile;

                BlockGiven0Node_(BlockGivenNodeGen root, ConditionProfile blockProfile) {
                    super(root, 1);
                    this.blockProfile = blockProfile;
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    MaterializedFrame arguments0Value_;
                    try {
                        arguments0Value_ = BlockGivenNodeGen.expectMaterializedFrame(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.blockGiven(arguments0Value_, this.blockProfile);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof MaterializedFrame) {
                        MaterializedFrame arguments0Value_ = (MaterializedFrame)arguments0Value;
                        return this.root.blockGiven(arguments0Value_, this.blockProfile);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BlockGivenNodeGen root, ConditionProfile blockProfile) {
                    return new BlockGiven0Node_(root, blockProfile);
                }
            }

            @GeneratedBy(value=CExtNodes.BlockGivenNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(BlockGivenNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BlockGivenNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.BlockGivenNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(BlockGivenNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(BlockGivenNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.BlockGivenNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected BlockGivenNodeGen root;

                BaseNode_(BlockGivenNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (BlockGivenNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof MaterializedFrame) {
                        ConditionProfile blockProfile1 = ConditionProfile.createBinaryProfile();
                        return BlockGiven0Node_.create(this.root, blockProfile1);
                    }
                    if (arguments0Value instanceof NotProvided) {
                        return BlockGiven1Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.ToRubyStringNode.class)
    public static final class ToRubyStringNodeFactory
    extends NodeFactoryBase<CExtNodes.ToRubyStringNode> {
        private static ToRubyStringNodeFactory toRubyStringNodeFactoryInstance;

        private ToRubyStringNodeFactory() {
            super(CExtNodes.ToRubyStringNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.ToRubyStringNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ToRubyStringNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.ToRubyStringNode> getInstance() {
            if (toRubyStringNodeFactoryInstance == null) {
                toRubyStringNodeFactoryInstance = new ToRubyStringNodeFactory();
            }
            return toRubyStringNodeFactoryInstance;
        }

        public static CExtNodes.ToRubyStringNode create(RubyNode[] arguments) {
            return new ToRubyStringNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.ToRubyStringNode.class)
        public static final class ToRubyStringNodeGen
        extends CExtNodes.ToRubyStringNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private ToRubyStringNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="toRubyString(DynamicObject)", value=CExtNodes.ToRubyStringNode.class)
            private static final class ToRubyString1Node_
            extends BaseNode_ {
                ToRubyString1Node_(ToRubyStringNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.toRubyString(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToRubyStringNodeGen root) {
                    return new ToRubyString1Node_(root);
                }
            }

            @GeneratedBy(methodName="toRubyString(CExtString)", value=CExtNodes.ToRubyStringNode.class)
            private static final class ToRubyString0Node_
            extends BaseNode_ {
                ToRubyString0Node_(ToRubyStringNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof CExtString) {
                        CExtString arguments0Value_ = (CExtString)arguments0Value;
                        return this.root.toRubyString(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToRubyStringNodeGen root) {
                    return new ToRubyString0Node_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.ToRubyStringNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ToRubyStringNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ToRubyStringNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.ToRubyStringNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ToRubyStringNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ToRubyStringNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.ToRubyStringNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ToRubyStringNodeGen root;

                BaseNode_(ToRubyStringNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ToRubyStringNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof CExtString) {
                        return ToRubyString0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return ToRubyString1Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.CExtStringNode.class)
    public static final class CExtStringNodeFactory
    extends NodeFactoryBase<CExtNodes.CExtStringNode> {
        private static CExtStringNodeFactory cExtStringNodeFactoryInstance;

        private CExtStringNodeFactory() {
            super(CExtNodes.CExtStringNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.CExtStringNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CExtStringNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.CExtStringNode> getInstance() {
            if (cExtStringNodeFactoryInstance == null) {
                cExtStringNodeFactoryInstance = new CExtStringNodeFactory();
            }
            return cExtStringNodeFactoryInstance;
        }

        public static CExtNodes.CExtStringNode create(RubyNode[] arguments) {
            return new CExtStringNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.CExtStringNode.class)
        public static final class CExtStringNodeGen
        extends CExtNodes.CExtStringNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private CExtStringNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyString(arguments0Value_)) {
                    return this.cExtString(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=CExtNodes.Long2Int.class)
    public static final class Long2IntFactory
    extends NodeFactoryBase<CExtNodes.Long2Int> {
        private static Long2IntFactory long2IntFactoryInstance;

        private Long2IntFactory() {
            super(CExtNodes.Long2Int.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.Long2Int createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return Long2IntFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.Long2Int> getInstance() {
            if (long2IntFactoryInstance == null) {
                long2IntFactoryInstance = new Long2IntFactory();
            }
            return long2IntFactoryInstance;
        }

        public static CExtNodes.Long2Int create(RubyNode[] arguments) {
            return new Long2IntNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.Long2Int.class)
        public static final class Long2IntNodeGen
        extends CExtNodes.Long2Int
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private Long2IntNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="long2fixOutOfRange(long)", value=CExtNodes.Long2Int.class)
            private static final class Long2fixOutOfRangeNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Long2fixOutOfRangeNode_(Long2IntNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Long2fixOutOfRangeNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    if (!this.root.fitsIntoInteger(arguments0Value_)) {
                        return this.root.long2fixOutOfRange(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && !this.root.fitsIntoInteger(arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType))) {
                        return this.root.long2fixOutOfRange(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Long2IntNodeGen root, Object arguments0Value) {
                    return new Long2fixOutOfRangeNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="long2fixInRange(long)", value=CExtNodes.Long2Int.class)
            private static final class Long2fixInRangeNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Long2fixInRangeNode_(Long2IntNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Long2fixInRangeNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    if (this.root.fitsIntoInteger(arguments0Value_)) {
                        return this.root.long2fixInRange(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && this.root.fitsIntoInteger(arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType))) {
                        return this.root.long2fixInRange(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Long2IntNodeGen root, Object arguments0Value) {
                    return new Long2fixInRangeNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="long2fix(int)", value=CExtNodes.Long2Int.class)
            private static final class Long2fixNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Long2fixNode_(Long2IntNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Long2fixNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.long2fix(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.long2fix(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Long2IntNodeGen root, Object arguments0Value) {
                    return new Long2fixNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=CExtNodes.Long2Int.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(Long2IntNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Long2IntNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.Long2Int.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(Long2IntNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(Long2IntNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.Long2Int.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected Long2IntNodeGen root;

                BaseNode_(Long2IntNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (Long2IntNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Long2fixNode_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value);
                        if (this.root.fitsIntoInteger(arguments0Value_)) {
                            return Long2fixInRangeNode_.create(this.root, arguments0Value);
                        }
                        return Long2fixOutOfRangeNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return RubyTypesGen.expectImplicitLong(arguments0Value_, arguments0ImplicitType);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.LONG2FIXNode.class)
    public static final class LONG2FIXNodeFactory
    extends NodeFactoryBase<CExtNodes.LONG2FIXNode> {
        private static LONG2FIXNodeFactory lONG2FIXNodeFactoryInstance;

        private LONG2FIXNodeFactory() {
            super(CExtNodes.LONG2FIXNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.LONG2FIXNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return LONG2FIXNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.LONG2FIXNode> getInstance() {
            if (lONG2FIXNodeFactoryInstance == null) {
                lONG2FIXNodeFactoryInstance = new LONG2FIXNodeFactory();
            }
            return lONG2FIXNodeFactoryInstance;
        }

        public static CExtNodes.LONG2FIXNode create(RubyNode[] arguments) {
            return new LONG2FIXNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.LONG2FIXNode.class)
        public static final class LONG2FIXNodeGen
        extends CExtNodes.LONG2FIXNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LONG2FIXNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="long2fix(int)", value=CExtNodes.LONG2FIXNode.class)
            private static final class Long2fixNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Long2fixNode_(LONG2FIXNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Long2fixNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.long2fix(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.long2fix(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LONG2FIXNodeGen root, Object arguments0Value) {
                    return new Long2fixNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=CExtNodes.LONG2FIXNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LONG2FIXNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LONG2FIXNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.LONG2FIXNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LONG2FIXNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(LONG2FIXNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.LONG2FIXNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LONG2FIXNodeGen root;

                BaseNode_(LONG2FIXNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (LONG2FIXNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Long2fixNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.ULONG2NUMNode.class)
    public static final class ULONG2NUMNodeFactory
    extends NodeFactoryBase<CExtNodes.ULONG2NUMNode> {
        private static ULONG2NUMNodeFactory uLONG2NUMNodeFactoryInstance;

        private ULONG2NUMNodeFactory() {
            super(CExtNodes.ULONG2NUMNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.ULONG2NUMNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ULONG2NUMNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.ULONG2NUMNode> getInstance() {
            if (uLONG2NUMNodeFactoryInstance == null) {
                uLONG2NUMNodeFactoryInstance = new ULONG2NUMNodeFactory();
            }
            return uLONG2NUMNodeFactoryInstance;
        }

        public static CExtNodes.ULONG2NUMNode create(RubyNode[] arguments) {
            return new ULONG2NUMNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.ULONG2NUMNode.class)
        public static final class ULONG2NUMNodeGen
        extends CExtNodes.ULONG2NUMNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ULONG2NUMNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="ulong2num(int)", value=CExtNodes.ULONG2NUMNode.class)
            private static final class Ulong2numNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Ulong2numNode_(ULONG2NUMNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Ulong2numNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.ulong2num(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.ulong2num(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ULONG2NUMNodeGen root, Object arguments0Value) {
                    return new Ulong2numNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=CExtNodes.ULONG2NUMNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ULONG2NUMNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ULONG2NUMNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.ULONG2NUMNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ULONG2NUMNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ULONG2NUMNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.ULONG2NUMNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ULONG2NUMNodeGen root;

                BaseNode_(ULONG2NUMNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ULONG2NUMNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Ulong2numNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.LONG2NUMNode.class)
    public static final class LONG2NUMNodeFactory
    extends NodeFactoryBase<CExtNodes.LONG2NUMNode> {
        private static LONG2NUMNodeFactory lONG2NUMNodeFactoryInstance;

        private LONG2NUMNodeFactory() {
            super(CExtNodes.LONG2NUMNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.LONG2NUMNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return LONG2NUMNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.LONG2NUMNode> getInstance() {
            if (lONG2NUMNodeFactoryInstance == null) {
                lONG2NUMNodeFactoryInstance = new LONG2NUMNodeFactory();
            }
            return lONG2NUMNodeFactoryInstance;
        }

        public static CExtNodes.LONG2NUMNode create(RubyNode[] arguments) {
            return new LONG2NUMNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.LONG2NUMNode.class)
        public static final class LONG2NUMNodeGen
        extends CExtNodes.LONG2NUMNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LONG2NUMNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="long2num(int)", value=CExtNodes.LONG2NUMNode.class)
            private static final class Long2numNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Long2numNode_(LONG2NUMNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Long2numNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.long2num(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.long2num(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LONG2NUMNodeGen root, Object arguments0Value) {
                    return new Long2numNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=CExtNodes.LONG2NUMNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LONG2NUMNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LONG2NUMNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.LONG2NUMNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LONG2NUMNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(LONG2NUMNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.LONG2NUMNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LONG2NUMNodeGen root;

                BaseNode_(LONG2NUMNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (LONG2NUMNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Long2numNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.UINT2NUMNode.class)
    public static final class UINT2NUMNodeFactory
    extends NodeFactoryBase<CExtNodes.UINT2NUMNode> {
        private static UINT2NUMNodeFactory uINT2NUMNodeFactoryInstance;

        private UINT2NUMNodeFactory() {
            super(CExtNodes.UINT2NUMNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.UINT2NUMNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return UINT2NUMNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.UINT2NUMNode> getInstance() {
            if (uINT2NUMNodeFactoryInstance == null) {
                uINT2NUMNodeFactoryInstance = new UINT2NUMNodeFactory();
            }
            return uINT2NUMNodeFactoryInstance;
        }

        public static CExtNodes.UINT2NUMNode create(RubyNode[] arguments) {
            return new UINT2NUMNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.UINT2NUMNode.class)
        public static final class UINT2NUMNodeGen
        extends CExtNodes.UINT2NUMNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private UINT2NUMNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="uint2num(int)", value=CExtNodes.UINT2NUMNode.class)
            private static final class Uint2numNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Uint2numNode_(UINT2NUMNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Uint2numNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.uint2num(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.uint2num(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UINT2NUMNodeGen root, Object arguments0Value) {
                    return new Uint2numNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=CExtNodes.UINT2NUMNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(UINT2NUMNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UINT2NUMNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.UINT2NUMNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(UINT2NUMNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(UINT2NUMNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.UINT2NUMNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected UINT2NUMNodeGen root;

                BaseNode_(UINT2NUMNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (UINT2NUMNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Uint2numNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.INT2FIXNode.class)
    public static final class INT2FIXNodeFactory
    extends NodeFactoryBase<CExtNodes.INT2FIXNode> {
        private static INT2FIXNodeFactory iNT2FIXNodeFactoryInstance;

        private INT2FIXNodeFactory() {
            super(CExtNodes.INT2FIXNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.INT2FIXNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return INT2FIXNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.INT2FIXNode> getInstance() {
            if (iNT2FIXNodeFactoryInstance == null) {
                iNT2FIXNodeFactoryInstance = new INT2FIXNodeFactory();
            }
            return iNT2FIXNodeFactoryInstance;
        }

        public static CExtNodes.INT2FIXNode create(RubyNode[] arguments) {
            return new INT2FIXNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.INT2FIXNode.class)
        public static final class INT2FIXNodeGen
        extends CExtNodes.INT2FIXNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private INT2FIXNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="int2fix(long)", value=CExtNodes.INT2FIXNode.class)
            private static final class Int2fix1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Int2fix1Node_(INT2FIXNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Int2fix1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return INT2FIXNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.int2fix(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.int2fix(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(INT2FIXNodeGen root, Object arguments0Value) {
                    return new Int2fix1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="int2fix(int)", value=CExtNodes.INT2FIXNode.class)
            private static final class Int2fix0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Int2fix0Node_(INT2FIXNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Int2fix0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return INT2FIXNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.int2fix(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.int2fix(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(INT2FIXNodeGen root, Object arguments0Value) {
                    return new Int2fix0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=CExtNodes.INT2FIXNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(INT2FIXNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(INT2FIXNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.INT2FIXNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(INT2FIXNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(INT2FIXNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.INT2FIXNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected INT2FIXNodeGen root;

                BaseNode_(INT2FIXNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (INT2FIXNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return INT2FIXNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return INT2FIXNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Int2fix0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Int2fix1Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.INT2NUMNode.class)
    public static final class INT2NUMNodeFactory
    extends NodeFactoryBase<CExtNodes.INT2NUMNode> {
        private static INT2NUMNodeFactory iNT2NUMNodeFactoryInstance;

        private INT2NUMNodeFactory() {
            super(CExtNodes.INT2NUMNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.INT2NUMNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return INT2NUMNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.INT2NUMNode> getInstance() {
            if (iNT2NUMNodeFactoryInstance == null) {
                iNT2NUMNodeFactoryInstance = new INT2NUMNodeFactory();
            }
            return iNT2NUMNodeFactoryInstance;
        }

        public static CExtNodes.INT2NUMNode create(RubyNode[] arguments) {
            return new INT2NUMNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.INT2NUMNode.class)
        public static final class INT2NUMNodeGen
        extends CExtNodes.INT2NUMNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private INT2NUMNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="int2num(long)", value=CExtNodes.INT2NUMNode.class)
            private static final class Int2num1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Int2num1Node_(INT2NUMNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Int2num1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return INT2NUMNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.int2num(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.int2num(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(INT2NUMNodeGen root, Object arguments0Value) {
                    return new Int2num1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="int2num(int)", value=CExtNodes.INT2NUMNode.class)
            private static final class Int2num0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Int2num0Node_(INT2NUMNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Int2num0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return INT2NUMNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.int2num(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.int2num(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(INT2NUMNodeGen root, Object arguments0Value) {
                    return new Int2num0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=CExtNodes.INT2NUMNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(INT2NUMNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(INT2NUMNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.INT2NUMNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(INT2NUMNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(INT2NUMNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.INT2NUMNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected INT2NUMNodeGen root;

                BaseNode_(INT2NUMNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (INT2NUMNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return INT2NUMNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return INT2NUMNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Int2num0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Int2num1Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.FIX2LONGNode.class)
    public static final class FIX2LONGNodeFactory
    extends NodeFactoryBase<CExtNodes.FIX2LONGNode> {
        private static FIX2LONGNodeFactory fIX2LONGNodeFactoryInstance;

        private FIX2LONGNodeFactory() {
            super(CExtNodes.FIX2LONGNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.FIX2LONGNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return FIX2LONGNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.FIX2LONGNode> getInstance() {
            if (fIX2LONGNodeFactoryInstance == null) {
                fIX2LONGNodeFactoryInstance = new FIX2LONGNodeFactory();
            }
            return fIX2LONGNodeFactoryInstance;
        }

        public static CExtNodes.FIX2LONGNode create(RubyNode[] arguments) {
            return new FIX2LONGNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.FIX2LONGNode.class)
        public static final class FIX2LONGNodeGen
        extends CExtNodes.FIX2LONGNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private FIX2LONGNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="fix2long(int)", value=CExtNodes.FIX2LONGNode.class)
            private static final class Fix2longNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Fix2longNode_(FIX2LONGNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Fix2longNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeLong(frameValue);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, ex.getResult());
                    }
                    return this.root.fix2long(arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.fix2long(arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FIX2LONGNodeGen root, Object arguments0Value) {
                    return new Fix2longNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=CExtNodes.FIX2LONGNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(FIX2LONGNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeLong_(frameValue, arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FIX2LONGNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.FIX2LONGNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(FIX2LONGNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Long)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(FIX2LONGNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.FIX2LONGNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected FIX2LONGNodeGen root;

                BaseNode_(FIX2LONGNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (FIX2LONGNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeLong_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract long executeLong_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeLong_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public long executeLong(VirtualFrame frameValue) {
                    return (Long)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Fix2longNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.FIX2UINTNode.class)
    public static final class FIX2UINTNodeFactory
    extends NodeFactoryBase<CExtNodes.FIX2UINTNode> {
        private static FIX2UINTNodeFactory fIX2UINTNodeFactoryInstance;

        private FIX2UINTNodeFactory() {
            super(CExtNodes.FIX2UINTNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.FIX2UINTNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return FIX2UINTNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.FIX2UINTNode> getInstance() {
            if (fIX2UINTNodeFactoryInstance == null) {
                fIX2UINTNodeFactoryInstance = new FIX2UINTNodeFactory();
            }
            return fIX2UINTNodeFactoryInstance;
        }

        public static CExtNodes.FIX2UINTNode create(RubyNode[] arguments) {
            return new FIX2UINTNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.FIX2UINTNode.class)
        public static final class FIX2UINTNodeGen
        extends CExtNodes.FIX2UINTNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private FIX2UINTNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="fix2uint(long)", value=CExtNodes.FIX2UINTNode.class)
            private static final class Fix2uint1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Fix2uint1Node_(FIX2UINTNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Fix2uint1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return FIX2UINTNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.fix2uint(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.fix2uint(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FIX2UINTNodeGen root, Object arguments0Value) {
                    return new Fix2uint1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="fix2uint(int)", value=CExtNodes.FIX2UINTNode.class)
            private static final class Fix2uint0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Fix2uint0Node_(FIX2UINTNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Fix2uint0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return FIX2UINTNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.fix2uint(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.fix2uint(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FIX2UINTNodeGen root, Object arguments0Value) {
                    return new Fix2uint0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=CExtNodes.FIX2UINTNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(FIX2UINTNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FIX2UINTNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.FIX2UINTNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(FIX2UINTNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(FIX2UINTNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.FIX2UINTNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected FIX2UINTNodeGen root;

                BaseNode_(FIX2UINTNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (FIX2UINTNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return FIX2UINTNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return FIX2UINTNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Fix2uint0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Fix2uint1Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.FIX2INTNode.class)
    public static final class FIX2INTNodeFactory
    extends NodeFactoryBase<CExtNodes.FIX2INTNode> {
        private static FIX2INTNodeFactory fIX2INTNodeFactoryInstance;

        private FIX2INTNodeFactory() {
            super(CExtNodes.FIX2INTNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.FIX2INTNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return FIX2INTNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.FIX2INTNode> getInstance() {
            if (fIX2INTNodeFactoryInstance == null) {
                fIX2INTNodeFactoryInstance = new FIX2INTNodeFactory();
            }
            return fIX2INTNodeFactoryInstance;
        }

        public static CExtNodes.FIX2INTNode create(RubyNode[] arguments) {
            return new FIX2INTNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.FIX2INTNode.class)
        public static final class FIX2INTNodeGen
        extends CExtNodes.FIX2INTNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private FIX2INTNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="fix2int(int)", value=CExtNodes.FIX2INTNode.class)
            private static final class Fix2intNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Fix2intNode_(FIX2INTNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Fix2intNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.fix2int(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.fix2int(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FIX2INTNodeGen root, Object arguments0Value) {
                    return new Fix2intNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=CExtNodes.FIX2INTNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(FIX2INTNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FIX2INTNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.FIX2INTNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(FIX2INTNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(FIX2INTNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.FIX2INTNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected FIX2INTNodeGen root;

                BaseNode_(FIX2INTNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (FIX2INTNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Fix2intNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.NUM2DBLNode.class)
    public static final class NUM2DBLNodeFactory
    extends NodeFactoryBase<CExtNodes.NUM2DBLNode> {
        private static NUM2DBLNodeFactory nUM2DBLNodeFactoryInstance;

        private NUM2DBLNodeFactory() {
            super(CExtNodes.NUM2DBLNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.NUM2DBLNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return NUM2DBLNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.NUM2DBLNode> getInstance() {
            if (nUM2DBLNodeFactoryInstance == null) {
                nUM2DBLNodeFactoryInstance = new NUM2DBLNodeFactory();
            }
            return nUM2DBLNodeFactoryInstance;
        }

        public static CExtNodes.NUM2DBLNode create(RubyNode[] arguments) {
            return new NUM2DBLNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.NUM2DBLNode.class)
        public static final class NUM2DBLNodeGen
        extends CExtNodes.NUM2DBLNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private NUM2DBLNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="num2dbl(int)", value=CExtNodes.NUM2DBLNode.class)
            private static final class Num2dblNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Num2dblNode_(NUM2DBLNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Num2dblNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.num2dbl(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.num2dbl(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NUM2DBLNodeGen root, Object arguments0Value) {
                    return new Num2dblNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=CExtNodes.NUM2DBLNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(NUM2DBLNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NUM2DBLNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.NUM2DBLNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(NUM2DBLNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(NUM2DBLNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.NUM2DBLNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected NUM2DBLNodeGen root;

                BaseNode_(NUM2DBLNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (NUM2DBLNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Num2dblNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.NUM2ULONGNode.class)
    public static final class NUM2ULONGNodeFactory
    extends NodeFactoryBase<CExtNodes.NUM2ULONGNode> {
        private static NUM2ULONGNodeFactory nUM2ULONGNodeFactoryInstance;

        private NUM2ULONGNodeFactory() {
            super(CExtNodes.NUM2ULONGNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.NUM2ULONGNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return NUM2ULONGNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.NUM2ULONGNode> getInstance() {
            if (nUM2ULONGNodeFactoryInstance == null) {
                nUM2ULONGNodeFactoryInstance = new NUM2ULONGNodeFactory();
            }
            return nUM2ULONGNodeFactoryInstance;
        }

        public static CExtNodes.NUM2ULONGNode create(RubyNode[] arguments) {
            return new NUM2ULONGNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.NUM2ULONGNode.class)
        public static final class NUM2ULONGNodeGen
        extends CExtNodes.NUM2ULONGNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private NUM2ULONGNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="num2ulong(int)", value=CExtNodes.NUM2ULONGNode.class)
            private static final class Num2ulongNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Num2ulongNode_(NUM2ULONGNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Num2ulongNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeLong(frameValue);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, ex.getResult());
                    }
                    return this.root.num2ulong(arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.num2ulong(arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NUM2ULONGNodeGen root, Object arguments0Value) {
                    return new Num2ulongNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=CExtNodes.NUM2ULONGNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(NUM2ULONGNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeLong_(frameValue, arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NUM2ULONGNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.NUM2ULONGNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(NUM2ULONGNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Long)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(NUM2ULONGNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.NUM2ULONGNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected NUM2ULONGNodeGen root;

                BaseNode_(NUM2ULONGNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (NUM2ULONGNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeLong_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract long executeLong_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeLong_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public long executeLong(VirtualFrame frameValue) {
                    return (Long)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Num2ulongNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.NUM2LONGNode.class)
    public static final class NUM2LONGNodeFactory
    extends NodeFactoryBase<CExtNodes.NUM2LONGNode> {
        private static NUM2LONGNodeFactory nUM2LONGNodeFactoryInstance;

        private NUM2LONGNodeFactory() {
            super(CExtNodes.NUM2LONGNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.NUM2LONGNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return NUM2LONGNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.NUM2LONGNode> getInstance() {
            if (nUM2LONGNodeFactoryInstance == null) {
                nUM2LONGNodeFactoryInstance = new NUM2LONGNodeFactory();
            }
            return nUM2LONGNodeFactoryInstance;
        }

        public static CExtNodes.NUM2LONGNode create(RubyNode[] arguments) {
            return new NUM2LONGNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.NUM2LONGNode.class)
        public static final class NUM2LONGNodeGen
        extends CExtNodes.NUM2LONGNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private NUM2LONGNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="num2long(int)", value=CExtNodes.NUM2LONGNode.class)
            private static final class Num2longNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Num2longNode_(NUM2LONGNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Num2longNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeLong(frameValue);
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeLong_(frameValue, ex.getResult());
                    }
                    return this.root.num2long(arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.num2long(arguments0Value_);
                    }
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NUM2LONGNodeGen root, Object arguments0Value) {
                    return new Num2longNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=CExtNodes.NUM2LONGNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(NUM2LONGNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public long executeLong(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeLong_(frameValue, arguments0Value_);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeLong_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NUM2LONGNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.NUM2LONGNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(NUM2LONGNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public long executeLong_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Long)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(NUM2LONGNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.NUM2LONGNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected NUM2LONGNodeGen root;

                BaseNode_(NUM2LONGNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (NUM2LONGNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeLong_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract long executeLong_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeLong_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public long executeLong(VirtualFrame frameValue) {
                    return (Long)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Num2longNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.NUM2UINTNode.class)
    public static final class NUM2UINTNodeFactory
    extends NodeFactoryBase<CExtNodes.NUM2UINTNode> {
        private static NUM2UINTNodeFactory nUM2UINTNodeFactoryInstance;

        private NUM2UINTNodeFactory() {
            super(CExtNodes.NUM2UINTNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.NUM2UINTNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return NUM2UINTNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.NUM2UINTNode> getInstance() {
            if (nUM2UINTNodeFactoryInstance == null) {
                nUM2UINTNodeFactoryInstance = new NUM2UINTNodeFactory();
            }
            return nUM2UINTNodeFactoryInstance;
        }

        public static CExtNodes.NUM2UINTNode create(RubyNode[] arguments) {
            return new NUM2UINTNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.NUM2UINTNode.class)
        public static final class NUM2UINTNodeGen
        extends CExtNodes.NUM2UINTNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private NUM2UINTNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="num2uint(int)", value=CExtNodes.NUM2UINTNode.class)
            private static final class Num2uintNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Num2uintNode_(NUM2UINTNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Num2uintNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.num2uint(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.num2uint(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NUM2UINTNodeGen root, Object arguments0Value) {
                    return new Num2uintNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=CExtNodes.NUM2UINTNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(NUM2UINTNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NUM2UINTNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.NUM2UINTNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(NUM2UINTNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(NUM2UINTNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.NUM2UINTNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected NUM2UINTNodeGen root;

                BaseNode_(NUM2UINTNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (NUM2UINTNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Num2uintNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=CExtNodes.NUM2INTNode.class)
    public static final class NUM2INTNodeFactory
    extends NodeFactoryBase<CExtNodes.NUM2INTNode> {
        private static NUM2INTNodeFactory nUM2INTNodeFactoryInstance;

        private NUM2INTNodeFactory() {
            super(CExtNodes.NUM2INTNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public CExtNodes.NUM2INTNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return NUM2INTNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<CExtNodes.NUM2INTNode> getInstance() {
            if (nUM2INTNodeFactoryInstance == null) {
                nUM2INTNodeFactoryInstance = new NUM2INTNodeFactory();
            }
            return nUM2INTNodeFactoryInstance;
        }

        public static CExtNodes.NUM2INTNode create(RubyNode[] arguments) {
            return new NUM2INTNodeGen(arguments);
        }

        @GeneratedBy(value=CExtNodes.NUM2INTNode.class)
        public static final class NUM2INTNodeGen
        extends CExtNodes.NUM2INTNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private NUM2INTNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="num2int(int)", value=CExtNodes.NUM2INTNode.class)
            private static final class Num2intNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Num2intNode_(NUM2INTNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Num2intNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, ex.getResult());
                    }
                    return this.root.num2int(arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.num2int(arguments0Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NUM2INTNodeGen root, Object arguments0Value) {
                    return new Num2intNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=CExtNodes.NUM2INTNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(NUM2INTNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NUM2INTNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.NUM2INTNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(NUM2INTNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(NUM2INTNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=CExtNodes.NUM2INTNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected NUM2INTNodeGen root;

                BaseNode_(NUM2INTNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (NUM2INTNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Num2intNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }
}

