/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.dispatch.CachedDispatchNode;
import org.jruby.truffle.language.dispatch.DispatchAction;
import org.jruby.truffle.language.dispatch.DispatchNode;
import org.jruby.truffle.language.methods.InternalMethod;

public class CachedBooleanDispatchNode
extends CachedDispatchNode {
    private final Assumption falseUnmodifiedAssumption;
    private final InternalMethod falseMethod;
    private final BranchProfile falseProfile = BranchProfile.create();
    @Node.Child
    private DirectCallNode falseCallDirect;
    private final Assumption trueUnmodifiedAssumption;
    private final InternalMethod trueMethod;
    private final BranchProfile trueProfile = BranchProfile.create();
    @Node.Child
    private DirectCallNode trueCallDirect;

    public CachedBooleanDispatchNode(RubyContext context, Object cachedName, DispatchNode next, Assumption falseUnmodifiedAssumption, InternalMethod falseMethod, Assumption trueUnmodifiedAssumption, InternalMethod trueMethod, DispatchAction dispatchAction) {
        super(context, cachedName, next, dispatchAction);
        this.falseUnmodifiedAssumption = falseUnmodifiedAssumption;
        this.falseMethod = falseMethod;
        if (falseMethod != null) {
            this.falseCallDirect = Truffle.getRuntime().createDirectCallNode(falseMethod.getCallTarget());
            this.applySplittingInliningStrategy(this.falseCallDirect, falseMethod);
        }
        this.trueUnmodifiedAssumption = trueUnmodifiedAssumption;
        this.trueMethod = trueMethod;
        if (trueMethod != null) {
            this.trueCallDirect = Truffle.getRuntime().createDirectCallNode(trueMethod.getCallTarget());
            this.applySplittingInliningStrategy(this.trueCallDirect, trueMethod);
        }
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return this.guardName(methodName) && receiver instanceof Boolean;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object[] argumentsObjects) {
        try {
            this.trueUnmodifiedAssumption.check();
            this.falseUnmodifiedAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            return this.resetAndDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects, "class modified");
        }
        if (!this.guard(methodName, receiverObject)) {
            return this.next.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        if (((Boolean)receiverObject).booleanValue()) {
            this.trueProfile.enter();
            switch (this.getDispatchAction()) {
                case CALL_METHOD: {
                    return CachedBooleanDispatchNode.call(this.trueCallDirect, frame, this.trueMethod, receiverObject, blockObject, argumentsObjects);
                }
                case RESPOND_TO_METHOD: {
                    return true;
                }
            }
            throw new UnsupportedOperationException();
        }
        this.falseProfile.enter();
        switch (this.getDispatchAction()) {
            case CALL_METHOD: {
                return CachedBooleanDispatchNode.call(this.falseCallDirect, frame, this.falseMethod, receiverObject, blockObject, argumentsObjects);
            }
            case RESPOND_TO_METHOD: {
                return true;
            }
        }
        throw new UnsupportedOperationException();
    }
}

