/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import proguard.gui.GUIResources;

abstract class ListPanel
extends JPanel {
    protected final DefaultListModel listModel = new DefaultListModel();
    protected final JList list = new JList(this.listModel);
    protected int firstSelectionButton = 2;

    protected ListPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListPanel.this.enableSelectionButtons();
            }
        });
        this.add((Component)new JScrollPane(this.list), gridBagConstraints);
    }

    protected void addRemoveButton() {
        JButton jButton = new JButton(ListPanel.msg("remove"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListPanel.this.removeElementsAt(ListPanel.this.list.getSelectedIndices());
            }
        });
        this.addButton(ListPanel.tip(jButton, "removeTip"));
    }

    protected void addUpButton() {
        JButton jButton = new JButton(ListPanel.msg("moveUp"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ListPanel.this.list.getSelectedIndices();
                if (nArray.length > 0 && nArray[0] > 0) {
                    ListPanel.this.moveElementsAt(nArray, -1);
                }
            }
        });
        this.addButton(ListPanel.tip(jButton, "moveUpTip"));
    }

    protected void addDownButton() {
        JButton jButton = new JButton(ListPanel.msg("moveDown"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ListPanel.this.list.getSelectedIndices();
                if (nArray.length > 0 && nArray[nArray.length - 1] < ListPanel.this.listModel.getSize() - 1) {
                    ListPanel.this.moveElementsAt(nArray, 1);
                }
            }
        });
        this.addButton(ListPanel.tip(jButton, "moveDownTip"));
    }

    public void addCopyToPanelButton(String string, String string2, final ListPanel listPanel) {
        JButton jButton = new JButton(ListPanel.msg(string));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ListPanel.this.list.getSelectedIndices();
                Object[] objectArray = ListPanel.this.list.getSelectedValues();
                ListPanel.this.removeElementsAt(nArray);
                listPanel.addElements(objectArray);
            }
        });
        this.addButton(ListPanel.tip(jButton, string2));
    }

    protected void addButton(JComponent jComponent) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)jComponent, gridBagConstraints);
    }

    public List getButtons() {
        ArrayList<Component> arrayList = new ArrayList<Component>(this.getComponentCount() - 1);
        for (int i = 1; i < this.getComponentCount(); ++i) {
            arrayList.add(this.getComponent(i));
        }
        return arrayList;
    }

    protected void addElement(Object object) {
        this.listModel.addElement(object);
        this.list.setSelectedIndex(this.listModel.size() - 1);
    }

    protected void addElements(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.listModel.addElement(objectArray[i]);
        }
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.listModel.size() - nArray.length + i;
        }
        this.list.setSelectedIndices(nArray);
    }

    protected void moveElementsAt(int[] nArray, int n) {
        Object[] objectArray = this.list.getSelectedValues();
        this.removeElementsAt(nArray);
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2++;
            nArray[n3] = nArray[n3] + n;
        }
        this.insertElementsAt(objectArray, nArray);
    }

    protected void insertElementsAt(Object[] objectArray, int[] nArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.listModel.insertElementAt(objectArray[i], nArray[i]);
        }
        this.list.setSelectedIndices(nArray);
    }

    protected void setElementAt(Object object, int n) {
        this.listModel.setElementAt(object, n);
        this.list.setSelectedIndex(n);
    }

    protected void setElementsAt(Object[] objectArray, int[] nArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.listModel.setElementAt(objectArray[i], nArray[i]);
        }
        this.list.setSelectedIndices(nArray);
    }

    protected void removeElementsAt(int[] nArray) {
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.listModel.removeElementAt(nArray[i]);
        }
        this.list.clearSelection();
        this.enableSelectionButtons();
    }

    protected void removeAllElements() {
        this.listModel.removeAllElements();
        this.enableSelectionButtons();
    }

    protected void enableSelectionButtons() {
        boolean bl = !this.list.isSelectionEmpty();
        for (int i = this.firstSelectionButton; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setEnabled(bl);
        }
    }

    private static JComponent tip(JComponent jComponent, String string) {
        jComponent.setToolTipText(ListPanel.msg(string));
        return jComponent;
    }

    private static String msg(String string) {
        return GUIResources.getMessage(string);
    }
}

