/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.hsqldb.Server;
import org.parosproxy.paros.db.DatabaseServer;
import org.parosproxy.paros.extension.option.DatabaseParam;

public class ParosDatabaseServer
implements DatabaseServer {
    public static final int DEFAULT_SERVER_PORT = 9001;
    private static final Logger logger = Logger.getLogger(DatabaseServer.class);
    String mUrl;
    String mUser = "sa";
    String mPassword = "";
    Server mServer = null;
    Connection mConn = null;
    private final DatabaseParam databaseOptions;

    ParosDatabaseServer(String string, DatabaseParam databaseParam) throws ClassNotFoundException, Exception {
        if (databaseParam == null) {
            throw new IllegalArgumentException("Parameter databaseOptions must not be null.");
        }
        this.databaseOptions = databaseParam;
        this.start(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(String string) throws ClassNotFoundException, Exception {
        Object object;
        AutoCloseable autoCloseable;
        Object object2;
        string = string.replaceAll("\\\\", "/");
        boolean bl = false;
        File file = new File(string + ".properties");
        if (file.exists()) {
            object2 = new Properties();
            autoCloseable = null;
            try {
                autoCloseable = new FileInputStream(file);
                ((Properties)object2).load((InputStream)autoCloseable);
            }
            finally {
                block24: {
                    try {
                        if (autoCloseable != null) {
                            ((InputStream)autoCloseable).close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!logger.isDebugEnabled()) break block24;
                        logger.debug((Object)iOException.getMessage(), (Throwable)iOException);
                    }
                }
            }
            object = (String)((Properties)object2).get("version");
            if (((String)object).charAt(0) < '2') {
                bl = true;
            }
        }
        this.mUrl = "jdbc:hsqldb:file:" + string;
        Class.forName("org.hsqldb.jdbcDriver");
        this.mConn = DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
        if (bl) {
            this.shutdown(true);
            this.mConn = DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
        }
        object2 = "SET FILES LOG " + (this.databaseOptions.isRecoveryLogEnabled() ? "TRUE" : "FALSE");
        autoCloseable = this.getSingletonConnection().createStatement();
        object = null;
        try {
            autoCloseable.executeUpdate((String)object2);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (autoCloseable != null) {
                if (object != null) {
                    try {
                        autoCloseable.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    autoCloseable.close();
                }
            }
        }
    }

    void shutdown(boolean bl) throws SQLException {
        Connection connection = this.getSingletonConnection();
        CallableStatement callableStatement = null;
        callableStatement = bl ? connection.prepareCall("SHUTDOWN COMPACT") : connection.prepareCall("SHUTDOWN");
        callableStatement.execute();
        callableStatement.close();
        this.mConn.close();
        this.mConn = null;
    }

    public Connection getNewConnection() throws SQLException {
        Connection connection = null;
        for (int i = 0; i < 5; ++i) {
            try {
                connection = DriverManager.getConnection(this.mUrl, this.mUser, this.mPassword);
                return connection;
            }
            catch (SQLException sQLException) {
                logger.warn((Object)sQLException.getMessage(), (Throwable)sQLException);
                if (i == 4) {
                    throw sQLException;
                }
                logger.warn((Object)("Recovering " + i + " times."));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)interruptedException.getMessage(), (Throwable)interruptedException);
                }
                continue;
            }
        }
        return connection;
    }

    public Connection getSingletonConnection() throws SQLException {
        if (this.mConn == null) {
            this.mConn = this.getNewConnection();
        }
        return this.mConn;
    }
}

