/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty3;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.transport.netty3.Netty3Utils;
import org.jboss.netty.buffer.ChannelBuffer;

class ChannelBufferStreamInput
extends StreamInput {
    private final ChannelBuffer buffer;
    private final int startIndex;
    private final int endIndex;

    public ChannelBufferStreamInput(ChannelBuffer buffer, int length) {
        if (length > buffer.readableBytes()) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer = buffer;
        this.startIndex = buffer.readerIndex();
        this.endIndex = this.startIndex + length;
        buffer.markReaderIndex();
    }

    public BytesReference readBytesReference(int length) throws IOException {
        BytesReference ref = Netty3Utils.toBytesReference(this.buffer.slice(this.buffer.readerIndex(), length));
        this.buffer.skipBytes(length);
        return ref;
    }

    public BytesRef readBytesRef(int length) throws IOException {
        if (!this.buffer.hasArray()) {
            return super.readBytesRef(length);
        }
        BytesRef bytesRef = new BytesRef(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.readerIndex(), length);
        this.buffer.skipBytes(length);
        return bytesRef;
    }

    public int available() throws IOException {
        return this.endIndex - this.buffer.readerIndex();
    }

    public void mark(int readlimit) {
        this.buffer.markReaderIndex();
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.available() == 0) {
            return -1;
        }
        return this.buffer.readByte() & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        len = Math.min(available, len);
        this.buffer.readBytes(b, off, len);
        return len;
    }

    public void reset() throws IOException {
        this.buffer.resetReaderIndex();
    }

    public long skip(long n) throws IOException {
        if (n > Integer.MAX_VALUE) {
            return this.skipBytes(Integer.MAX_VALUE);
        }
        return this.skipBytes((int)n);
    }

    public int skipBytes(int n) throws IOException {
        int nBytes = Math.min(this.available(), n);
        this.buffer.skipBytes(nBytes);
        return nBytes;
    }

    public byte readByte() throws IOException {
        return this.buffer.readByte();
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        int read = this.read(b, offset, len);
        if (read < len) {
            throw new IndexOutOfBoundsException();
        }
    }

    public void close() throws IOException {
    }
}

