/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;

@Deprecated
public class TemplateQueryBuilder
extends AbstractQueryBuilder<TemplateQueryBuilder> {
    public static final String NAME = "template";
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(TemplateQueryBuilder.class));
    private final Script template;

    public TemplateQueryBuilder(String template, ScriptService.ScriptType scriptType, Map<String, Object> params) {
        this(new Script(template, scriptType, "mustache", params));
    }

    public TemplateQueryBuilder(String template, ScriptService.ScriptType scriptType, Map<String, Object> params, XContentType ct) {
        this(new Script(template, scriptType, "mustache", params, ct));
    }

    TemplateQueryBuilder(Script template) {
        DEPRECATION_LOGGER.deprecated("[{}] query is deprecated, use search template api instead", new Object[]{NAME});
        if (template == null) {
            throw new IllegalArgumentException("query template cannot be null");
        }
        this.template = template;
    }

    public Script template() {
        return this.template;
    }

    public TemplateQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.template = new Script(in);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        this.template.writeTo(out);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.field(NAME);
        this.template.toXContent(builder, builderParams);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        throw new UnsupportedOperationException("this query must be rewritten first");
    }

    protected int doHashCode() {
        return Objects.hash(this.template);
    }

    protected boolean doEquals(TemplateQueryBuilder other) {
        return Objects.equals(this.template, other.template);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        BytesReference querySource = queryRewriteContext.getTemplateBytes(this.template);
        try (XContentParser qSourceParser = XContentFactory.xContent((BytesReference)querySource).createParser(querySource);){
            QueryParseContext queryParseContext = queryRewriteContext.newParseContext(qSourceParser);
            QueryBuilder queryBuilder = (QueryBuilder)queryParseContext.parseInnerQueryBuilder().orElseThrow(() -> new ParsingException(qSourceParser.getTokenLocation(), "inner query in [template] cannot be empty", new Object[0]));
            if (this.boost() != 1.0f || this.queryName() != null) {
                BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
                boolQueryBuilder.must(queryBuilder);
                BoolQueryBuilder boolQueryBuilder2 = boolQueryBuilder;
                return boolQueryBuilder2;
            }
            QueryBuilder queryBuilder2 = queryBuilder;
            return queryBuilder2;
        }
    }

    public static Optional<TemplateQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser parser = parseContext.parser();
        Script template = Script.parse((XContentParser)parser, (ParseFieldMatcher)parseContext.getParseFieldMatcher(), (String)"mustache");
        return Optional.of(new TemplateQueryBuilder(template));
    }
}

