/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractTermsParser;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.aggregations.support.XContentParseContext;

public class TermsParser
extends AbstractTermsParser {
    protected TermsAggregationBuilder doCreateFactory(String aggregationName, ValuesSourceType valuesSourceType, ValueType targetValueType, TermsAggregator.BucketCountThresholds bucketCountThresholds, Aggregator.SubAggCollectionMode collectMode, String executionHint, IncludeExclude incExc, Map<ParseField, Object> otherOptions) {
        Boolean showTermDocCountError;
        TermsAggregationBuilder factory = new TermsAggregationBuilder(aggregationName, targetValueType);
        List orderElements = (List)otherOptions.get(TermsAggregationBuilder.ORDER_FIELD);
        if (orderElements != null) {
            ArrayList<Terms.Order> orders = new ArrayList<Terms.Order>(orderElements.size());
            for (OrderElement orderElement : orderElements) {
                orders.add(TermsParser.resolveOrder(orderElement.key(), orderElement.asc()));
            }
            factory.order(orders);
        }
        if (bucketCountThresholds != null) {
            factory.bucketCountThresholds(bucketCountThresholds);
        }
        if (collectMode != null) {
            factory.collectMode(collectMode);
        }
        if (executionHint != null) {
            factory.executionHint(executionHint);
        }
        if (incExc != null) {
            factory.includeExclude(incExc);
        }
        if ((showTermDocCountError = (Boolean)otherOptions.get(TermsAggregationBuilder.SHOW_TERM_DOC_COUNT_ERROR)) != null) {
            factory.showTermDocCountError(showTermDocCountError);
        }
        return factory;
    }

    @Override
    public boolean parseSpecial(String aggregationName, XContentParseContext context, XContentParser.Token token, String currentFieldName, Map<ParseField, Object> otherOptions) throws IOException {
        XContentParser parser = context.getParser();
        if (token == XContentParser.Token.START_OBJECT) {
            if (context.matchField(currentFieldName, TermsAggregationBuilder.ORDER_FIELD)) {
                otherOptions.put(TermsAggregationBuilder.ORDER_FIELD, Collections.singletonList(this.parseOrderParam(aggregationName, parser)));
                return true;
            }
        } else if (token == XContentParser.Token.START_ARRAY) {
            if (context.matchField(currentFieldName, TermsAggregationBuilder.ORDER_FIELD)) {
                ArrayList<OrderElement> orderElements = new ArrayList<OrderElement>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token == XContentParser.Token.START_OBJECT) {
                        OrderElement orderParam = this.parseOrderParam(aggregationName, parser);
                        orderElements.add(orderParam);
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "Order elements must be of type object in [" + aggregationName + "] found token of type [" + (Object)((Object)token) + "].", new Object[0]);
                }
                otherOptions.put(TermsAggregationBuilder.ORDER_FIELD, orderElements);
                return true;
            }
        } else if (token == XContentParser.Token.VALUE_BOOLEAN && context.matchField(currentFieldName, TermsAggregationBuilder.SHOW_TERM_DOC_COUNT_ERROR)) {
            otherOptions.put(TermsAggregationBuilder.SHOW_TERM_DOC_COUNT_ERROR, parser.booleanValue());
            return true;
        }
        return false;
    }

    private OrderElement parseOrderParam(String aggregationName, XContentParser parser) throws IOException {
        XContentParser.Token token;
        OrderElement orderParam = null;
        String orderKey = null;
        boolean orderAsc = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                orderKey = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                String dir = parser.text();
                if ("asc".equalsIgnoreCase(dir)) {
                    orderAsc = true;
                    continue;
                }
                if ("desc".equalsIgnoreCase(dir)) {
                    orderAsc = false;
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown terms order direction [" + dir + "] in terms aggregation [" + aggregationName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "Unexpected token " + (Object)((Object)token) + " for [order] in [" + aggregationName + "].", new Object[0]);
        }
        if (orderKey == null) {
            throw new ParsingException(parser.getTokenLocation(), "Must specify at least one field for [order] in [" + aggregationName + "].", new Object[0]);
        }
        orderParam = new OrderElement(orderKey, orderAsc);
        return orderParam;
    }

    @Override
    public TermsAggregator.BucketCountThresholds getDefaultBucketCountThresholds() {
        return new TermsAggregator.BucketCountThresholds(TermsAggregationBuilder.DEFAULT_BUCKET_COUNT_THRESHOLDS);
    }

    static Terms.Order resolveOrder(String key, boolean asc) {
        if ("_term".equals(key)) {
            return Terms.Order.term(asc);
        }
        if ("_count".equals(key)) {
            return Terms.Order.count(asc);
        }
        return Terms.Order.aggregation(key, asc);
    }

    static class OrderElement {
        private final String key;
        private final boolean asc;

        public OrderElement(String key, boolean asc) {
            this.key = key;
            this.asc = asc;
        }

        public String key() {
            return this.key;
        }

        public boolean asc() {
            return this.asc;
        }
    }
}

