/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTFactory;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.GeneratedMarkerVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.CharTable;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class JavaSharedImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.JavaSharedImplUtil");
    private static final TokenSet BRACKETS = TokenSet.create(JavaTokenType.LBRACKET, JavaTokenType.RBRACKET);

    private JavaSharedImplUtil() {
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor2) {
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaSharedImplUtil", "getType"));
        }
        if (anchor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaSharedImplUtil", "getType"));
        }
        return JavaSharedImplUtil.getType(typeElement, anchor2, null);
    }

    public static PsiType getType(@NotNull PsiTypeElement typeElement, @NotNull PsiElement anchor2, @Nullable PsiAnnotation stopAt) {
        if (typeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaSharedImplUtil", "getType"));
        }
        if (anchor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaSharedImplUtil", "getType"));
        }
        PsiType type2 = typeElement.getType();
        List<PsiAnnotation[]> allAnnotations = JavaSharedImplUtil.collectAnnotations(anchor2, stopAt);
        if (allAnnotations == null) {
            return null;
        }
        for (PsiAnnotation[] annotations2 : allAnnotations) {
            type2 = type2.createArrayType(annotations2);
        }
        return type2;
    }

    private static List<PsiAnnotation[]> collectAnnotations(PsiElement anchor2, PsiAnnotation stopAt) {
        List<PsiAnnotation[]> annotations2 = ContainerUtil.newSmartList();
        List current = null;
        boolean found = stopAt == null;
        boolean stop = false;
        for (PsiElement child = anchor2.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                if (current == null) {
                    current = ContainerUtil.newSmartList();
                }
                current.add((PsiAnnotation)child);
                if (child != stopAt) continue;
                stop = true;
                found = true;
                continue;
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.LBRACKET)) {
                annotations2.add(ContainerUtil.toArray(current, PsiAnnotation.ARRAY_FACTORY));
                current = null;
                if (!stop) continue;
                return annotations2;
            }
            if (!PsiUtil.isJavaToken(child, JavaTokenType.RBRACKET)) break;
        }
        return !found || stop ? null : annotations2;
    }

    public static void normalizeBrackets(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/JavaSharedImplUtil", "normalizeBrackets"));
        }
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        PsiTypeElement typeElement = variable.getTypeElement();
        PsiIdentifier nameElement = variable.getNameIdentifier();
        LOG.assertTrue(typeElement != null && nameElement != null);
        ASTNode type2 = typeElement.getNode();
        ASTNode name = nameElement.getNode();
        ASTNode firstBracket = null;
        ASTNode lastBracket = null;
        int arrayCount = 0;
        ASTNode element = name;
        while (element != null && (element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) != null && element.getElementType() == JavaTokenType.LBRACKET) {
            if (firstBracket == null) {
                firstBracket = element;
            }
            lastBracket = element;
            ++arrayCount;
            if ((element = PsiImplUtil.skipWhitespaceAndComments(element.getTreeNext())) == null || element.getElementType() != JavaTokenType.RBRACKET) break;
            lastBracket = element;
        }
        if (firstBracket != null) {
            element = firstBracket;
            while (true) {
                ASTNode next = element.getTreeNext();
                variableElement.removeChild(element);
                if (element == lastBracket) break;
                element = next;
            }
            CompositeElement newType = (CompositeElement)type2.clone();
            for (int i = 0; i < arrayCount; ++i) {
                CompositeElement newType1 = ASTFactory.composite(JavaElementType.TYPE);
                newType1.rawAddChildren(newType);
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.LBRACKET, "["));
                newType1.rawAddChildren(ASTFactory.leaf(JavaTokenType.RBRACKET, "]"));
                newType = newType1;
                newType.acceptTree(new GeneratedMarkerVisitor());
            }
            newType.putUserData(CharTable.CHAR_TABLE_KEY, SharedImplUtil.findCharTableByTree(type2));
            variableElement.replaceChild(type2, newType);
        }
    }

    public static void setInitializer(PsiVariable variable, PsiExpression initializer2) throws IncorrectOperationException {
        PsiExpression oldInitializer = variable.getInitializer();
        if (oldInitializer != null) {
            oldInitializer.delete();
        }
        if (initializer2 == null) {
            return;
        }
        CompositeElement variableElement = (CompositeElement)variable.getNode();
        ASTNode eq = variableElement.findChildByRole(20);
        if (eq == null) {
            CharTable charTable = SharedImplUtil.findCharTableByTree(variableElement);
            eq = Factory.createSingleLeafElement(JavaTokenType.EQ, "=", 0, 1, charTable, variable.getManager());
            PsiIdentifier identifier = variable.getNameIdentifier();
            assert (identifier != null) : variable;
            ASTNode node = PsiImplUtil.skipWhitespaceCommentsAndTokens(identifier.getNode().getTreeNext(), BRACKETS);
            variableElement.addInternal((TreeElement)eq, eq, node, Boolean.TRUE);
            eq = variableElement.findChildByRole(20);
            assert (eq != null) : variable;
        }
        variable.addAfter(initializer2, eq.getPsi());
    }
}

