/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Map;
import java.util.SortedSet;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.internal.DefaultReportContainer;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.internal.reflect.Instantiator;

public abstract class TaskReportContainer<T extends Report>
extends DefaultReportContainer<T> {
    private static final Function<Report, String> REPORT_NAME = new Function<Report, String>(){

        public String apply(Report report) {
            return report.getName();
        }
    };
    private static final Function<Report, File> TO_FILE = new Function<Report, File>(){

        public File apply(Report report) {
            return report.getDestination();
        }
    };
    private static final Predicate<Report> IS_DIRECTORY_OUTPUT_TYPE = new Predicate<Report>(){

        public boolean apply(Report report) {
            return report.getOutputType() == Report.OutputType.DIRECTORY;
        }
    };
    private final TaskInternal task;

    public TaskReportContainer(Class<? extends T> type, Task task) {
        super(type, (Instantiator)((ProjectInternal)task.getProject()).getServices().get(Instantiator.class));
        this.task = (TaskInternal)task;
    }

    protected Task getTask() {
        return this.task;
    }

    @OutputDirectories
    public Map<String, File> getEnabledDirectoryReportDestinations() {
        return Maps.transformValues((Map)Maps.uniqueIndex((Iterable)Iterables.filter(this.getEnabled(), IS_DIRECTORY_OUTPUT_TYPE), REPORT_NAME), TO_FILE);
    }

    @OutputFiles
    public Map<String, File> getEnabledFileReportDestinations() {
        return Maps.transformValues((Map)Maps.uniqueIndex((Iterable)Iterables.filter(this.getEnabled(), (Predicate)Predicates.not(IS_DIRECTORY_OUTPUT_TYPE)), REPORT_NAME), TO_FILE);
    }

    @Input
    public SortedSet<String> getEnabledReportNames() {
        return Sets.newTreeSet((Iterable)Iterables.transform(this.getEnabled(), REPORT_NAME));
    }
}

