/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.regexp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.exception.SyntaxException;
import org.joni.exception.ValueException;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.cast.ToStrNode;
import org.jruby.truffle.core.cast.ToStrNodeGen;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.rope.RopeNodesFactory;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.rubinius.RegexpPrimitiveNodes;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.thread.ThreadManager;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.util.StringUtils;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RegexpSupport;

@CoreClass(value="Regexp")
public abstract class RegexpNodes {
    @CompilerDirectives.TruffleBoundary
    public static Matcher createMatcher(RubyContext context, DynamicObject regexp, DynamicObject string) {
        Rope stringRope = StringOperations.rope(string);
        Encoding enc = RegexpNodes.checkEncoding(regexp, stringRope, true);
        Regex regex = Layouts.REGEXP.getRegex(regexp);
        if (regex.getEncoding() != enc) {
            Encoding[] fixedEnc = new Encoding[]{null};
            ByteList sourceByteList = RopeOperations.getByteListReadOnly(Layouts.REGEXP.getSource(regexp));
            ByteList preprocessed = RegexpSupport.preprocess((Ruby)context.getJRubyRuntime(), (ByteList)sourceByteList, (Encoding)enc, (Encoding[])fixedEnc, (RegexpSupport.ErrorMode)RegexpSupport.ErrorMode.RAISE);
            RegexpOptions options = Layouts.REGEXP.getOptions(regexp);
            Encoding newEnc = RegexpNodes.checkEncoding(regexp, stringRope, true);
            regex = new Regex(preprocessed.getUnsafeBytes(), preprocessed.getBegin(), preprocessed.getBegin() + preprocessed.getRealSize(), options.toJoniOptions(), newEnc);
            assert (enc == newEnc);
        }
        return regex.matcher(stringRope.getBytes(), 0, stringRope.byteLength());
    }

    @CompilerDirectives.TruffleBoundary
    public static Object matchCommon(RubyContext context, Node currentNode, RopeNodes.MakeSubstringNode makeSubstringNode, DynamicObject regexp, DynamicObject string, boolean operator, boolean setNamedCaptures, int startPos) {
        Matcher matcher = RegexpNodes.createMatcher(context, regexp, string);
        int range = StringOperations.rope(string).byteLength();
        return RegexpNodes.matchCommon(context, currentNode, makeSubstringNode, regexp, string, operator, setNamedCaptures, matcher, startPos, range);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object matchCommon(RubyContext context, Node currentNode, RopeNodes.MakeSubstringNode makeSubstringNode, DynamicObject regexp, DynamicObject string, boolean operator, boolean setNamedCaptures, final Matcher matcher, final int startPos, final int range) {
        assert (RubyGuards.isRubyRegexp(regexp));
        assert (RubyGuards.isRubyString(string));
        Rope sourceRope = StringOperations.rope(string);
        int match = context.getThreadManager().runUntilResult(currentNode, new ThreadManager.BlockingAction<Integer>(){

            @Override
            public Integer block() throws InterruptedException {
                return matcher.searchInterruptible(startPos, range, 0);
            }
        });
        DynamicObject nil = context.getCoreLibrary().getNilObject();
        if (match == -1) {
            RegexpPrimitiveNodes.RegexpSetLastMatchPrimitiveNode.setLastMatch(context, nil);
            if (setNamedCaptures && Layouts.REGEXP.getRegex(regexp).numberOfNames() > 0) {
                Frame frame = context.getCallStack().getCallerFrameIgnoringSend().getFrame(FrameInstance.FrameAccess.READ_WRITE, false);
                Iterator i = Layouts.REGEXP.getRegex(regexp).namedBackrefIterator();
                while (i.hasNext()) {
                    NameEntry e = (NameEntry)i.next();
                    String name = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                    RegexpNodes.setLocalVariable(frame, name, nil);
                }
            }
            return nil;
        }
        assert (match >= 0);
        Region region = matcher.getEagerRegion();
        Object[] values = new Object[region.numRegs];
        for (int n = 0; n < region.numRegs; ++n) {
            int start = region.beg[n];
            int end = region.end[n];
            values[n] = start > -1 && end > -1 ? RegexpNodes.createSubstring(makeSubstringNode, string, start, end - start) : nil;
        }
        DynamicObject pre = RegexpNodes.createSubstring(makeSubstringNode, string, 0, region.beg[0]);
        DynamicObject post = RegexpNodes.createSubstring(makeSubstringNode, string, region.end[0], sourceRope.byteLength() - region.end[0]);
        DynamicObject global = RegexpNodes.createSubstring(makeSubstringNode, string, region.beg[0], region.end[0] - region.beg[0]);
        DynamicObject matchData = Layouts.MATCH_DATA.createMatchData(context.getCoreLibrary().getMatchDataFactory(), string, regexp, region, values, pre, post, global, null);
        RegexpPrimitiveNodes.RegexpSetLastMatchPrimitiveNode.setLastMatch(context, matchData);
        if (setNamedCaptures && Layouts.REGEXP.getRegex(regexp).numberOfNames() > 0) {
            Frame frame = context.getCallStack().getCallerFrameIgnoringSend().getFrame(FrameInstance.FrameAccess.READ_WRITE, false);
            Iterator i = Layouts.REGEXP.getRegex(regexp).namedBackrefIterator();
            while (i.hasNext()) {
                DynamicObject value;
                NameEntry e = (NameEntry)i.next();
                String name = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                int nth = Layouts.REGEXP.getRegex(regexp).nameToBackrefNumber(e.name, e.nameP, e.nameEnd, region);
                if (nth >= region.numRegs || nth < 0 && (nth += region.numRegs) <= 0) {
                    value = nil;
                } else {
                    int start = region.beg[nth];
                    int end = region.end[nth];
                    value = start != -1 ? RegexpNodes.createSubstring(makeSubstringNode, string, start, end - start) : nil;
                }
                RegexpNodes.setLocalVariable(frame, name, value);
            }
        }
        if (operator) {
            return matcher.getBegin();
        }
        return matchData;
    }

    @CompilerDirectives.TruffleBoundary
    private static DynamicObject createSubstring(RopeNodes.MakeSubstringNode makeSubstringNode, DynamicObject source, int start, int length) {
        assert (RubyGuards.isRubyString(source));
        Rope sourceRope = StringOperations.rope(source);
        Rope substringRope = makeSubstringNode.executeMake(sourceRope, start, length);
        DynamicObject ret = Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(Layouts.BASIC_OBJECT.getLogicalClass(source)), substringRope);
        return ret;
    }

    private static void setLocalVariable(Frame frame, String name, Object value) {
        assert (value != null);
        while (frame != null) {
            FrameSlot slot = frame.getFrameDescriptor().findFrameSlot(name);
            if (slot != null) {
                frame.setObject(slot, value);
                break;
            }
            frame = RubyArguments.getDeclarationFrame(frame);
        }
    }

    public static Rope shimModifiers(Rope bytes) {
        String bytesString = bytes.toString();
        if (bytesString.startsWith("(?u)") || bytesString.startsWith("(?d)") || bytesString.startsWith("(?a)")) {
            char modifier = (char)bytes.get(2);
            bytesString = bytesString.substring(4);
            switch (modifier) {
                case 'u': {
                    bytesString = StringUtils.replace(bytesString, "\\w", "[[:alpha:]]");
                    break;
                }
                case 'd': {
                    break;
                }
                case 'a': {
                    bytesString = StringUtils.replace(bytesString, "[[:alpha:]]", "[a-zA-Z]");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            bytes = StringOperations.createRope(bytesString, (Encoding)ASCIIEncoding.INSTANCE);
        }
        return bytes;
    }

    @CompilerDirectives.TruffleBoundary
    public static Regex compile(Node currentNode, RubyContext context, Rope bytes, RegexpOptions options) {
        bytes = RegexpNodes.shimModifiers(bytes);
        try {
            ByteList byteList = RopeOperations.getByteListReadOnly(bytes);
            Encoding enc = bytes.getEncoding();
            Encoding[] fixedEnc = new Encoding[]{null};
            ByteList unescaped = RegexpSupport.preprocess((Ruby)context.getJRubyRuntime(), (ByteList)byteList, (Encoding)enc, (Encoding[])fixedEnc, (RegexpSupport.ErrorMode)RegexpSupport.ErrorMode.RAISE);
            if (fixedEnc[0] != null) {
                if (fixedEnc[0] != enc && options.isFixed() || fixedEnc[0] != ASCIIEncoding.INSTANCE && options.isEncodingNone()) {
                    RegexpSupport.raiseRegexpError19((Ruby)context.getJRubyRuntime(), (ByteList)byteList, (Encoding)enc, (RegexpOptions)options, (String)"incompatible character encoding");
                }
                if (fixedEnc[0] != ASCIIEncoding.INSTANCE) {
                    options.setFixed(true);
                    enc = fixedEnc[0];
                }
            } else if (!options.isFixed()) {
                enc = USASCIIEncoding.INSTANCE;
            }
            if (fixedEnc[0] != null) {
                options.setFixed(true);
            }
            Regex regexp = new Regex(unescaped.getUnsafeBytes(), unescaped.getBegin(), unescaped.getBegin() + unescaped.getRealSize(), options.toJoniOptions(), enc, Syntax.RUBY);
            regexp.setUserObject((Object)RopeOperations.withEncodingVerySlow(bytes, enc));
            return regexp;
        }
        catch (ValueException e) {
            throw new RaiseException(context.getCoreExceptions().runtimeError("error compiling regex", currentNode));
        }
        catch (SyntaxException e) {
            throw new RaiseException(context.getCoreExceptions().regexpError(e.getMessage(), currentNode));
        }
    }

    public static Object getCachedNames(DynamicObject regexp) {
        return Layouts.REGEXP.getCachedNames(regexp);
    }

    public static void setCachedNames(DynamicObject regexp, Object cachedNames) {
        Layouts.REGEXP.setCachedNames(regexp, cachedNames);
    }

    public static void setRegex(DynamicObject regexp, Regex regex) {
        Layouts.REGEXP.setRegex(regexp, regex);
    }

    public static void setSource(DynamicObject regexp, Rope source) {
        Layouts.REGEXP.setSource(regexp, source);
    }

    public static void setOptions(DynamicObject regexp, RegexpOptions options) {
        Layouts.REGEXP.setOptions(regexp, options);
    }

    public static Encoding checkEncoding(DynamicObject regexp, Rope str, boolean warn) {
        Encoding regexEnc;
        assert (RubyGuards.isRubyRegexp(regexp));
        Encoding strEnc = str.getEncoding();
        if (strEnc == (regexEnc = Layouts.REGEXP.getRegex(regexp).getEncoding())) {
            return regexEnc;
        }
        if (regexEnc == USASCIIEncoding.INSTANCE && str.getCodeRange() == CodeRange.CR_7BIT) {
            return regexEnc;
        }
        if (!strEnc.isAsciiCompatible()) {
            if (strEnc != regexEnc) {
                // empty if block
            }
        } else if (Layouts.REGEXP.getOptions(regexp).isFixed()) {
            return regexEnc;
        }
        return strEnc;
    }

    public static void initialize(RubyContext context, DynamicObject regexp, Node currentNode, Rope setSource, int options) {
        assert (RubyGuards.isRubyRegexp(regexp));
        RegexpOptions regexpOptions = RegexpOptions.fromEmbeddedOptions((int)options);
        Regex regex = RegexpNodes.compile(currentNode, context, setSource, regexpOptions);
        RegexpNodes.setSource(regexp, (Rope)regex.getUserObject());
        RegexpNodes.setOptions(regexp, regexpOptions);
        RegexpNodes.setRegex(regexp, regex);
    }

    public static void initialize(DynamicObject regexp, Regex setRegex, Rope setSource) {
        assert (RubyGuards.isRubyRegexp(regexp));
        RegexpNodes.setRegex(regexp, setRegex);
        RegexpNodes.setSource(regexp, setSource);
    }

    public static DynamicObject createRubyRegexp(RubyContext context, Node currentNode, DynamicObjectFactory factory, Rope source, RegexpOptions options) {
        Regex regexp = RegexpNodes.compile(currentNode, context, source, options);
        return Layouts.REGEXP.createRegexp(factory, regexp, (Rope)regexp.getUserObject(), options, null);
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject createRubyRegexp(DynamicObjectFactory factory, Regex regex, Rope source, RegexpOptions options) {
        DynamicObject regexp = Layouts.REGEXP.createRegexp(factory, null, null, RegexpOptions.NULL_OPTIONS, null);
        RegexpNodes.setOptions(regexp, options);
        RegexpNodes.initialize(regexp, regex, source);
        return regexp;
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode = AllocateObjectNode.create();

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateNode.allocate(rubyClass, null, null, RegexpOptions.NULL_OPTIONS, null);
        }
    }

    @NodeChild(value="self")
    public static abstract class RubiniusNamesNode
    extends RubyNode {
        @Node.Child
        private CallDispatchHeadNode newLookupTableNode;
        @Node.Child
        private CallDispatchHeadNode lookupTableWriteNode;

        @Specialization(guards={"!anyNames(regexp)"})
        public DynamicObject rubiniusNamesNoCaptures(DynamicObject regexp) {
            return this.nil();
        }

        @Specialization(guards={"anyNames(regexp)"})
        public Object rubiniusNames(VirtualFrame frame, DynamicObject regexp) {
            if (RegexpNodes.getCachedNames(regexp) != null) {
                return RegexpNodes.getCachedNames(regexp);
            }
            if (this.newLookupTableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.newLookupTableNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            if (this.lookupTableWriteNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupTableWriteNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            Object namesLookupTable = this.newLookupTableNode.call(frame, this.coreLibrary().getLookupTableClass(), "new", new Object[0]);
            Iterator i = Layouts.REGEXP.getRegex(regexp).namedBackrefIterator();
            while (i.hasNext()) {
                NameEntry e = (NameEntry)i.next();
                DynamicObject name = this.getContext().getSymbolTable().getSymbol(this.getContext().getRopeTable().getRope(Arrays.copyOfRange(e.name, e.nameP, e.nameEnd), (Encoding)USASCIIEncoding.INSTANCE, CodeRange.CR_7BIT));
                int[] backrefs = e.getBackRefs();
                DynamicObject backrefsRubyArray = Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), backrefs, backrefs.length);
                this.lookupTableWriteNode.call(frame, namesLookupTable, "[]=", name, backrefsRubyArray);
            }
            RegexpNodes.setCachedNames(regexp, namesLookupTable);
            return namesLookupTable;
        }

        public static boolean anyNames(DynamicObject regexp) {
            return Layouts.REGEXP.getRegex(regexp).numberOfNames() > 0;
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(DynamicObject regexp) {
            return this.createString(((RubyString)RubyRegexp.newRegexp((Ruby)this.getContext().getJRubyRuntime(), (ByteList)RopeOperations.getByteListReadOnly(Layouts.REGEXP.getSource(regexp)), (int)Layouts.REGEXP.getRegex(regexp).getOptions()).to_s()).getByteList());
        }
    }

    @CoreMethod(names={"source"})
    public static abstract class SourceNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject source(DynamicObject regexp) {
            return this.createString(Layouts.REGEXP.getSource(regexp));
        }
    }

    @CoreMethod(names={"search_from"}, required=2)
    public static abstract class SearchFromNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);

        public SearchFromNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object searchFrom(DynamicObject regexp, DynamicObject string, int startPos) {
            return RegexpNodes.matchCommon(this.getContext(), this, this.makeSubstringNode, regexp, string, false, false, startPos);
        }
    }

    @CoreMethod(names={"quote", "escape"}, onSingleton=true, required=1)
    public static abstract class QuoteNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        ToStrNode toStrNode;

        public abstract DynamicObject executeQuote(VirtualFrame var1, Object var2);

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(raw)"})
        public DynamicObject quoteString(DynamicObject raw) {
            Rope rope = StringOperations.rope(raw);
            boolean isAsciiOnly = rope.getEncoding().isAsciiCompatible() && rope.getCodeRange() == CodeRange.CR_7BIT;
            return this.createString(RubyRegexp.quote19((ByteList)StringOperations.getByteListReadOnly(raw), (boolean)isAsciiOnly));
        }

        @Specialization(guards={"isRubySymbol(raw)"})
        public DynamicObject quoteSymbol(DynamicObject raw) {
            return this.quoteString(this.createString(StringOperations.encodeRope(Layouts.SYMBOL.getString(raw), (Encoding)UTF8Encoding.INSTANCE)));
        }

        @Fallback
        public DynamicObject quote(VirtualFrame frame, Object raw) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.executeQuote(frame, this.toStrNode.executeToStr(frame, raw));
        }
    }

    @CoreMethod(names={"match_start"}, required=2)
    public static abstract class MatchStartNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);

        public MatchStartNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object matchStart(DynamicObject regexp, DynamicObject string, int startPos) {
            Object matchResult = RegexpNodes.matchCommon(this.getContext(), this, this.makeSubstringNode, regexp, string, false, false, startPos);
            if (RubyGuards.isRubyMatchData(matchResult) && Layouts.MATCH_DATA.getRegion((DynamicObject)((DynamicObject)matchResult)).numRegs > 0 && Layouts.MATCH_DATA.getRegion((DynamicObject)((DynamicObject)matchResult)).beg[0] == startPos) {
                return matchResult;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int hash(DynamicObject regexp) {
            int options = Layouts.REGEXP.getRegex(regexp).getOptions() & 0xFFFFFFDF;
            return options ^ Layouts.REGEXP.getSource(regexp).hashCode();
        }
    }

    @CoreMethod(names={"=~"}, required=1)
    public static abstract class MatchOperatorNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);
        @Node.Child
        private CallDispatchHeadNode toSNode;
        @Node.Child
        private ToStrNode toStrNode;

        public MatchOperatorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object match(DynamicObject regexp, DynamicObject string) {
            return RegexpNodes.matchCommon(this.getContext(), this, this.makeSubstringNode, regexp, string, true, true, 0);
        }

        @Specialization(guards={"isRubySymbol(symbol)"})
        public Object match(VirtualFrame frame, DynamicObject regexp, DynamicObject symbol) {
            if (this.toSNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toSNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.match(regexp, (DynamicObject)this.toSNode.call(frame, symbol, "to_s", new Object[0]));
        }

        @Specialization(guards={"isNil(nil)"})
        public Object match(DynamicObject regexp, Object nil) {
            return this.nil();
        }

        @Specialization(guards={"!isRubyString(other)", "!isRubySymbol(other)", "!isNil(other)"})
        public Object matchGeneric(VirtualFrame frame, DynamicObject regexp, DynamicObject other) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.match(regexp, this.toStrNode.executeToStr(frame, other));
        }
    }
}

