/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.TextStyle;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.UIManager;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4f;

public class Label3D
extends Object3DBranch {
    private static final TransparencyAttributes DEFAULT_TRANSPARENCY_ATTRIBUTES = new TransparencyAttributes(1, 0.0f);
    private static final PolygonAttributes DEFAULT_POLYGON_ATTRIBUTES = new PolygonAttributes(2, 0, 0.0f, false);
    private static final TextureAttributes MODULATE_TEXTURE_ATTRIBUTES = new TextureAttributes();
    private String text;
    private TextStyle style;
    private Integer color;
    private Transform3D baseLineTransform;
    private Texture texture;

    public Label3D(Label label, Home home, boolean bl) {
        this.setUserData(label);
        this.setCapability(17);
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.update();
    }

    public void update() {
        Label label = (Label)this.getUserData();
        Float f = label.getPitch();
        TextStyle textStyle = label.getStyle();
        if (f != null && textStyle != null && (label.getLevel() == null || label.getLevel().isViewableAndVisible())) {
            Graphics2D graphics2D;
            BufferedImage bufferedImage;
            Font font;
            Font font2;
            String string = label.getText();
            Integer n = label.getColor();
            if (!string.equals(this.text) || textStyle == null && this.style != null || textStyle != null && !textStyle.equals(this.style) || n == null && this.color != null || n != null && !n.equals(this.color)) {
                int n2;
                float f2;
                int n3;
                float f3;
                int n4 = 0;
                if (textStyle.isBold()) {
                    n4 = 1;
                }
                if (textStyle.isItalic()) {
                    n4 |= 2;
                }
                font2 = textStyle.getFontName() != null ? new Font(textStyle.getFontName(), n4, 1) : UIManager.getFont("TextField.font");
                font = font2.deriveFont(n4, textStyle.getFontSize());
                bufferedImage = new BufferedImage(1, 1, 2);
                graphics2D = (Graphics2D)bufferedImage.getGraphics();
                FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
                graphics2D.dispose();
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
                float f4 = (float)rectangle2D.getWidth();
                float f5 = (float)rectangle2D.getHeight();
                if (textStyle.isItalic()) {
                    f4 = (float)((double)f4 + (double)fontMetrics.getAscent() * 0.2);
                }
                if ((f3 = (float)Math.sqrt(f4 / f5)) > 1.0f) {
                    n3 = (int)Math.ceil(Math.max(255.0f * f3, Math.min(f4, 511.0f * f3)));
                    f2 = (float)n3 / f4;
                    n2 = (int)Math.ceil(f2 * f5);
                } else {
                    n2 = (int)Math.ceil(Math.max(255.0f * f3, Math.min(f5, 511.0f / f3)));
                    f2 = (float)n2 / f5;
                    n3 = (int)Math.ceil(f2 * f4);
                }
                BufferedImage bufferedImage2 = new BufferedImage(n3, n2, 2);
                graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                graphics2D.setFont(font);
                graphics2D.setColor(n != null ? new Color(n) : UIManager.getColor("TextField.foreground"));
                graphics2D.setTransform(AffineTransform.getScaleInstance(f2, f2));
                graphics2D.drawString(string, 0.0f, -((float)rectangle2D.getY()));
                graphics2D.dispose();
                Transform3D transform3D = new Transform3D();
                transform3D.setScale(new Vector3d((double)f4, 1.0, (double)f5));
                this.baseLineTransform = new Transform3D();
                this.baseLineTransform.setTranslation(new Vector3d(0.0, 0.0, (double)(f5 / 2.0f) + rectangle2D.getY()));
                this.baseLineTransform.mul(transform3D);
                this.texture = new TextureLoader(bufferedImage2).getTexture();
                this.text = string;
                this.style = textStyle;
                this.color = n;
            }
            if (this.numChildren() == 0) {
                BranchGroup branchGroup = new BranchGroup();
                branchGroup.setCapability(12);
                branchGroup.setCapability(17);
                font2 = new TransformGroup();
                font2.setCapability(18);
                font2.setCapability(12);
                branchGroup.addChild((Node)font2);
                font = new Appearance();
                font.setMaterial(this.getMaterial(DEFAULT_COLOR, DEFAULT_AMBIENT_COLOR, 0.0f));
                font.setPolygonAttributes(DEFAULT_POLYGON_ATTRIBUTES);
                font.setTextureAttributes(MODULATE_TEXTURE_ATTRIBUTES);
                font.setTransparencyAttributes(DEFAULT_TRANSPARENCY_ATTRIBUTES);
                font.setTexCoordGeneration(new TexCoordGeneration(0, 0, new Vector4f(1.0f, 0.0f, 0.0f, 0.5f), new Vector4f(0.0f, 1.0f, -1.0f, 0.5f)));
                font.setCapability(3);
                bufferedImage = new Box(0.5f, 0.0f, 0.5f, (Appearance)font);
                graphics2D = bufferedImage.getShape(4);
                bufferedImage.removeChild((Node)graphics2D);
                font2.addChild((Node)graphics2D);
                this.addChild((Node)branchGroup);
            }
            TransformGroup transformGroup = (TransformGroup)((Group)this.getChild(0)).getChild(0);
            font2 = new Transform3D();
            font2.rotX(f.floatValue());
            font2.mul(this.baseLineTransform);
            font = new Transform3D();
            font.rotY(-label.getAngle());
            font.mul((Transform3D)font2);
            bufferedImage = new Transform3D();
            bufferedImage.setTranslation(new Vector3d((double)label.getX(), (double)label.getGroundElevation(), (double)label.getY()));
            bufferedImage.mul((Transform3D)font);
            transformGroup.setTransform((Transform3D)bufferedImage);
            ((Shape3D)transformGroup.getChild(0)).getAppearance().setTexture(this.texture);
        } else {
            this.removeAllChildren();
            this.text = null;
            this.style = null;
            this.color = null;
            this.texture = null;
            this.baseLineTransform = null;
        }
    }

    static {
        MODULATE_TEXTURE_ATTRIBUTES.setTextureMode(2);
    }
}

