/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class DataFlavorUtils {
    DataFlavorUtils() {
    }

    static String getFxMimeType(DataFlavor dataFlavor) {
        return dataFlavor.getPrimaryType() + "/" + dataFlavor.getSubType();
    }

    static Object adjustFxData(DataFlavor dataFlavor, Object object) throws UnsupportedEncodingException {
        if (object instanceof String && dataFlavor.isRepresentationClassInputStream()) {
            String string = dataFlavor.getParameter("charset");
            return new ByteArrayInputStream(string != null ? ((String)object).getBytes(string) : ((String)object).getBytes());
        }
        return object;
    }

    static Object adjustSwingData(DataFlavor dataFlavor, Object object) {
        if (dataFlavor.isFlavorJavaFileListType()) {
            List list = (List)object;
            String[] stringArray = new String[list.size()];
            int n = 0;
            for (File file : list) {
                stringArray[n++] = file.getPath();
            }
            return stringArray;
        }
        return object;
    }

    static Map<String, DataFlavor> adjustSwingDataFlavors(DataFlavor[] dataFlavorArray) {
        HashMap hashMap = new HashMap(dataFlavorArray.length);
        for (DataFlavor dataFlavorArray2 : dataFlavorArray) {
            Set<DataFlavor> set;
            String string = DataFlavorUtils.getFxMimeType(dataFlavorArray2);
            if (hashMap.containsKey(string)) {
                set = (Set)hashMap.get(string);
                try {
                    set.add(dataFlavorArray2);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                continue;
            }
            set = new HashSet();
            if (dataFlavorArray2.isFlavorTextType()) {
                set.add(DataFlavor.stringFlavor);
                set = Collections.unmodifiableSet(set);
            } else {
                set.add(dataFlavorArray2);
            }
            hashMap.put(string, set);
        }
        HashMap hashMap2 = new HashMap();
        for (String string : hashMap.keySet()) {
            DataFlavor[] dataFlavorArray2 = ((Set)hashMap.get(string)).toArray(new DataFlavor[0]);
            if (dataFlavorArray2.length == 1) {
                hashMap2.put(string, dataFlavorArray2[0]);
                continue;
            }
            hashMap2.put(string, dataFlavorArray2[0]);
        }
        return hashMap2;
    }

    static Map<String, Object> readAllData(Transferable transferable) {
        Map<String, DataFlavor> map = DataFlavorUtils.adjustSwingDataFlavors(transferable.getTransferDataFlavors());
        return DataFlavorUtils.readAllData(transferable, map);
    }

    static Map<String, Object> readAllData(Transferable transferable, Map<String, DataFlavor> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<String, DataFlavor> entry : map.entrySet()) {
            Object object = null;
            try {
                object = transferable.getTransferData(entry.getValue());
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (object == null) continue;
            object = DataFlavorUtils.adjustSwingData(entry.getValue(), object);
            hashMap.put(entry.getKey(), object);
        }
        return hashMap;
    }
}

