/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.filter.FilterAdaptor;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpResponseHeader;

public class FilterDetectSetCookie
extends FilterAdaptor {
    private static final String CRLF = "\r\n";
    private Pattern pattern = Pattern.compile("^ *Set-[Cc]ookie *: *([^\\r\\n]*)\\r\\n", 10);

    @Override
    public int getId() {
        return 110;
    }

    @Override
    public String getName() {
        return Constant.messages.getString("filter.setcookie.name");
    }

    @Override
    public void onHttpRequestSend(HttpMessage httpMessage) {
    }

    @Override
    public void onHttpResponseReceive(HttpMessage httpMessage) {
        HttpResponseHeader httpResponseHeader = httpMessage.getResponseHeader();
        if (httpResponseHeader == null || httpResponseHeader.isEmpty()) {
            return;
        }
        if (httpResponseHeader.getHeader("Set-cookie") != null) {
            Object object;
            CharSequence charSequence;
            Matcher matcher = this.pattern.matcher(httpResponseHeader.toString());
            LinkedList<Object> linkedList = new LinkedList<Object>();
            while (matcher.find()) {
                charSequence = matcher.group(1);
                if (charSequence == null) continue;
                this.getView().getMainFrame().toFront();
                object = JOptionPane.showInputDialog(this.getView().getMainFrame(), "Accept the following cookie (Ok=Accept, Cancel=Reject)?", charSequence);
                if (object != null && !((String)object).equals("")) {
                    httpResponseHeader.setHeader("Set-cookie", null);
                    linkedList.add(object);
                    continue;
                }
                if (object != null) continue;
                httpResponseHeader.setHeader("Set-cookie", null);
            }
            if (linkedList.size() > 0) {
                charSequence = new StringBuilder(matcher.replaceAll(""));
                object = linkedList.iterator();
                while (object.hasNext()) {
                    ((StringBuilder)charSequence).append("Set-Cookie: ").append((String)object.next()).append(CRLF);
                }
                try {
                    httpResponseHeader.setMessage(((StringBuilder)charSequence).toString());
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            }
        }
    }
}

