/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.awt.Dialog;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.pscan.DialogAddAutoTagScanner;
import org.zaproxy.zap.extension.pscan.scanner.RegexAutoTagScanner;

class DialogModifyAutoTagScanner
extends DialogAddAutoTagScanner {
    private static final long serialVersionUID = 6536266615593275432L;
    private static final String DIALOG_TITLE = Constant.messages.getString("pscan.options.dialog.scanner.modify.title");
    private static final String CONFIRM_BUTTON_LABEL = Constant.messages.getString("pscan.options.dialog.scanner.modify.button.confirm");

    protected DialogModifyAutoTagScanner(Dialog dialog) {
        super(dialog, DIALOG_TITLE);
    }

    @Override
    protected String getConfirmButtonLabel() {
        return CONFIRM_BUTTON_LABEL;
    }

    public void setApp(RegexAutoTagScanner regexAutoTagScanner) {
        this.scanner = regexAutoTagScanner;
    }

    @Override
    protected boolean validateName(String string) {
        if (this.scanner.getName().equals(string)) {
            return true;
        }
        return super.validateName(string);
    }

    @Override
    protected void init() {
        this.getNameTextField().setText(this.scanner.getName());
        this.getRequestUrlRegexTextField().discardAllEdits();
        this.getTypeTextField().setText(this.scanner.getType().name());
        this.getRequestUrlRegexTextField().discardAllEdits();
        this.getConfigurationTextField().setText(this.scanner.getConf());
        this.getConfigurationTextField().discardAllEdits();
        this.getRequestUrlRegexTextField().setText(this.scanner.getRequestUrlRegex());
        this.getRequestUrlRegexTextField().discardAllEdits();
        this.getRequestHeaderRegexTextField().setText(this.scanner.getRequestHeaderRegex());
        this.getRequestHeaderRegexTextField().discardAllEdits();
        this.getResponseHeaderRegexTextField().setText(this.scanner.getResponseHeaderRegex());
        this.getResponseHeaderRegexTextField().discardAllEdits();
        this.getResponseBodyRegexTextField().setText(this.scanner.getResponseBodyRegex());
        this.getResponseBodyRegexTextField().discardAllEdits();
        this.getEnabledCheckBox().setSelected(this.scanner.isEnabled());
    }
}

