/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.ClassRepository;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.optimizer.BodyCodegen;
import org.mozilla.javascript.optimizer.OptClassNameHelper;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptRuntime;
import org.mozilla.javascript.optimizer.OptTransformer;
import org.mozilla.javascript.optimizer.Optimizer;

public class Codegen
extends Interpreter {
    private static final String SUPER_CLASS_NAME = "org.mozilla.javascript.NativeFunction";
    static final String DIRECT_CALL_PARENT_FIELD = "_dcp";
    private static final String ID_FIELD_NAME = "_id";
    private static final String REGEXP_INIT_METHOD_NAME = "_reInit";
    private static final String REGEXP_INIT_METHOD_SIGNATURE = "(Lorg/mozilla/javascript/RegExpProxy;Lorg/mozilla/javascript/Context;)V";
    static final String REGEXP_ARRAY_FIELD_NAME = "_re";
    static final String REGEXP_ARRAY_FIELD_TYPE = "[Ljava/lang/Object;";
    static final String FUNCTION_INIT_SIGNATURE = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)V";
    static final String FUNCTION_CONSTRUCTOR_SIGNATURE = "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;I)V";
    private CompilerEnvirons compilerEnv;
    private ObjArray directCallTargets;
    ScriptOrFnNode[] scriptOrFnNodes;
    private ObjToIntMap scriptOrFnIndexes;
    String mainClassName;
    String mainClassSignature;
    boolean itsUseDynamicScope;
    int languageVersion;
    private double[] itsConstantList;
    private int itsConstantListSize;

    public Object compile(Scriptable scope, CompilerEnvirons compilerEnv, ScriptOrFnNode scriptOrFn, String encodedSource, boolean returnFunction, Object securityDomain) {
        Script script;
        Context cx = Context.getCurrentContext();
        OptClassNameHelper nameHelper = (OptClassNameHelper)ClassNameHelper.get(cx);
        Class[] interfaces = nameHelper.getTargetImplements();
        Class superClass = nameHelper.getTargetExtends();
        boolean isPrimary = interfaces == null && superClass == null;
        String mainClassName = nameHelper.getScriptClassName(isPrimary);
        byte[] mainClassBytes = this.compileToClassFile(compilerEnv, mainClassName, scriptOrFn, encodedSource, returnFunction);
        boolean onlySave = false;
        ClassRepository repository = nameHelper.getClassRepository();
        if (repository != null) {
            try {
                if (!repository.storeClass(mainClassName, mainClassBytes, true)) {
                    onlySave = true;
                }
            }
            catch (IOException iox) {
                throw Context.throwAsScriptRuntimeEx(iox);
            }
            if (!isPrimary) {
                String adapterClassName = nameHelper.getScriptClassName(true);
                int functionCount = scriptOrFn.getFunctionCount();
                ObjToIntMap functionNames = new ObjToIntMap(functionCount);
                for (int i = 0; i != functionCount; ++i) {
                    FunctionNode ofn = scriptOrFn.getFunctionNode(i);
                    String name = ofn.getFunctionName();
                    if (name == null || name.length() == 0) continue;
                    functionNames.put(name, ofn.getParamCount());
                }
                if (superClass == null) {
                    superClass = ScriptRuntime.ObjectClass;
                }
                byte[] classFile = JavaAdapter.createAdapterCode(functionNames, adapterClassName, superClass, interfaces, mainClassName);
                try {
                    if (!repository.storeClass(adapterClassName, classFile, true)) {
                        onlySave = true;
                    }
                }
                catch (IOException iox) {
                    throw Context.throwAsScriptRuntimeEx(iox);
                }
            }
        }
        if (onlySave) {
            return null;
        }
        RuntimeException e = null;
        Class result = null;
        GeneratedClassLoader loader = SecurityController.createLoader(null, securityDomain);
        try {
            result = loader.defineClass(mainClassName, mainClassBytes);
            loader.linkClass(result);
        }
        catch (SecurityException x) {
            e = x;
        }
        catch (IllegalArgumentException x) {
            e = x;
        }
        if (e != null) {
            throw new RuntimeException("Malformed optimizer package " + e);
        }
        if (scriptOrFn.getType() == 87) {
            NativeFunction f;
            try {
                Constructor<?> ctor = result.getConstructors()[0];
                Object[] initArgs = new Object[]{scope, cx, new Integer(0)};
                f = (NativeFunction)ctor.newInstance(initArgs);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to instantiate compiled class:" + ex.toString());
            }
            int ftype = ((FunctionNode)scriptOrFn).getFunctionType();
            OptRuntime.initFunction(f, ftype, scope, cx);
            return f;
        }
        try {
            script = (Script)result.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to instantiate compiled class:" + ex.toString());
        }
        return script;
    }

    public void notifyDebuggerCompilationDone(Context cx, ScriptOrFnNode scriptOrFn, String debugSource) {
    }

    byte[] compileToClassFile(CompilerEnvirons compilerEnv, String mainClassName, ScriptOrFnNode scriptOrFn, String encodedSource, boolean returnFunction) {
        this.compilerEnv = compilerEnv;
        this.transform(scriptOrFn);
        if (returnFunction) {
            scriptOrFn = scriptOrFn.getFunctionNode(0);
        }
        this.initScriptOrFnNodesData(scriptOrFn);
        this.mainClassName = mainClassName;
        this.mainClassSignature = ClassFileWriter.classNameToSignature(mainClassName);
        return this.generateCode(encodedSource);
    }

    private void transform(ScriptOrFnNode tree) {
        Codegen.initOptFunctions_r(tree);
        int optLevel = this.compilerEnv.getOptimizationLevel();
        Hashtable<String, OptFunctionNode> possibleDirectCalls = null;
        if (optLevel > 0 && tree.getType() == 118) {
            int functionCount = tree.getFunctionCount();
            for (int i = 0; i != functionCount; ++i) {
                String name;
                OptFunctionNode ofn = OptFunctionNode.get(tree, i);
                if (ofn.fnode.getFunctionType() != 1 || (name = ofn.fnode.getFunctionName()).length() == 0) continue;
                if (possibleDirectCalls == null) {
                    possibleDirectCalls = new Hashtable<String, OptFunctionNode>();
                }
                possibleDirectCalls.put(name, ofn);
            }
        }
        if (possibleDirectCalls != null) {
            this.directCallTargets = new ObjArray();
        }
        OptTransformer ot = new OptTransformer(this.compilerEnv, possibleDirectCalls, this.directCallTargets);
        ot.transform(tree);
        if (optLevel > 0) {
            new Optimizer().optimize(tree, optLevel);
        }
    }

    private static void initOptFunctions_r(ScriptOrFnNode scriptOrFn) {
        int N = scriptOrFn.getFunctionCount();
        for (int i = 0; i != N; ++i) {
            FunctionNode fn = scriptOrFn.getFunctionNode(i);
            new OptFunctionNode(fn);
            Codegen.initOptFunctions_r(fn);
        }
    }

    private void initScriptOrFnNodesData(ScriptOrFnNode scriptOrFn) {
        ObjArray x = new ObjArray();
        Codegen.collectScriptOrFnNodes_r(scriptOrFn, x);
        int count = x.size();
        this.scriptOrFnNodes = new ScriptOrFnNode[count];
        x.toArray(this.scriptOrFnNodes);
        this.scriptOrFnIndexes = new ObjToIntMap(count);
        for (int i = 0; i != count; ++i) {
            this.scriptOrFnIndexes.put(this.scriptOrFnNodes[i], i);
        }
    }

    private static void collectScriptOrFnNodes_r(ScriptOrFnNode n, ObjArray x) {
        x.add(n);
        int nestedCount = n.getFunctionCount();
        for (int i = 0; i != nestedCount; ++i) {
            Codegen.collectScriptOrFnNodes_r(n.getFunctionNode(i), x);
        }
    }

    private byte[] generateCode(String encodedSource) {
        boolean hasScript = this.scriptOrFnNodes[0].getType() == 118;
        boolean hasFunctions = this.scriptOrFnNodes.length > 1 || !hasScript;
        String sourceFile = null;
        if (this.compilerEnv.isGenerateDebugInfo()) {
            sourceFile = this.scriptOrFnNodes[0].getSourceName();
        }
        ClassFileWriter cfw = new ClassFileWriter(this.mainClassName, SUPER_CLASS_NAME, sourceFile);
        cfw.addField(ID_FIELD_NAME, "I", (short)2);
        cfw.addField(DIRECT_CALL_PARENT_FIELD, this.mainClassSignature, (short)2);
        cfw.addField(REGEXP_ARRAY_FIELD_NAME, REGEXP_ARRAY_FIELD_TYPE, (short)2);
        if (hasFunctions) {
            this.generateFunctionConstructor(cfw);
        }
        if (hasScript) {
            ScriptOrFnNode script = this.scriptOrFnNodes[0];
            cfw.addInterface("org/mozilla/javascript/Script");
            this.generateScriptCtor(cfw, script);
            Codegen.generateMain(cfw);
            this.generateExecute(cfw, script);
        }
        this.generateCallMethod(cfw);
        if (encodedSource != null) {
            this.generateGetEncodedSource(cfw, encodedSource);
        }
        int count = this.scriptOrFnNodes.length;
        for (int i = 0; i != count; ++i) {
            ScriptOrFnNode n = this.scriptOrFnNodes[i];
            BodyCodegen bodygen = new BodyCodegen();
            bodygen.cfw = cfw;
            bodygen.codegen = this;
            bodygen.compilerEnv = this.compilerEnv;
            bodygen.scriptOrFn = n;
            bodygen.generateBodyCode();
            if (n.getType() != 87) continue;
            OptFunctionNode ofn = OptFunctionNode.get(n);
            this.generateFunctionInit(cfw, ofn);
            if (!ofn.isTargetOfDirectCall()) continue;
            this.emitDirectConstructor(cfw, ofn);
        }
        if (this.directCallTargets != null) {
            int N = this.directCallTargets.size();
            for (int j = 0; j != N; ++j) {
                cfw.addField(Codegen.getDirectTargetFieldName(j), this.mainClassSignature, (short)2);
            }
        }
        this.emitRegExpInit(cfw);
        this.emitConstantDudeInitializers(cfw);
        return cfw.toByteArray();
    }

    private void emitDirectConstructor(ClassFileWriter cfw, OptFunctionNode ofn) {
        cfw.startMethod(this.getDirectCtorName(ofn.fnode), this.getBodyMethodSignature(ofn.fnode), (short)10);
        int argCount = ofn.fnode.getParamCount();
        int firstLocal = 4 + argCount * 3 + 1;
        cfw.addALoad(0);
        cfw.addALoad(1);
        cfw.addALoad(2);
        cfw.addInvoke((byte)-74, "org/mozilla/javascript/BaseFunction", "createObject", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        cfw.addAStore(firstLocal);
        cfw.addALoad(0);
        cfw.addALoad(1);
        cfw.addALoad(2);
        cfw.addALoad(firstLocal);
        for (int i = 0; i < argCount; ++i) {
            cfw.addALoad(4 + i * 3);
            cfw.addDLoad(5 + i * 3);
        }
        cfw.addALoad(4 + argCount * 3);
        cfw.addInvoke((byte)-72, this.mainClassName, this.getBodyMethodName(ofn.fnode), this.getBodyMethodSignature(ofn.fnode));
        int exitLabel = cfw.acquireLabel();
        cfw.add((byte)89);
        cfw.add((byte)-63, "org/mozilla/javascript/Scriptable");
        cfw.add((byte)-103, exitLabel);
        cfw.add((byte)89);
        Codegen.pushUndefined(cfw);
        cfw.add((byte)-91, exitLabel);
        cfw.add((byte)-64, "org/mozilla/javascript/Scriptable");
        cfw.add((byte)-80);
        cfw.markLabel(exitLabel);
        cfw.addALoad(firstLocal);
        cfw.add((byte)-80);
        cfw.stopMethod((short)(firstLocal + 1), null);
    }

    private void generateCallMethod(ClassFileWriter cfw) {
        cfw.startMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", (short)17);
        cfw.addALoad(0);
        cfw.addALoad(1);
        cfw.addALoad(2);
        cfw.addALoad(3);
        cfw.addALoad(4);
        int end = this.scriptOrFnNodes.length;
        boolean generateSwitch = 2 <= end;
        int switchStart = 0;
        short switchStackTop = 0;
        if (generateSwitch) {
            cfw.addLoadThis();
            cfw.add((byte)-76, cfw.getClassName(), ID_FIELD_NAME, "I");
            switchStart = cfw.addTableSwitch(1, end - 1);
        }
        for (int i = 0; i != end; ++i) {
            int pcount;
            OptFunctionNode ofn;
            ScriptOrFnNode n = this.scriptOrFnNodes[i];
            if (generateSwitch) {
                if (i == 0) {
                    cfw.markTableSwitchDefault(switchStart);
                    switchStackTop = cfw.getStackTop();
                } else {
                    cfw.markTableSwitchCase(switchStart, i - 1, switchStackTop);
                }
            }
            if (n.getType() == 87 && (ofn = OptFunctionNode.get(n)).isTargetOfDirectCall() && (pcount = ofn.fnode.getParamCount()) != 0) {
                for (int p = 0; p != pcount; ++p) {
                    cfw.add((byte)-66);
                    cfw.addPush(p);
                    int undefArg = cfw.acquireLabel();
                    int beyond = cfw.acquireLabel();
                    cfw.add((byte)-92, undefArg);
                    cfw.addALoad(4);
                    cfw.addPush(p);
                    cfw.add((byte)50);
                    cfw.add((byte)-89, beyond);
                    cfw.markLabel(undefArg);
                    Codegen.pushUndefined(cfw);
                    cfw.markLabel(beyond);
                    cfw.adjustStackTop(-1);
                    cfw.addPush(0.0);
                    cfw.addALoad(4);
                }
            }
            cfw.addInvoke((byte)-72, this.mainClassName, this.getBodyMethodName(n), this.getBodyMethodSignature(n));
            cfw.add((byte)-80);
        }
        cfw.stopMethod((short)5, null);
    }

    private static void generateMain(ClassFileWriter cfw) {
        cfw.startMethod("main", "([Ljava/lang/String;)V", (short)9);
        cfw.add((byte)-69, cfw.getClassName());
        cfw.add((byte)89);
        cfw.addInvoke((byte)-73, cfw.getClassName(), "<init>", "()V");
        cfw.add((byte)42);
        cfw.addInvoke((byte)-72, "org/mozilla/javascript/ScriptRuntime", "main", "(Lorg/mozilla/javascript/Script;[Ljava/lang/String;)V");
        cfw.add((byte)-79);
        cfw.stopMethod((short)1, null);
    }

    private void generateExecute(ClassFileWriter cfw, ScriptOrFnNode script) {
        cfw.startMethod("exec", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;", (short)17);
        boolean CONTEXT_ARG = true;
        int SCOPE_ARG = 2;
        cfw.addLoadThis();
        cfw.addALoad(1);
        cfw.addALoad(2);
        cfw.add((byte)89);
        cfw.add((byte)1);
        cfw.addInvoke((byte)-74, cfw.getClassName(), "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        cfw.add((byte)-80);
        cfw.stopMethod((short)3, null);
    }

    private void generateScriptCtor(ClassFileWriter cfw, ScriptOrFnNode script) {
        cfw.startMethod("<init>", "()V", (short)1);
        cfw.addLoadThis();
        cfw.addInvoke((byte)-73, SUPER_CLASS_NAME, "<init>", "()V");
        cfw.addLoadThis();
        cfw.addPush(0);
        cfw.add((byte)-75, cfw.getClassName(), ID_FIELD_NAME, "I");
        cfw.addLoadThis();
        cfw.addPush(this.compilerEnv.getLanguageVersion());
        cfw.addPush("");
        Codegen.pushParamNamesArray(cfw, script);
        cfw.addPush(0);
        cfw.addInvoke((byte)-74, "org/mozilla/javascript/NativeFunction", "initScriptFunction", "(ILjava/lang/String;[Ljava/lang/String;I)V");
        cfw.add((byte)-79);
        cfw.stopMethod((short)1, null);
    }

    private void generateFunctionConstructor(ClassFileWriter cfw) {
        boolean SCOPE_ARG = true;
        int CONTEXT_ARG = 2;
        int ID_ARG = 3;
        cfw.startMethod("<init>", FUNCTION_CONSTRUCTOR_SIGNATURE, (short)1);
        cfw.addALoad(0);
        cfw.addInvoke((byte)-73, SUPER_CLASS_NAME, "<init>", "()V");
        cfw.addLoadThis();
        cfw.addILoad(3);
        cfw.add((byte)-75, cfw.getClassName(), ID_FIELD_NAME, "I");
        cfw.addLoadThis();
        cfw.addALoad(2);
        cfw.addALoad(1);
        int start = this.scriptOrFnNodes[0].getType() == 118 ? 1 : 0;
        int end = this.scriptOrFnNodes.length;
        if (start == end) {
            Codegen.badTree();
        }
        boolean generateSwitch = 2 <= end - start;
        int switchStart = 0;
        short switchStackTop = 0;
        if (generateSwitch) {
            cfw.addILoad(3);
            switchStart = cfw.addTableSwitch(start + 1, end - 1);
        }
        for (int i = start; i != end; ++i) {
            if (generateSwitch) {
                if (i == start) {
                    cfw.markTableSwitchDefault(switchStart);
                    switchStackTop = cfw.getStackTop();
                } else {
                    cfw.markTableSwitchCase(switchStart, i - 1 - start, switchStackTop);
                }
            }
            OptFunctionNode ofn = OptFunctionNode.get(this.scriptOrFnNodes[i]);
            cfw.addInvoke((byte)-74, this.mainClassName, this.getFunctionInitMethodName(ofn), FUNCTION_INIT_SIGNATURE);
            cfw.add((byte)-79);
        }
        cfw.stopMethod((short)4, null);
    }

    private void generateFunctionInit(ClassFileWriter cfw, OptFunctionNode ofn) {
        boolean CONTEXT_ARG = true;
        int SCOPE_ARG = 2;
        cfw.startMethod(this.getFunctionInitMethodName(ofn), FUNCTION_INIT_SIGNATURE, (short)18);
        cfw.addLoadThis();
        cfw.addPush(this.compilerEnv.getLanguageVersion());
        cfw.addPush(ofn.fnode.getFunctionName());
        Codegen.pushParamNamesArray(cfw, ofn.fnode);
        cfw.addPush(ofn.fnode.getParamCount());
        cfw.addInvoke((byte)-74, "org/mozilla/javascript/NativeFunction", "initScriptFunction", "(ILjava/lang/String;[Ljava/lang/String;I)V");
        cfw.addLoadThis();
        cfw.addALoad(2);
        cfw.addInvoke((byte)-74, "org/mozilla/javascript/ScriptableObject", "setParentScope", "(Lorg/mozilla/javascript/Scriptable;)V");
        int regexpCount = ofn.fnode.getRegexpCount();
        if (regexpCount != 0) {
            cfw.addLoadThis();
            this.pushRegExpArray(cfw, ofn.fnode, 1, 2);
            cfw.add((byte)-75, this.mainClassName, REGEXP_ARRAY_FIELD_NAME, REGEXP_ARRAY_FIELD_TYPE);
        }
        cfw.add((byte)-79);
        cfw.stopMethod((short)3, null);
    }

    private void generateGetEncodedSource(ClassFileWriter cfw, String encodedSource) {
        cfw.startMethod("getEncodedSource", "()Ljava/lang/String;", (short)1);
        cfw.addPush(encodedSource);
        int count = this.scriptOrFnNodes.length;
        if (count == 1) {
            ScriptOrFnNode n = this.scriptOrFnNodes[0];
            cfw.addPush(n.getEncodedSourceStart());
            cfw.addPush(n.getEncodedSourceEnd());
        } else {
            cfw.addLoadThis();
            cfw.add((byte)-76, cfw.getClassName(), ID_FIELD_NAME, "I");
            int switchStart = cfw.addTableSwitch(1, count - 1);
            int afterSwitch = cfw.acquireLabel();
            short switchStackTop = 0;
            for (int i = 0; i != count; ++i) {
                ScriptOrFnNode n = this.scriptOrFnNodes[i];
                if (i == 0) {
                    cfw.markTableSwitchDefault(switchStart);
                    switchStackTop = cfw.getStackTop();
                } else {
                    cfw.markTableSwitchCase(switchStart, i - 1, switchStackTop);
                }
                cfw.addPush(n.getEncodedSourceStart());
                cfw.addPush(n.getEncodedSourceEnd());
                if (i + 1 == count) continue;
                cfw.add((byte)-89, afterSwitch);
            }
            cfw.markLabel(afterSwitch);
        }
        cfw.addInvoke((byte)-74, "java/lang/String", "substring", "(II)Ljava/lang/String;");
        cfw.add((byte)-80);
        cfw.stopMethod((short)1, null);
    }

    private void emitRegExpInit(ClassFileWriter cfw) {
        int totalRegCount = 0;
        for (int i = 0; i != this.scriptOrFnNodes.length; ++i) {
            totalRegCount += this.scriptOrFnNodes[i].getRegexpCount();
        }
        if (totalRegCount == 0) {
            return;
        }
        cfw.startMethod(REGEXP_INIT_METHOD_NAME, REGEXP_INIT_METHOD_SIGNATURE, (short)42);
        cfw.addField("_reInitDone", "Z", (short)10);
        cfw.add((byte)-78, this.mainClassName, "_reInitDone", "Z");
        int doInit = cfw.acquireLabel();
        cfw.add((byte)-103, doInit);
        cfw.add((byte)-79);
        cfw.markLabel(doInit);
        for (int i = 0; i != this.scriptOrFnNodes.length; ++i) {
            ScriptOrFnNode n = this.scriptOrFnNodes[i];
            int regCount = n.getRegexpCount();
            for (int j = 0; j != regCount; ++j) {
                String reFieldName = this.getCompiledRegexpName(n, j);
                String reFieldType = "Ljava/lang/Object;";
                String reString = n.getRegexpString(j);
                String reFlags = n.getRegexpFlags(j);
                cfw.addField(reFieldName, reFieldType, (short)10);
                cfw.addALoad(0);
                cfw.addALoad(1);
                cfw.addPush(reString);
                if (reFlags == null) {
                    cfw.add((byte)1);
                } else {
                    cfw.addPush(reFlags);
                }
                cfw.addInvoke((byte)-71, "org/mozilla/javascript/RegExpProxy", "compileRegExp", "(Lorg/mozilla/javascript/Context;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;");
                cfw.add((byte)-77, this.mainClassName, reFieldName, reFieldType);
            }
        }
        cfw.addPush(1);
        cfw.add((byte)-77, this.mainClassName, "_reInitDone", "Z");
        cfw.add((byte)-79);
        cfw.stopMethod((short)2, null);
    }

    private void emitConstantDudeInitializers(ClassFileWriter cfw) {
        int N = this.itsConstantListSize;
        if (N == 0) {
            return;
        }
        cfw.startMethod("<clinit>", "()V", (short)24);
        double[] array = this.itsConstantList;
        for (int i = 0; i != N; ++i) {
            double num = array[i];
            String constantName = "_k" + i;
            String constantType = Codegen.getStaticConstantWrapperType(num);
            cfw.addField(constantName, constantType, (short)10);
            int inum = (int)num;
            if ((double)inum == num) {
                cfw.add((byte)-69, "java/lang/Integer");
                cfw.add((byte)89);
                cfw.addPush(inum);
                cfw.addInvoke((byte)-73, "java/lang/Integer", "<init>", "(I)V");
            } else {
                cfw.addPush(num);
                Codegen.addDoubleWrap(cfw);
            }
            cfw.add((byte)-77, this.mainClassName, constantName, constantType);
        }
        cfw.add((byte)-79);
        cfw.stopMethod((short)0, null);
    }

    private static void pushParamNamesArray(ClassFileWriter cfw, ScriptOrFnNode n) {
        int paramAndVarCount = n.getParamAndVarCount();
        if (paramAndVarCount == 0) {
            cfw.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "emptyStrings", "[Ljava/lang/String;");
        } else {
            cfw.addPush(paramAndVarCount);
            cfw.add((byte)-67, "java/lang/String");
            for (int i = 0; i != paramAndVarCount; ++i) {
                cfw.add((byte)89);
                cfw.addPush(i);
                cfw.addPush(n.getParamOrVarName(i));
                cfw.add((byte)83);
            }
        }
    }

    void pushRegExpArray(ClassFileWriter cfw, ScriptOrFnNode n, int contextArg, int scopeArg) {
        int regexpCount = n.getRegexpCount();
        if (regexpCount == 0) {
            Codegen.badTree();
        }
        cfw.addPush(regexpCount);
        cfw.add((byte)-67, "java/lang/Object");
        cfw.addALoad(contextArg);
        cfw.addInvoke((byte)-72, "org/mozilla/javascript/ScriptRuntime", "checkRegExpProxy", "(Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/RegExpProxy;");
        cfw.add((byte)89);
        cfw.addALoad(contextArg);
        cfw.addInvoke((byte)-72, this.mainClassName, REGEXP_INIT_METHOD_NAME, REGEXP_INIT_METHOD_SIGNATURE);
        for (int i = 0; i != regexpCount; ++i) {
            cfw.add((byte)92);
            cfw.addALoad(contextArg);
            cfw.addALoad(scopeArg);
            cfw.add((byte)-78, this.mainClassName, this.getCompiledRegexpName(n, i), "Ljava/lang/Object;");
            cfw.addInvoke((byte)-71, "org/mozilla/javascript/RegExpProxy", "wrapRegExp", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
            cfw.addPush(i);
            cfw.add((byte)95);
            cfw.add((byte)83);
        }
        cfw.add((byte)87);
    }

    void pushNumberAsObject(ClassFileWriter cfw, double num) {
        if (num == 0.0) {
            if (1.0 / num > 0.0) {
                cfw.add((byte)-78, "org/mozilla/javascript/optimizer/OptRuntime", "zeroObj", "Ljava/lang/Double;");
            } else {
                cfw.addPush(num);
                Codegen.addDoubleWrap(cfw);
            }
        } else {
            if (num == 1.0) {
                cfw.add((byte)-78, "org/mozilla/javascript/optimizer/OptRuntime", "oneObj", "Ljava/lang/Double;");
                return;
            }
            if (num == -1.0) {
                cfw.add((byte)-78, "org/mozilla/javascript/optimizer/OptRuntime", "minusOneObj", "Ljava/lang/Double;");
            } else if (num != num) {
                cfw.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "NaNobj", "Ljava/lang/Double;");
            } else if (this.itsConstantListSize >= 2000) {
                cfw.addPush(num);
                Codegen.addDoubleWrap(cfw);
            } else {
                int index;
                int N = this.itsConstantListSize;
                if (N == 0) {
                    this.itsConstantList = new double[64];
                } else {
                    double[] array = this.itsConstantList;
                    for (index = 0; index != N && array[index] != num; ++index) {
                    }
                    if (N == array.length) {
                        array = new double[N * 2];
                        System.arraycopy(this.itsConstantList, 0, array, 0, N);
                        this.itsConstantList = array;
                    }
                }
                if (index == N) {
                    this.itsConstantList[N] = num;
                    this.itsConstantListSize = N + 1;
                }
                String constantName = "_k" + index;
                String constantType = Codegen.getStaticConstantWrapperType(num);
                cfw.add((byte)-78, this.mainClassName, constantName, constantType);
            }
        }
    }

    private static void addDoubleWrap(ClassFileWriter cfw) {
        cfw.addInvoke((byte)-72, "org/mozilla/javascript/optimizer/OptRuntime", "wrapDouble", "(D)Ljava/lang/Double;");
    }

    private static String getStaticConstantWrapperType(double num) {
        int inum = (int)num;
        if ((double)inum == num) {
            return "Ljava/lang/Integer;";
        }
        return "Ljava/lang/Double;";
    }

    static void pushUndefined(ClassFileWriter cfw) {
        cfw.add((byte)-78, "org/mozilla/javascript/Undefined", "instance", "Lorg/mozilla/javascript/Scriptable;");
    }

    int getIndex(ScriptOrFnNode n) {
        return this.scriptOrFnIndexes.getExisting(n);
    }

    static String getDirectTargetFieldName(int i) {
        return "_dt" + i;
    }

    String getDirectCtorName(ScriptOrFnNode n) {
        return "_n" + this.getIndex(n);
    }

    String getBodyMethodName(ScriptOrFnNode n) {
        return "_c" + this.getIndex(n);
    }

    String getBodyMethodSignature(ScriptOrFnNode n) {
        OptFunctionNode ofn;
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        sb.append(this.mainClassSignature);
        sb.append("Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;");
        if (n.getType() == 87 && (ofn = OptFunctionNode.get(n)).isTargetOfDirectCall()) {
            int pCount = ofn.fnode.getParamCount();
            for (int i = 0; i != pCount; ++i) {
                sb.append("Ljava/lang/Object;D");
            }
        }
        sb.append("[Ljava/lang/Object;)Ljava/lang/Object;");
        return sb.toString();
    }

    String getFunctionInitMethodName(OptFunctionNode ofn) {
        return "_i" + this.getIndex(ofn.fnode);
    }

    String getCompiledRegexpName(ScriptOrFnNode n, int regexpIndex) {
        return REGEXP_ARRAY_FIELD_NAME + this.getIndex(n) + "_" + regexpIndex;
    }

    static RuntimeException badTree() {
        throw new RuntimeException("Bad tree in codegen");
    }
}

