/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetSnapshotsAction
extends TransportMasterNodeAction<GetSnapshotsRequest, GetSnapshotsResponse> {
    private final SnapshotsService snapshotsService;

    @Inject
    public TransportGetSnapshotsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SnapshotsService snapshotsService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/snapshot/get", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, GetSnapshotsRequest::new);
        this.snapshotsService = snapshotsService;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected GetSnapshotsResponse newResponse() {
        return new GetSnapshotsResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(GetSnapshotsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(GetSnapshotsRequest request, ClusterState state, ActionListener<GetSnapshotsResponse> listener) {
        try {
            String repository = request.repository();
            ArrayList<SnapshotInfo> snapshotInfoBuilder = new ArrayList<SnapshotInfo>();
            if (this.isAllSnapshots(request.snapshots())) {
                snapshotInfoBuilder.addAll(this.snapshotsService.currentSnapshots(repository));
                snapshotInfoBuilder.addAll(this.snapshotsService.snapshots(repository, this.snapshotsService.snapshotIds(repository), request.ignoreUnavailable()));
            } else if (this.isCurrentSnapshots(request.snapshots())) {
                snapshotInfoBuilder.addAll(this.snapshotsService.currentSnapshots(repository));
            } else {
                HashMap<String, SnapshotId> allSnapshotIds = new HashMap<String, SnapshotId>();
                for (SnapshotInfo snapshotInfo : this.snapshotsService.currentSnapshots(repository)) {
                    SnapshotId snapshotId = snapshotInfo.snapshotId();
                    allSnapshotIds.put(snapshotId.getName(), snapshotId);
                }
                for (SnapshotId snapshotId : this.snapshotsService.snapshotIds(repository)) {
                    allSnapshotIds.put(snapshotId.getName(), snapshotId);
                }
                LinkedHashSet toResolve = new LinkedHashSet();
                for (String snapshotOrPattern : request.snapshots()) {
                    if (!Regex.isSimpleMatchPattern(snapshotOrPattern)) {
                        if (allSnapshotIds.containsKey(snapshotOrPattern)) {
                            toResolve.add(allSnapshotIds.get(snapshotOrPattern));
                            continue;
                        }
                        if (request.ignoreUnavailable()) continue;
                        throw new SnapshotMissingException(repository, snapshotOrPattern);
                    }
                    for (Map.Entry entry : allSnapshotIds.entrySet()) {
                        if (!Regex.simpleMatch(snapshotOrPattern, (String)entry.getKey())) continue;
                        toResolve.add(entry.getValue());
                    }
                }
                if (toResolve.isEmpty() && !request.ignoreUnavailable()) {
                    throw new SnapshotMissingException(repository, request.snapshots()[0]);
                }
                snapshotInfoBuilder.addAll(this.snapshotsService.snapshots(repository, new ArrayList<SnapshotId>(toResolve), request.ignoreUnavailable()));
            }
            listener.onResponse(new GetSnapshotsResponse(snapshotInfoBuilder));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private boolean isAllSnapshots(String[] snapshots) {
        return snapshots.length == 0 || snapshots.length == 1 && "_all".equalsIgnoreCase(snapshots[0]);
    }

    private boolean isCurrentSnapshots(String[] snapshots) {
        return snapshots.length == 1 && "_current".equalsIgnoreCase(snapshots[0]);
    }
}

