/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.indices.InvalidAliasNameException;

public class AliasValidator
extends AbstractComponent {
    @Inject
    public AliasValidator(Settings settings) {
        super(settings);
    }

    public void validateAlias(Alias alias, String index, MetaData metaData) {
        this.validateAlias(alias.name(), index, alias.indexRouting(), name -> metaData.index((String)name));
    }

    public void validateAliasMetaData(AliasMetaData aliasMetaData, String index, MetaData metaData) {
        this.validateAlias(aliasMetaData.alias(), index, aliasMetaData.indexRouting(), name -> metaData.index((String)name));
    }

    public void validateAliasStandalone(Alias alias) {
        this.validateAliasStandalone(alias.name(), alias.indexRouting());
        if (Strings.hasLength(alias.filter())) {
            try (XContentParser parser = XContentFactory.xContent(alias.filter()).createParser(alias.filter());){
                parser.map();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to parse filter for alias [" + alias.name() + "]", e);
            }
        }
    }

    public void validateAlias(String alias, String index, @Nullable String indexRouting, Function<String, IndexMetaData> indexLookup) {
        this.validateAliasStandalone(alias, indexRouting);
        if (!Strings.hasText(index)) {
            throw new IllegalArgumentException("index name is required");
        }
        IndexMetaData indexNamedSameAsAlias = indexLookup.apply(alias);
        if (indexNamedSameAsAlias != null) {
            throw new InvalidAliasNameException(indexNamedSameAsAlias.getIndex(), alias, "an index exists with the same name as the alias");
        }
    }

    private void validateAliasStandalone(String alias, String indexRouting) {
        if (!Strings.hasText(alias)) {
            throw new IllegalArgumentException("alias name is required");
        }
        if (indexRouting != null && indexRouting.indexOf(44) != -1) {
            throw new IllegalArgumentException("alias [" + alias + "] has several index routing values associated with it");
        }
    }

    public void validateAliasFilter(String alias, String filter, QueryShardContext queryShardContext) {
        assert (queryShardContext != null);
        try (XContentParser parser = XContentFactory.xContent(filter).createParser(filter);){
            AliasValidator.validateAliasFilter(parser, queryShardContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse filter for alias [" + alias + "]", e);
        }
    }

    public void validateAliasFilter(String alias, byte[] filter, QueryShardContext queryShardContext) {
        assert (queryShardContext != null);
        try (XContentParser parser = XContentFactory.xContent(filter).createParser(filter);){
            AliasValidator.validateAliasFilter(parser, queryShardContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse filter for alias [" + alias + "]", e);
        }
    }

    private static void validateAliasFilter(XContentParser parser, QueryShardContext queryShardContext) throws IOException {
        QueryParseContext queryParseContext = queryShardContext.newParseContext(parser);
        Optional<QueryBuilder> parseInnerQueryBuilder = queryParseContext.parseInnerQueryBuilder();
        if (parseInnerQueryBuilder.isPresent()) {
            QueryBuilder queryBuilder = QueryBuilder.rewriteQuery(parseInnerQueryBuilder.get(), queryShardContext);
            queryBuilder.toFilter(queryShardContext);
        }
    }
}

