/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.internal.InternalSearchHitField;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.lookup.SourceLookup;

public class InternalSearchHit
implements SearchHit {
    private static final Object[] EMPTY_SORT_VALUES = new Object[0];
    private transient int docId;
    private float score = Float.NEGATIVE_INFINITY;
    private Text id;
    private Text type;
    private InternalNestedIdentity nestedIdentity;
    private long version = -1L;
    private BytesReference source;
    private Map<String, SearchHitField> fields = Collections.emptyMap();
    private Map<String, HighlightField> highlightFields = null;
    private Object[] sortValues = EMPTY_SORT_VALUES;
    private String[] matchedQueries = Strings.EMPTY_ARRAY;
    private Explanation explanation;
    @Nullable
    private SearchShardTarget shard;
    private Map<String, Object> sourceAsMap;
    private byte[] sourceAsBytes;
    private Map<String, InternalSearchHits> innerHits;

    private InternalSearchHit() {
    }

    public InternalSearchHit(int docId) {
        this(docId, null, null, null);
    }

    public InternalSearchHit(int docId, String id, Text type, Map<String, SearchHitField> fields) {
        this.docId = docId;
        this.id = id != null ? new Text(id) : null;
        this.type = type;
        this.fields = fields;
    }

    public InternalSearchHit(int nestedTopDocId, String id, Text type, InternalNestedIdentity nestedIdentity, Map<String, SearchHitField> fields) {
        this.docId = nestedTopDocId;
        this.id = new Text(id);
        this.type = type;
        this.nestedIdentity = nestedIdentity;
        this.fields = fields;
    }

    public int docId() {
        return this.docId;
    }

    public void shardTarget(SearchShardTarget shardTarget) {
        this.shard = shardTarget;
        if (this.innerHits != null) {
            for (InternalSearchHits searchHits : this.innerHits.values()) {
                searchHits.shardTarget(shardTarget);
            }
        }
    }

    public void score(float score) {
        this.score = score;
    }

    @Override
    public float score() {
        return this.score;
    }

    @Override
    public float getScore() {
        return this.score();
    }

    public void version(long version) {
        this.version = version;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public String index() {
        return this.shard.index();
    }

    @Override
    public String getIndex() {
        return this.index();
    }

    @Override
    public String id() {
        return this.id != null ? this.id.string() : null;
    }

    @Override
    public String getId() {
        return this.id();
    }

    @Override
    public String type() {
        return this.type != null ? this.type.string() : null;
    }

    @Override
    public String getType() {
        return this.type();
    }

    @Override
    public SearchHit.NestedIdentity getNestedIdentity() {
        return this.nestedIdentity;
    }

    @Override
    public BytesReference sourceRef() {
        try {
            this.source = CompressorFactory.uncompressIfNeeded(this.source);
            return this.source;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to decompress source", (Throwable)e, new Object[0]);
        }
    }

    public InternalSearchHit sourceRef(BytesReference source) {
        this.source = source;
        this.sourceAsBytes = null;
        this.sourceAsMap = null;
        return this;
    }

    @Override
    public BytesReference getSourceRef() {
        return this.sourceRef();
    }

    public BytesReference internalSourceRef() {
        return this.source;
    }

    @Override
    public byte[] source() {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsBytes != null) {
            return this.sourceAsBytes;
        }
        this.sourceAsBytes = BytesReference.toBytes(this.sourceRef());
        return this.sourceAsBytes;
    }

    @Override
    public boolean hasSource() {
        return this.source == null;
    }

    @Override
    public Map<String, Object> getSource() {
        return this.sourceAsMap();
    }

    @Override
    public String sourceAsString() {
        if (this.source == null) {
            return null;
        }
        try {
            return XContentHelper.convertToJson(this.sourceRef(), false);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to convert source to a json string", new Object[0]);
        }
    }

    @Override
    public String getSourceAsString() {
        return this.sourceAsString();
    }

    @Override
    public Map<String, Object> sourceAsMap() throws ElasticsearchParseException {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsMap != null) {
            return this.sourceAsMap;
        }
        this.sourceAsMap = SourceLookup.sourceAsMap(this.source);
        return this.sourceAsMap;
    }

    @Override
    public Iterator<SearchHitField> iterator() {
        return this.fields.values().iterator();
    }

    @Override
    public SearchHitField field(String fieldName) {
        return this.fields().get(fieldName);
    }

    @Override
    public Map<String, SearchHitField> fields() {
        return this.fields == null ? Collections.emptyMap() : this.fields;
    }

    public Map<String, SearchHitField> fieldsOrNull() {
        return this.fields;
    }

    @Override
    public Map<String, SearchHitField> getFields() {
        return this.fields();
    }

    public void fields(Map<String, SearchHitField> fields) {
        this.fields = fields;
    }

    public Map<String, HighlightField> internalHighlightFields() {
        return this.highlightFields;
    }

    @Override
    public Map<String, HighlightField> highlightFields() {
        return this.highlightFields == null ? Collections.emptyMap() : this.highlightFields;
    }

    @Override
    public Map<String, HighlightField> getHighlightFields() {
        return this.highlightFields();
    }

    public void highlightFields(Map<String, HighlightField> highlightFields) {
        this.highlightFields = highlightFields;
    }

    public void sortValues(Object[] sortValues, DocValueFormat[] sortValueFormats) {
        this.sortValues = Arrays.copyOf(sortValues, sortValues.length);
        for (int i = 0; i < sortValues.length; ++i) {
            if (!(this.sortValues[i] instanceof BytesRef)) continue;
            this.sortValues[i] = sortValueFormats[i].format((BytesRef)sortValues[i]);
        }
    }

    @Override
    public Object[] sortValues() {
        return this.sortValues;
    }

    @Override
    public Object[] getSortValues() {
        return this.sortValues();
    }

    @Override
    public Explanation explanation() {
        return this.explanation;
    }

    @Override
    public Explanation getExplanation() {
        return this.explanation();
    }

    public void explanation(Explanation explanation) {
        this.explanation = explanation;
    }

    @Override
    public SearchShardTarget shard() {
        return this.shard;
    }

    @Override
    public SearchShardTarget getShard() {
        return this.shard();
    }

    public void shard(SearchShardTarget target) {
        this.shard = target;
    }

    public void matchedQueries(String[] matchedQueries) {
        this.matchedQueries = matchedQueries;
    }

    @Override
    public String[] matchedQueries() {
        return this.matchedQueries;
    }

    @Override
    public String[] getMatchedQueries() {
        return this.matchedQueries;
    }

    @Override
    public Map<String, SearchHits> getInnerHits() {
        return this.innerHits;
    }

    public void setInnerHits(Map<String, InternalSearchHits> innerHits) {
        this.innerHits = innerHits;
    }

    public XContentBuilder toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ArrayList<SearchHitField> metaFields = new ArrayList<SearchHitField>();
        ArrayList<SearchHitField> otherFields = new ArrayList<SearchHitField>();
        if (this.fields != null && !this.fields.isEmpty()) {
            for (SearchHitField searchHitField : this.fields.values()) {
                if (searchHitField.values().isEmpty()) continue;
                if (searchHitField.isMetadataField()) {
                    metaFields.add(searchHitField);
                    continue;
                }
                otherFields.add(searchHitField);
            }
        }
        if (this.explanation() != null && this.shard != null) {
            builder.field("_shard", this.shard.shardId());
            builder.field("_node", this.shard.nodeIdText());
        }
        if (this.nestedIdentity != null) {
            this.nestedIdentity.toXContent(builder, params);
        } else {
            if (this.shard != null) {
                builder.field("_index", this.shard.indexText());
            }
            if (this.type != null) {
                builder.field("_type", this.type);
            }
            if (this.id != null) {
                builder.field("_id", this.id);
            }
        }
        if (this.version != -1L) {
            builder.field("_version", this.version);
        }
        if (Float.isNaN(this.score)) {
            builder.nullField("_score");
        } else {
            builder.field("_score", this.score);
        }
        for (SearchHitField searchHitField : metaFields) {
            builder.field(searchHitField.name(), searchHitField.value());
        }
        if (this.source != null) {
            XContentHelper.writeRawField("_source", this.source, builder, params);
        }
        if (!otherFields.isEmpty()) {
            builder.startObject("fields");
            for (SearchHitField searchHitField : otherFields) {
                builder.startArray(searchHitField.name());
                for (Object value : searchHitField.getValues()) {
                    builder.value(value);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        if (this.highlightFields != null && !this.highlightFields.isEmpty()) {
            builder.startObject("highlight");
            for (HighlightField highlightField : this.highlightFields.values()) {
                builder.field(highlightField.name());
                if (highlightField.fragments() == null) {
                    builder.nullValue();
                    continue;
                }
                builder.startArray();
                for (Text fragment : highlightField.fragments()) {
                    builder.value(fragment);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        if (this.sortValues != null && this.sortValues.length > 0) {
            builder.startArray("sort");
            for (Object sortValue : this.sortValues) {
                builder.value(sortValue);
            }
            builder.endArray();
        }
        if (this.matchedQueries.length > 0) {
            builder.startArray("matched_queries");
            for (String matchedFilter : this.matchedQueries) {
                builder.value(matchedFilter);
            }
            builder.endArray();
        }
        if (this.explanation() != null) {
            builder.field("_explanation");
            this.buildExplanation(builder, this.explanation());
        }
        if (this.innerHits != null) {
            builder.startObject("inner_hits");
            for (Map.Entry entry : this.innerHits.entrySet()) {
                builder.startObject((String)entry.getKey());
                ((InternalSearchHits)entry.getValue()).toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    private void buildExplanation(XContentBuilder builder, Explanation explanation) throws IOException {
        builder.startObject();
        builder.field("value", explanation.getValue());
        builder.field("description", explanation.getDescription());
        Explanation[] innerExps = explanation.getDetails();
        if (innerExps != null) {
            builder.startArray("details");
            for (Explanation exp : innerExps) {
                this.buildExplanation(builder, exp);
            }
            builder.endArray();
        }
        builder.endObject();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toInnerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public static InternalSearchHit readSearchHit(StreamInput in) throws IOException {
        InternalSearchHit hit = new InternalSearchHit();
        hit.readFrom(in);
        return hit;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        int size;
        this.score = in.readFloat();
        this.id = in.readOptionalText();
        this.type = in.readOptionalText();
        this.nestedIdentity = in.readOptionalStreamable(InternalNestedIdentity::new);
        this.version = in.readLong();
        this.source = in.readBytesReference();
        if (this.source.length() == 0) {
            this.source = null;
        }
        if (in.readBoolean()) {
            this.explanation = Lucene.readExplanation(in);
        }
        if ((size = in.readVInt()) == 0) {
            this.fields = Collections.emptyMap();
        } else if (size == 1) {
            InternalSearchHitField hitField = InternalSearchHitField.readSearchHitField(in);
            this.fields = Collections.singletonMap(hitField.name(), hitField);
        } else {
            HashMap<String, InternalSearchHitField> fields = new HashMap<String, InternalSearchHitField>();
            for (i = 0; i < size; ++i) {
                InternalSearchHitField hitField = InternalSearchHitField.readSearchHitField(in);
                fields.put(hitField.name(), hitField);
            }
            this.fields = Collections.unmodifiableMap(fields);
        }
        size = in.readVInt();
        if (size == 0) {
            this.highlightFields = Collections.emptyMap();
        } else if (size == 1) {
            HighlightField field = HighlightField.readHighlightField(in);
            this.highlightFields = Collections.singletonMap(field.name(), field);
        } else {
            HashMap<String, HighlightField> highlightFields = new HashMap<String, HighlightField>();
            for (i = 0; i < size; ++i) {
                HighlightField field = HighlightField.readHighlightField(in);
                highlightFields.put(field.name(), field);
            }
            this.highlightFields = Collections.unmodifiableMap(highlightFields);
        }
        size = in.readVInt();
        if (size > 0) {
            this.sortValues = new Object[size];
            for (int i2 = 0; i2 < this.sortValues.length; ++i2) {
                byte type = in.readByte();
                if (type == 0) {
                    this.sortValues[i2] = null;
                    continue;
                }
                if (type == 1) {
                    this.sortValues[i2] = in.readString();
                    continue;
                }
                if (type == 2) {
                    this.sortValues[i2] = in.readInt();
                    continue;
                }
                if (type == 3) {
                    this.sortValues[i2] = in.readLong();
                    continue;
                }
                if (type == 4) {
                    this.sortValues[i2] = Float.valueOf(in.readFloat());
                    continue;
                }
                if (type == 5) {
                    this.sortValues[i2] = in.readDouble();
                    continue;
                }
                if (type == 6) {
                    this.sortValues[i2] = in.readByte();
                    continue;
                }
                if (type == 7) {
                    this.sortValues[i2] = in.readShort();
                    continue;
                }
                if (type == 8) {
                    this.sortValues[i2] = in.readBoolean();
                    continue;
                }
                throw new IOException("Can't match type [" + type + "]");
            }
        }
        if ((size = in.readVInt()) > 0) {
            this.matchedQueries = new String[size];
            for (int i3 = 0; i3 < size; ++i3) {
                this.matchedQueries[i3] = in.readString();
            }
        }
        this.shard = in.readOptionalWriteable(SearchShardTarget::new);
        size = in.readVInt();
        if (size > 0) {
            this.innerHits = new HashMap<String, InternalSearchHits>(size);
            for (int i4 = 0; i4 < size; ++i4) {
                String key = in.readString();
                InternalSearchHits value = InternalSearchHits.readSearchHits(in);
                this.innerHits.put(key, value);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeFloat(this.score);
        out.writeOptionalText(this.id);
        out.writeOptionalText(this.type);
        out.writeOptionalStreamable(this.nestedIdentity);
        out.writeLong(this.version);
        out.writeBytesReference(this.source);
        if (this.explanation == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Lucene.writeExplanation(out, this.explanation);
        }
        if (this.fields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.fields.size());
            for (SearchHitField searchHitField : this.fields().values()) {
                searchHitField.writeTo(out);
            }
        }
        if (this.highlightFields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.highlightFields.size());
            for (HighlightField highlightField : this.highlightFields.values()) {
                highlightField.writeTo(out);
            }
        }
        if (this.sortValues.length == 0) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.sortValues.length);
            for (Iterator<Streamable> iterator : this.sortValues) {
                if (iterator == null) {
                    out.writeByte((byte)0);
                    continue;
                }
                Class<?> type = iterator.getClass();
                if (type == String.class) {
                    out.writeByte((byte)1);
                    out.writeString((String)((Object)iterator));
                    continue;
                }
                if (type == Integer.class) {
                    out.writeByte((byte)2);
                    out.writeInt((Integer)((Object)iterator));
                    continue;
                }
                if (type == Long.class) {
                    out.writeByte((byte)3);
                    out.writeLong((Long)((Object)iterator));
                    continue;
                }
                if (type == Float.class) {
                    out.writeByte((byte)4);
                    out.writeFloat(((Float)((Object)iterator)).floatValue());
                    continue;
                }
                if (type == Double.class) {
                    out.writeByte((byte)5);
                    out.writeDouble((Double)((Object)iterator));
                    continue;
                }
                if (type == Byte.class) {
                    out.writeByte((byte)6);
                    out.writeByte((Byte)((Object)iterator));
                    continue;
                }
                if (type == Short.class) {
                    out.writeByte((byte)7);
                    out.writeShort((Short)((Object)iterator));
                    continue;
                }
                if (type == Boolean.class) {
                    out.writeByte((byte)8);
                    out.writeBoolean((Boolean)((Object)iterator));
                    continue;
                }
                throw new IOException("Can't handle sort field value of type [" + type + "]");
            }
        }
        if (this.matchedQueries.length == 0) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.matchedQueries.length);
            for (Iterator<Streamable> iterator : this.matchedQueries) {
                out.writeString((String)((Object)iterator));
            }
        }
        out.writeOptionalWriteable(this.shard);
        if (this.innerHits == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.innerHits.size());
            for (Map.Entry entry : this.innerHits.entrySet()) {
                out.writeString((String)entry.getKey());
                ((InternalSearchHits)entry.getValue()).writeTo(out);
            }
        }
    }

    public static final class InternalNestedIdentity
    implements SearchHit.NestedIdentity,
    Streamable,
    ToXContent {
        private Text field;
        private int offset;
        private InternalNestedIdentity child;

        public InternalNestedIdentity(String field, int offset, InternalNestedIdentity child) {
            this.field = new Text(field);
            this.offset = offset;
            this.child = child;
        }

        InternalNestedIdentity() {
        }

        @Override
        public Text getField() {
            return this.field;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        @Override
        public SearchHit.NestedIdentity getChild() {
            return this.child;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.field = in.readOptionalText();
            this.offset = in.readInt();
            this.child = in.readOptionalStreamable(InternalNestedIdentity::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalText(this.field);
            out.writeInt(this.offset);
            out.writeOptionalStreamable(this.child);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("_nested");
            if (this.field != null) {
                builder.field("field", this.field);
            }
            if (this.offset != -1) {
                builder.field("offset", this.offset);
            }
            if (this.child != null) {
                builder = this.child.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        public static class Fields {
            static final String _NESTED = "_nested";
            static final String _NESTED_FIELD = "field";
            static final String _NESTED_OFFSET = "offset";
        }
    }

    public static class Fields {
        static final String _INDEX = "_index";
        static final String _TYPE = "_type";
        static final String _ID = "_id";
        static final String _VERSION = "_version";
        static final String _SCORE = "_score";
        static final String FIELDS = "fields";
        static final String HIGHLIGHT = "highlight";
        static final String SORT = "sort";
        static final String MATCHED_QUERIES = "matched_queries";
        static final String _EXPLANATION = "_explanation";
        static final String VALUE = "value";
        static final String DESCRIPTION = "description";
        static final String DETAILS = "details";
        static final String INNER_HITS = "inner_hits";
    }
}

