/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Date;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.HashAlgorithmTags;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.util.encoders.Base64;

public class PGPUtil
implements HashAlgorithmTags {
    private static String defProvider = "BC";
    private static final int READ_AHEAD = 60;

    public static String getDefaultProvider() {
        return defProvider;
    }

    public static void setDefaultProvider(String string) {
        defProvider = string;
    }

    static MPInteger[] dsaSigToMpi(byte[] byArray) throws PGPException {
        ASN1Integer aSN1Integer;
        ASN1Integer aSN1Integer2;
        MPInteger[] mPIntegerArray;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        try {
            mPIntegerArray = (MPInteger[])aSN1InputStream.readObject();
            aSN1Integer2 = (ASN1Integer)mPIntegerArray.getObjectAt(0);
            aSN1Integer = (ASN1Integer)mPIntegerArray.getObjectAt(1);
        }
        catch (IOException iOException) {
            throw new PGPException("exception encoding signature", iOException);
        }
        mPIntegerArray = new MPInteger[]{new MPInteger(aSN1Integer2.getValue()), new MPInteger(aSN1Integer.getValue())};
        return mPIntegerArray;
    }

    static String getDigestName(int n) throws PGPException {
        switch (n) {
            case 2: {
                return "SHA1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA256";
            }
            case 9: {
                return "SHA384";
            }
            case 10: {
                return "SHA512";
            }
            case 11: {
                return "SHA224";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + n);
    }

    static String getSignatureName(int n, int n2) throws PGPException {
        String string;
        switch (n) {
            case 1: 
            case 3: {
                string = "RSA";
                break;
            }
            case 17: {
                string = "DSA";
                break;
            }
            case 16: 
            case 20: {
                string = "ElGamal";
                break;
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + n);
            }
        }
        return PGPUtil.getDigestName(n2) + "with" + string;
    }

    public static byte[] makeRandomKey(int n, SecureRandom secureRandom) throws PGPException {
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = 192;
                break;
            }
            case 1: {
                n2 = 128;
                break;
            }
            case 3: {
                n2 = 128;
                break;
            }
            case 4: {
                n2 = 128;
                break;
            }
            case 5: {
                n2 = 128;
                break;
            }
            case 6: {
                n2 = 64;
                break;
            }
            case 7: {
                n2 = 128;
                break;
            }
            case 8: {
                n2 = 192;
                break;
            }
            case 9: {
                n2 = 256;
                break;
            }
            case 11: {
                n2 = 128;
                break;
            }
            case 12: {
                n2 = 192;
                break;
            }
            case 13: {
                n2 = 256;
                break;
            }
            case 10: {
                n2 = 256;
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + n);
            }
        }
        byte[] byArray = new byte[(n2 + 7) / 8];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    public static void writeFileToLiteralData(OutputStream outputStream, char c, File file) throws IOException {
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream2 = pGPLiteralDataGenerator.open(outputStream, c, file);
        PGPUtil.pipeFileContents(file, outputStream2, 4096);
    }

    public static void writeFileToLiteralData(OutputStream outputStream, char c, File file, byte[] byArray) throws IOException {
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream2 = pGPLiteralDataGenerator.open(outputStream, c, file.getName(), new Date(file.lastModified()), byArray);
        PGPUtil.pipeFileContents(file, outputStream2, byArray.length);
    }

    private static void pipeFileContents(File file, OutputStream outputStream, int n) throws IOException {
        int n2;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[n];
        while ((n2 = fileInputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n2);
        }
        outputStream.close();
        fileInputStream.close();
    }

    private static boolean isPossiblyBase64(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 48 && n <= 57 || n == 43 || n == 47 || n == 13 || n == 10;
    }

    public static InputStream getDecoderStream(InputStream inputStream) throws IOException {
        int n;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStreamExt(inputStream);
        }
        inputStream.mark(60);
        int n2 = inputStream.read();
        if ((n2 & 0x80) != 0) {
            inputStream.reset();
            return inputStream;
        }
        if (!PGPUtil.isPossiblyBase64(n2)) {
            inputStream.reset();
            return new ArmoredInputStream(inputStream);
        }
        byte[] byArray = new byte[60];
        int n3 = 1;
        byArray[0] = (byte)n2;
        for (n = 1; n != 60 && (n2 = inputStream.read()) >= 0; ++n) {
            if (!PGPUtil.isPossiblyBase64(n2)) {
                inputStream.reset();
                return new ArmoredInputStream(inputStream);
            }
            if (n2 == 10 || n2 == 13) continue;
            byArray[n3++] = (byte)n2;
        }
        inputStream.reset();
        if (n < 4) {
            return new ArmoredInputStream(inputStream);
        }
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        byte[] byArray3 = Base64.decode((byte[])byArray2);
        if ((byArray3[0] & 0x80) != 0) {
            return new ArmoredInputStream(inputStream, false);
        }
        return new ArmoredInputStream(inputStream);
    }

    static class BufferedInputStreamExt
    extends BufferedInputStream {
        BufferedInputStreamExt(InputStream inputStream) {
            super(inputStream);
        }

        public synchronized int available() throws IOException {
            int n = super.available();
            if (n < 0) {
                n = Integer.MAX_VALUE;
            }
            return n;
        }
    }
}

