/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CppPCHCompileSpec;
import org.gradle.util.CollectionUtils;

public class PCHUtils {
    public static File generatePCHObjectDirectory(File tempDir, File prefixHeaderFile, File preCompiledHeaderObjectFile) {
        File generatedDir = new File(tempDir, "preCompiledHeaders");
        generatedDir.mkdirs();
        File generatedHeader = new File(generatedDir, prefixHeaderFile.getName());
        File generatedPCH = new File(generatedDir, preCompiledHeaderObjectFile.getName());
        try {
            FileUtils.copyFile((File)prefixHeaderFile, (File)generatedHeader);
            FileUtils.copyFile((File)preCompiledHeaderObjectFile, (File)generatedPCH);
            return generatedDir;
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static void generatePCHFile(List<String> headers, File headerFile) {
        if (!headerFile.getParentFile().exists()) {
            headerFile.getParentFile().mkdirs();
        }
        try {
            FileUtils.writeLines((File)headerFile, (Collection)CollectionUtils.collect(headers, (Transformer)new Transformer<String, String>(){

                public String transform(String header) {
                    if (header.startsWith("<")) {
                        return "#include ".concat(header);
                    }
                    return "#include \"".concat(header).concat("\"");
                }
            }));
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static <T extends NativeCompileSpec> File generatePCHSourceFile(T original, File sourceFile) {
        File generatedSourceDir = new File(original.getTempDir(), "pchGenerated");
        generatedSourceDir.mkdirs();
        File generatedSource = new File(generatedSourceDir, FilenameUtils.removeExtension((String)sourceFile.getName()).concat(PCHUtils.getSourceFileExtension(original.getClass())));
        File headerFileCopy = new File(generatedSourceDir, sourceFile.getName());
        try {
            FileUtils.copyFile((File)sourceFile, (File)headerFileCopy);
            FileUtils.writeStringToFile((File)generatedSource, (String)"#include \"".concat(headerFileCopy.getName()).concat("\""));
            return generatedSource;
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public static <T extends NativeCompileSpec> Transformer<T, T> getHeaderToSourceFileTransformer(Class<T> type) {
        return new Transformer<T, T>(){

            public T transform(T original) {
                ArrayList newSourceFiles = Lists.newArrayList();
                for (File sourceFile : original.getSourceFiles()) {
                    newSourceFiles.add(PCHUtils.generatePCHSourceFile(original, sourceFile));
                }
                original.setSourceFiles(newSourceFiles);
                return original;
            }
        };
    }

    private static String getSourceFileExtension(Class<? extends NativeCompileSpec> specClass) {
        if (CPCHCompileSpec.class.isAssignableFrom(specClass)) {
            return ".c";
        }
        if (CppPCHCompileSpec.class.isAssignableFrom(specClass)) {
            return ".cpp";
        }
        throw new IllegalArgumentException("Cannot determine source file extension for spec with type ".concat(specClass.getSimpleName()));
    }
}

