/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.runtimeshaded;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.runtimeshaded.ImplementationDependencyRelocator;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.progress.PercentageProgressFormatter;
import org.gradle.util.GFileUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RuntimeShadedJarCreator {
    public static final int ADDITIONAL_PROGRESS_STEPS = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeShadedJarCreator.class);
    private static final int BUFFER_SIZE = 8192;
    private static final String SERVICES_DIR_PREFIX = "META-INF/services/";
    private static final String CLASS_DESC = "Ljava/lang/Class;";
    private final ProgressLoggerFactory progressLoggerFactory;
    private final ImplementationDependencyRelocator remapper;

    public RuntimeShadedJarCreator(ProgressLoggerFactory progressLoggerFactory, ImplementationDependencyRelocator remapper) {
        this.progressLoggerFactory = progressLoggerFactory;
        this.remapper = remapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(File outputJar, Iterable<? extends File> files) {
        LOGGER.info("Generating gradleApi JAR file: " + outputJar.getAbsolutePath());
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(RuntimeShadedJarCreator.class);
        progressLogger.setDescription("Gradle JARs generation");
        progressLogger.setLoggingHeader("Generating JAR file '" + outputJar.getName() + "'");
        progressLogger.started();
        try {
            this.createFatJar(outputJar, files, progressLogger);
        }
        finally {
            progressLogger.completed();
        }
    }

    private void createFatJar(File outputJar, final Iterable<? extends File> files, final ProgressLogger progressLogger) {
        File tmpFile = this.tempFileFor(outputJar);
        IoActions.withResource((Closeable)this.openJarOutputStream(tmpFile), (Action)new ErroringAction<ZipOutputStream>(){

            protected void doExecute(ZipOutputStream jarOutputStream) throws Exception {
                RuntimeShadedJarCreator.this.processFiles(jarOutputStream, files, new byte[8192], new HashSet(), new HashMap(), progressLogger);
                jarOutputStream.finish();
            }
        });
        GFileUtils.moveFile((File)tmpFile, (File)outputJar);
    }

    private File tempFileFor(File outputJar) {
        try {
            File tmpFile = File.createTempFile(outputJar.getName(), ".tmp");
            tmpFile.deleteOnExit();
            return tmpFile;
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private ZipOutputStream openJarOutputStream(File outputJar) {
        try {
            ZipOutputStream outputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputJar), 8192));
            outputStream.setLevel(0);
            return outputStream;
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private void processFiles(ZipOutputStream outputStream, Iterable<? extends File> files, byte[] buffer, HashSet<String> seenPaths, Map<String, List<String>> services, ProgressLogger progressLogger) throws Exception {
        PercentageProgressFormatter progressFormatter = new PercentageProgressFormatter("Generating", Iterables.size(files) + 2);
        for (File file : files) {
            progressLogger.progress(progressFormatter.getProgress());
            if (file.getName().endsWith(".jar")) {
                this.processJarFile(outputStream, file, buffer, seenPaths, services);
            } else {
                this.processDirectory(outputStream, file, buffer, seenPaths, services);
            }
            progressFormatter.increment();
        }
        this.writeServiceFiles(outputStream, services);
        progressLogger.progress(progressFormatter.incrementAndGetProgress());
        this.writeIdentifyingMarkerFile(outputStream);
        progressLogger.progress(progressFormatter.incrementAndGetProgress());
    }

    private void writeServiceFiles(ZipOutputStream outputStream, Map<String, List<String>> services) throws IOException {
        for (Map.Entry<String, List<String>> service : services.entrySet()) {
            String allProviders = Joiner.on((String)"\n").join((Iterable)service.getValue());
            this.writeEntry(outputStream, SERVICES_DIR_PREFIX + service.getKey(), allProviders.getBytes(Charsets.UTF_8));
        }
    }

    private void writeIdentifyingMarkerFile(ZipOutputStream outputStream) throws IOException {
        this.writeEntry(outputStream, "META-INF/.gradle-runtime-shaded", new byte[0]);
    }

    private void processDirectory(final ZipOutputStream outputStream, File file, final byte[] buffer, final HashSet<String> seenPaths, final Map<String, List<String>> services) {
        new DirectoryFileTree(file).visit(new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
                try {
                    ZipEntry zipEntry = new ZipEntry(dirDetails.getPath() + "/");
                    RuntimeShadedJarCreator.this.processEntry(outputStream, null, zipEntry, buffer, seenPaths, services);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitFile(FileVisitDetails fileDetails) {
                try {
                    ZipEntry zipEntry = new ZipEntry(fileDetails.getPath());
                    InputStream inputStream = fileDetails.open();
                    try {
                        RuntimeShadedJarCreator.this.processEntry(outputStream, inputStream, zipEntry, buffer, seenPaths, services);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        });
    }

    private void processJarFile(final ZipOutputStream outputStream, File file, final byte[] buffer, final Set<String> seenPaths, final Map<String, List<String>> services) throws IOException {
        IoActions.withResource((Closeable)this.openJarFile(file), (Action)new ErroringAction<ZipInputStream>(){

            protected void doExecute(ZipInputStream inputStream) throws Exception {
                ZipEntry zipEntry = inputStream.getNextEntry();
                while (zipEntry != null) {
                    RuntimeShadedJarCreator.this.processEntry(outputStream, inputStream, zipEntry, buffer, seenPaths, services);
                    zipEntry = inputStream.getNextEntry();
                }
            }
        });
    }

    private void processEntry(ZipOutputStream outputStream, InputStream inputStream, ZipEntry zipEntry, byte[] buffer, Set<String> seenPaths, Map<String, List<String>> services) throws IOException {
        String name = zipEntry.getName();
        if (zipEntry.isDirectory() || name.equals("META-INF/MANIFEST.MF")) {
            return;
        }
        if (!name.startsWith(SERVICES_DIR_PREFIX) && !seenPaths.add(name)) {
            return;
        }
        if (name.endsWith(".class")) {
            this.processClassFile(outputStream, inputStream, zipEntry, buffer);
        } else if (name.startsWith(SERVICES_DIR_PREFIX)) {
            this.processServiceDescriptor(inputStream, zipEntry, buffer, services);
        } else {
            this.copyEntry(outputStream, inputStream, zipEntry, buffer);
        }
    }

    private void processServiceDescriptor(InputStream inputStream, ZipEntry zipEntry, byte[] buffer, Map<String, List<String>> services) throws IOException {
        byte[] bytes;
        String entry;
        String descriptorImplClass;
        String relocatedImplClassName;
        String descriptorName = zipEntry.getName().substring(SERVICES_DIR_PREFIX.length());
        String descriptorApiClass = this.periodsToSlashes(descriptorName);
        String relocatedApiClassName = this.remapper.maybeRelocateResource(descriptorApiClass);
        if (relocatedApiClassName == null) {
            relocatedApiClassName = descriptorApiClass;
        }
        if ((relocatedImplClassName = this.remapper.maybeRelocateResource(descriptorImplClass = this.periodsToSlashes(entry = new String(bytes = this.readEntry(inputStream, zipEntry, buffer), Charsets.UTF_8).replaceAll("(?m)^#.*", "").trim()))) == null) {
            relocatedImplClassName = descriptorImplClass;
        }
        String serviceType = this.slashesToPeriods(relocatedApiClassName);
        String serviceProvider = this.slashesToPeriods(relocatedImplClassName).trim();
        if (!services.containsKey(serviceType)) {
            services.put(serviceType, Lists.newArrayList((Object[])new String[]{serviceProvider}));
        } else {
            List<String> providers = services.get(serviceType);
            providers.add(serviceProvider);
        }
    }

    private String slashesToPeriods(String slashClassName) {
        return slashClassName.replace('/', '.');
    }

    private String periodsToSlashes(String periodClassName) {
        return periodClassName.replace('.', '/');
    }

    private void copyEntry(ZipOutputStream outputStream, InputStream inputStream, ZipEntry zipEntry, byte[] buffer) throws IOException {
        String remappedResourceName;
        String path;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        this.pipe(inputStream, bos, buffer);
        String originalName = zipEntry.getName();
        byte[] resource = bos.toByteArray();
        int i = originalName.lastIndexOf("/");
        String string = path = i == -1 ? null : originalName.substring(0, i);
        if (this.remapper.keepOriginalResource(path)) {
            this.writeResourceEntry(outputStream, new ByteArrayInputStream(resource), buffer, zipEntry.getName());
        }
        String string2 = remappedResourceName = path != null ? this.remapper.maybeRelocateResource(path) : null;
        if (remappedResourceName != null) {
            String newFileName = remappedResourceName + originalName.substring(i);
            this.writeResourceEntry(outputStream, new ByteArrayInputStream(resource), buffer, newFileName);
        }
    }

    private void writeResourceEntry(ZipOutputStream outputStream, InputStream inputStream, byte[] buffer, String resourceFileName) throws IOException {
        outputStream.putNextEntry(new ZipEntry(resourceFileName));
        this.pipe(inputStream, outputStream, buffer);
        outputStream.closeEntry();
    }

    private void writeEntry(ZipOutputStream outputStream, String name, byte[] content) throws IOException {
        ZipEntry zipEntry = new ZipEntry(name);
        outputStream.putNextEntry(zipEntry);
        outputStream.write(content);
        outputStream.closeEntry();
    }

    private void processClassFile(ZipOutputStream outputStream, InputStream inputStream, ZipEntry zipEntry, byte[] buffer) throws IOException {
        String className = zipEntry.getName().substring(0, zipEntry.getName().length() - ".class".length());
        byte[] bytes = this.readEntry(inputStream, zipEntry, buffer);
        byte[] remappedClass = this.remapClass(className, bytes);
        String remappedClassName = this.remapper.maybeRelocateResource(className);
        String newFileName = (remappedClassName == null ? className : remappedClassName).concat(".class");
        this.writeEntry(outputStream, newFileName, remappedClass);
    }

    private byte[] remapClass(String className, byte[] bytes) {
        ClassReader classReader = new ClassReader(bytes);
        ClassWriter classWriter = new ClassWriter(0);
        ShadingClassRemapper remappingVisitor = new ShadingClassRemapper(classWriter, this.remapper);
        try {
            classReader.accept((ClassVisitor)remappingVisitor, 8);
        }
        catch (Exception e) {
            throw new GradleException("Error in ASM processing class: " + className, (Throwable)e);
        }
        return classWriter.toByteArray();
    }

    private byte[] readEntry(InputStream inputStream, ZipEntry zipEntry, byte[] buffer) throws IOException {
        int size = (int)zipEntry.getSize();
        if (size == -1) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(buffer.length);
            int read = inputStream.read(buffer);
            while (read != -1) {
                out.write(buffer, 0, read);
                read = inputStream.read(buffer);
            }
            return out.toByteArray();
        }
        byte[] bytes = new byte[size];
        for (int read = inputStream.read(bytes); read < size; read += inputStream.read(bytes, read, size - read)) {
        }
        return bytes;
    }

    private void pipe(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        int read = inputStream.read(buffer);
        while (read != -1) {
            outputStream.write(buffer, 0, read);
            read = inputStream.read(buffer);
        }
    }

    private ZipInputStream openJarFile(File file) throws IOException {
        return new ZipInputStream(new FileInputStream(file));
    }

    private static class ShadingClassRemapper
    extends ClassRemapper {
        Map<String, String> remappedClassLiterals;
        private final ImplementationDependencyRelocator remapper;

        public ShadingClassRemapper(ClassWriter classWriter, ImplementationDependencyRelocator remapper) {
            super((ClassVisitor)classWriter, (Remapper)remapper);
            this.remapper = remapper;
            this.remappedClassLiterals = new HashMap<String, String>();
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            ImplementationDependencyRelocator.ClassLiteralRemapping remapping = null;
            if (RuntimeShadedJarCreator.CLASS_DESC.equals(desc) && (remapping = this.remapper.maybeRemap(name)) != null) {
                this.remappedClassLiterals.put(remapping.getLiteral(), remapping.getLiteralReplacement().replace("/", "."));
            }
            return super.visitField(access, remapping != null ? remapping.getFieldNameReplacement() : name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodVisitor(327680, super.visitMethod(access, name, desc, signature, exceptions)){

                public void visitLdcInsn(Object cst) {
                    if (cst instanceof String) {
                        String literal = ShadingClassRemapper.this.remappedClassLiterals.get(cst);
                        if (literal == null) {
                            literal = ShadingClassRemapper.this.remapper.maybeRelocateResource((String)cst);
                        }
                        if (literal == null && (literal = ShadingClassRemapper.this.remapper.maybeRelocateResource(((String)cst).replace('.', '/'))) != null) {
                            literal = literal.replace("/", ".");
                        }
                        super.visitLdcInsn(literal != null ? literal : cst);
                    } else {
                        super.visitLdcInsn(cst);
                    }
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    ImplementationDependencyRelocator.ClassLiteralRemapping remapping;
                    if ((opcode == 178 || opcode == 179) && RuntimeShadedJarCreator.CLASS_DESC.equals(desc) && (remapping = ShadingClassRemapper.this.remapper.maybeRemap(name)) != null) {
                        super.visitFieldInsn(opcode, owner, remapping.getFieldNameReplacement(), desc);
                        return;
                    }
                    super.visitFieldInsn(opcode, owner, name, desc);
                }
            };
        }
    }
}

