/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Hashtable;
import javajs.awt.Font;
import javajs.util.A4;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.export.___Exporter;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.util.C;

public abstract class __CartesianExporter
extends ___Exporter {
    protected A4 viewpoint = new A4();
    protected P3 ptScaled = new P3();
    protected M4 sphereMatrix = new M4();

    public __CartesianExporter() {
        this.exportType = 1;
        this.lineWidthMad = (short)100;
    }

    protected P3 getModelCenter() {
        return this.referenceCenter;
    }

    protected P3 getCameraPosition() {
        P3 ptCamera = new P3();
        P3 pt = P3.new3(this.screenWidth / 2, this.screenHeight / 2, 0.0f);
        this.tm.unTransformPoint(pt, ptCamera);
        ptCamera.sub(this.center);
        this.tempP3.set(this.screenWidth / 2, this.screenHeight / 2, this.cameraDistance * this.scalePixelsPerAngstrom);
        this.tm.unTransformPoint(this.tempP3, this.tempP3);
        this.tempP3.sub(this.center);
        ptCamera.add(this.tempP3);
        return this.cameraPosition;
    }

    private void setTempPoints(P3 ptA, P3 ptB, boolean isCartesian) {
        if (isCartesian) {
            this.tempP1.setT(ptA);
            this.tempP2.setT(ptB);
        } else {
            this.tm.unTransformPoint(ptA, this.tempP1);
            this.tm.unTransformPoint(ptB, this.tempP2);
        }
    }

    protected float scale(float f) {
        return f * this.exportScale;
    }

    protected T3 scalePt(T3 pt) {
        if (this.exportScale == 1.0f) {
            return pt;
        }
        this.ptScaled.setT(pt);
        this.ptScaled.scale(this.exportScale);
        return this.ptScaled;
    }

    protected int getCoordinateMap(T3[] vertices, int[] coordMap, BS bsValid) {
        int n = 0;
        for (int i = 0; i < coordMap.length; ++i) {
            if (bsValid != null && !bsValid.get(i) || Float.isNaN(vertices[i].x)) {
                if (bsValid == null) continue;
                bsValid.clear(i);
                continue;
            }
            coordMap[i] = n++;
        }
        return n;
    }

    protected int[] getNormalMap(T3[] normals, int nNormals, BS bsValid, Lst<String> vNormals) {
        Hashtable<String, Integer> htNormals = new Hashtable<String, Integer>();
        int[] normalMap = new int[nNormals];
        for (int i = 0; i < nNormals; ++i) {
            if (bsValid != null && !bsValid.get(i) || Float.isNaN(normals[i].x)) {
                if (bsValid == null) continue;
                bsValid.clear(i);
                continue;
            }
            String s = this.getTriad(normals[i]) + "\n";
            if (htNormals.containsKey(s)) {
                normalMap[i] = (Integer)htNormals.get(s);
                continue;
            }
            normalMap[i] = vNormals.size();
            vNormals.addLast(s);
            htNormals.put(s, normalMap[i]);
        }
        return normalMap;
    }

    protected void outputIndices(int[][] indices, int[] map, int nPolygons, BS bsPolygons, int faceVertexMax) {
        int i0;
        boolean isAll = bsPolygons == null;
        int i = i0 = isAll ? nPolygons - 1 : bsPolygons.nextSetBit(0);
        while (i >= 0) {
            this.outputFace(indices[i], map, faceVertexMax);
            i = isAll ? i - 1 : bsPolygons.nextSetBit(i + 1);
        }
    }

    protected abstract void outputFace(int[] var1, int[] var2, int var3);

    protected abstract void outputCircle(P3 var1, P3 var2, float var3, short var4, boolean var5);

    protected abstract void outputCone(P3 var1, P3 var2, float var3, short var4);

    protected abstract boolean outputCylinder(P3 var1, P3 var2, P3 var3, short var4, byte var5, float var6, P3 var7, P3 var8, boolean var9);

    protected abstract void outputEllipsoid(P3 var1, P3[] var2, short var3);

    protected abstract void outputSphere(P3 var1, float var2, short var3, boolean var4);

    protected abstract void outputTextPixel(P3 var1, int var2);

    protected abstract void outputTriangle(T3 var1, T3 var2, T3 var3, short var4);

    @Override
    void plotText(int x, int y, int z, short colix, String text, Font font3d) {
        this.gdata.plotText(x, y, z, this.gdata.getColorArgbOrGray(colix), 0, text, font3d, this.export3D);
    }

    @Override
    void plotImage(int x, int y, int z, Object image, short bgcolix, int width, int height) {
    }

    @Override
    void drawAtom(Atom atom) {
        short colix = atom.colixAtom;
        this.outputSphere(atom, (float)atom.madAtom / 2000.0f, colix, C.isColixTranslucent(colix));
    }

    @Override
    void drawCircle(int x, int y, int z, int diameter, short colix, boolean doFill) {
        this.tempP3.set(x, y, z);
        this.tm.unTransformPoint(this.tempP3, this.tempP1);
        float radius = this.vwr.tm.unscaleToScreen(z, diameter) / 2.0f;
        this.tempP3.set(x, y, z + 1);
        this.tm.unTransformPoint(this.tempP3, this.tempP3);
        this.outputCircle(this.tempP1, this.tempP3, radius, colix, doFill);
    }

    @Override
    boolean drawEllipse(P3 ptCenter, P3 ptX, P3 ptY, short colix, boolean doFill) {
        this.tempV1.sub2(ptX, ptCenter);
        this.tempV2.sub2(ptY, ptCenter);
        this.tempV2.cross(this.tempV1, this.tempV2);
        this.tempV2.normalize();
        this.tempV2.scale(doFill ? 0.002f : 0.005f);
        this.tempP1.sub2(ptCenter, this.tempV2);
        this.tempP2.add2(ptCenter, this.tempV2);
        return this.outputCylinder(ptCenter, this.tempP1, this.tempP2, colix, doFill ? (byte)2 : 0, 1.01f, ptX, ptY, true);
    }

    @Override
    void drawPixel(short colix, int x, int y, int z, int scale) {
        this.tempP3.set(x, y, z);
        this.tm.unTransformPoint(this.tempP3, this.tempP1);
        this.outputSphere(this.tempP1, 0.02f * (float)scale, colix, true);
    }

    @Override
    void drawTextPixel(int argb, int x, int y, int z) {
        this.tempP3.set(x, y, z);
        this.tm.unTransformPoint(this.tempP3, this.tempP1);
        this.outputTextPixel(this.tempP1, argb);
    }

    @Override
    void fillConeScreen(short colix, byte endcap, int screenDiameter, P3 screenBase, P3 screenTip, boolean isBarb) {
        this.tm.unTransformPoint(screenBase, this.tempP1);
        this.tm.unTransformPoint(screenTip, this.tempP2);
        float radius = this.vwr.tm.unscaleToScreen(screenBase.z, screenDiameter) / 2.0f;
        if (radius < 0.05f) {
            radius = 0.05f;
        }
        this.outputCone(this.tempP1, this.tempP2, radius, colix);
    }

    @Override
    void drawCylinder(P3 ptA, P3 ptB, short colix1, short colix2, byte endcaps, int mad, int bondOrder) {
        this.setTempPoints(ptA, ptB, bondOrder < 0);
        float radius = (float)mad / 2000.0f;
        if (colix1 == colix2) {
            this.outputCylinder(null, this.tempP1, this.tempP2, colix1, endcaps, radius, null, null, bondOrder != -1);
        } else {
            this.tempV2.ave(this.tempP2, this.tempP1);
            this.tempP3.setT(this.tempV2);
            this.outputCylinder(null, this.tempP1, this.tempP3, colix1, endcaps == 3 ? (byte)0 : endcaps, radius, null, null, true);
            this.outputCylinder(null, this.tempP3, this.tempP2, colix2, endcaps == 3 ? (byte)0 : endcaps, radius, null, null, true);
            if (endcaps == 3) {
                this.outputSphere(this.tempP1, radius * 1.01f, colix1, bondOrder != -2);
                this.outputSphere(this.tempP2, radius * 1.01f, colix2, bondOrder != -2);
            }
        }
    }

    @Override
    void fillCylinderScreenMad(short colix, byte endcaps, int mad, P3 screenA, P3 screenB) {
        float radius = (float)mad / 2000.0f;
        this.setTempPoints(screenA, screenB, false);
        this.outputCylinder(null, this.tempP1, this.tempP2, colix, endcaps, radius, null, null, true);
    }

    @Override
    void fillCylinderScreen(short colix, byte endcaps, int screenDiameter, P3 screenA, P3 screenB, P3 ptA, P3 ptB, float radius) {
        if (ptA != null) {
            this.drawCylinder(ptA, ptB, colix, colix, endcaps, Math.round(radius * 2000.0f), -1);
            return;
        }
        int mad = Math.round(this.vwr.tm.unscaleToScreen((screenA.z + screenB.z) / 2.0f, screenDiameter) * 1000.0f);
        this.fillCylinderScreenMad(colix, endcaps, mad, screenA, screenB);
    }

    @Override
    void fillEllipsoid(P3 center, P3[] points, short colix, int x, int y, int z, int diameter, M3 toEllipsoidal, double[] coef, M4 deriv, P3[] octantPoints) {
        this.outputEllipsoid(center, points, colix);
    }

    @Override
    void fillSphere(short colix, int diameter, P3 pt) {
        this.tm.unTransformPoint(pt, this.tempP1);
        this.outputSphere(this.tempP1, this.vwr.tm.unscaleToScreen(pt.z, diameter) / 2.0f, colix, true);
    }

    @Override
    protected void fillTriangle(short colix, T3 ptA, T3 ptB, T3 ptC, boolean twoSided) {
        this.tm.unTransformPoint(ptA, this.tempP1);
        this.tm.unTransformPoint(ptB, this.tempP2);
        this.tm.unTransformPoint(ptC, this.tempP3);
        this.outputTriangle(this.tempP1, this.tempP2, this.tempP3, colix);
        if (twoSided) {
            this.outputTriangle(this.tempP1, this.tempP3, this.tempP2, colix);
        }
    }

    protected void setSphereMatrix(T3 center, float rx, float ry, float rz, A4 a, M4 sphereMatrix) {
        if (a != null) {
            M3 m = new M3();
            m.m00 = rx;
            m.m11 = ry;
            m.m22 = rz;
            M3 mq = new M3().setAA(a);
            mq.mul(m);
            sphereMatrix.setToM3(mq);
        } else {
            sphereMatrix.setIdentity();
            sphereMatrix.m00 = rx;
            sphereMatrix.m11 = ry;
            sphereMatrix.m22 = rz;
        }
        sphereMatrix.m03 = center.x;
        sphereMatrix.m13 = center.y;
        sphereMatrix.m23 = center.z;
        sphereMatrix.m33 = 1.0f;
    }
}

