/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.db;

import java.sql.Connection;
import org.json.JSONObject;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.db.CouchDBHandler;
import org.owasp.jbrofuzz.db.CouchDBMapper;
import org.owasp.jbrofuzz.db.SQLiteHandler;
import org.owasp.jbrofuzz.fuzz.MessageContainer;
import org.owasp.jbrofuzz.graph.GraphingPanel;
import org.owasp.jbrofuzz.graph.utils.DBWalker;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

public class DBAdaptor {
    private Object dbHandler;

    public DBAdaptor(Object dbHandler) {
        this.dbHandler = dbHandler;
    }

    public int store(MessageContainer outputMessage) {
        String dbName = JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[12].getId(), "");
        int returnCode = 0;
        if (this.dbHandler.getClass().getName().equals(CouchDBHandler.class)) {
            Logger.log("Storing to CouchDB", 0);
            CouchDBMapper couchMapper = new CouchDBMapper();
            JSONObject document = couchMapper.toCouch2(outputMessage);
            returnCode = ((CouchDBHandler)this.dbHandler).store(dbName, "", document);
        } else {
            SQLiteHandler sqlH = (SQLiteHandler)this.dbHandler;
            try {
                Connection conn = sqlH.getConnection(dbName);
                if (conn == null) {
                    Logger.log("Connection = null", 0);
                }
                returnCode = sqlH.store(outputMessage, conn);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return returnCode;
    }

    public MessageContainer read(String fileName, String sessionId, JBroFuzzWindow mWindow) {
        MessageContainer mc = new MessageContainer(mWindow.getPanelFuzzing());
        if (this.dbHandler.getClass().getName().equals(CouchDBHandler.class)) {
            Logger.log("TODO: reading from CouchDB", 0);
        } else {
            SQLiteHandler sqlH = (SQLiteHandler)this.dbHandler;
            Connection conn = sqlH.getConnection(fileName);
            mc = sqlH.read(conn, Long.valueOf(sessionId), mWindow.getPanelFuzzing());
        }
        return mc;
    }

    public String[] executeQuery(String sql) {
        if (!this.dbHandler.getClass().getName().equals(CouchDBHandler.class)) {
            SQLiteHandler sqlH = (SQLiteHandler)this.dbHandler;
            Connection conn = sqlH.getConnection(JBroFuzz.PREFS.get(JBroFuzzPrefs.DBSETTINGS[12].getId(), ""));
            return sqlH.executeQuery(conn, sql);
        }
        Logger.log("TODO: reading form CouchDB", 3);
        return null;
    }

    public DBWalker getWalker(GraphingPanel gPanel) {
        return new DBWalker(gPanel);
    }
}

