/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.TransportNodesListGatewayStartedShards;

public abstract class PrimaryShardAllocator
extends AbstractComponent {
    private static final Function<String, String> INITIAL_SHARDS_PARSER = value -> {
        switch (value) {
            case "quorum": 
            case "quorum-1": 
            case "half": 
            case "one": 
            case "full": 
            case "full-1": 
            case "all-1": 
            case "all": {
                return value;
            }
        }
        Integer.parseInt(value);
        return value;
    };
    public static final Setting<String> NODE_INITIAL_SHARDS_SETTING = new Setting<String>("gateway.initial_shards", settings -> settings.get("gateway.local.initial_shards", "quorum"), INITIAL_SHARDS_PARSER, Setting.Property.Dynamic, Setting.Property.NodeScope);
    @Deprecated
    public static final Setting<String> INDEX_RECOVERY_INITIAL_SHARDS_SETTING = new Setting<String>("index.recovery.initial_shards", settings -> NODE_INITIAL_SHARDS_SETTING.get((Settings)settings), INITIAL_SHARDS_PARSER, Setting.Property.Dynamic, Setting.Property.IndexScope);

    public PrimaryShardAllocator(Settings settings) {
        super(settings);
        this.logger.debug("using initial_shards [{}]", (Object)NODE_INITIAL_SHARDS_SETTING.get(settings));
    }

    public void allocateUnassigned(RoutingAllocation allocation) {
        RoutingNodes routingNodes = allocation.routingNodes();
        MetaData metaData = allocation.metaData();
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            boolean enoughAllocationsFound;
            NodeShardsResult nodeShardsResult;
            ShardRouting shard = unassignedIterator.next();
            if (!shard.primary() || shard.recoverySource().getType() != RecoverySource.Type.EXISTING_STORE && shard.recoverySource().getType() != RecoverySource.Type.SNAPSHOT) continue;
            AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> shardState = this.fetchData(shard, allocation);
            if (!shardState.hasData()) {
                this.logger.trace("{}: ignoring allocation, still fetching shard started state", (Object)shard);
                allocation.setHasPendingAsyncFetch();
                unassignedIterator.removeAndIgnore(UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, allocation.changes());
                continue;
            }
            IndexMetaData indexMetaData = metaData.getIndexSafe(shard.index());
            Set<String> inSyncAllocationIds = indexMetaData.inSyncAllocationIds(shard.id());
            boolean snapshotRestore = shard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT;
            boolean recoverOnAnyNode = this.recoverOnAnyNode(indexMetaData);
            if (inSyncAllocationIds.isEmpty()) {
                assert (Version.indexCreated(indexMetaData.getSettings()).before(Version.V_5_0_0_alpha1)) : "trying to allocate a primary with an empty in sync allocation id set, but index is new";
                nodeShardsResult = this.buildVersionBasedNodeShardsResult(shard, snapshotRestore || recoverOnAnyNode, allocation.getIgnoreNodes(shard.shardId()), shardState);
                enoughAllocationsFound = snapshotRestore || recoverOnAnyNode ? nodeShardsResult.allocationsFound > 0 : this.isEnoughVersionBasedAllocationsFound(indexMetaData, nodeShardsResult);
                this.logger.debug("[{}][{}]: version-based allocation for pre-{} index found {} allocations of {}", (Object)shard.index(), (Object)shard.id(), (Object)Version.V_5_0_0_alpha1, (Object)nodeShardsResult.allocationsFound, (Object)shard);
            } else {
                assert (!inSyncAllocationIds.isEmpty());
                nodeShardsResult = this.buildAllocationIdBasedNodeShardsResult(shard, snapshotRestore || recoverOnAnyNode, allocation.getIgnoreNodes(shard.shardId()), inSyncAllocationIds, shardState);
                enoughAllocationsFound = nodeShardsResult.orderedAllocationCandidates.size() > 0;
                this.logger.debug("[{}][{}]: found {} allocation candidates of {} based on allocation ids: [{}]", (Object)shard.index(), (Object)shard.id(), (Object)nodeShardsResult.orderedAllocationCandidates.size(), (Object)shard, inSyncAllocationIds);
            }
            if (!enoughAllocationsFound) {
                if (snapshotRestore) {
                    this.logger.debug("[{}][{}]: missing local data, will restore from [{}]", (Object)shard.index(), (Object)shard.id(), (Object)shard.recoverySource());
                    continue;
                }
                if (recoverOnAnyNode) {
                    this.logger.debug("[{}][{}]: missing local data, recover from any node", (Object)shard.index(), (Object)shard.id());
                    continue;
                }
                unassignedIterator.removeAndIgnore(UnassignedInfo.AllocationStatus.NO_VALID_SHARD_COPY, allocation.changes());
                this.logger.debug("[{}][{}]: not allocating, number_of_allocated_shards_found [{}]", (Object)shard.index(), (Object)shard.id(), (Object)nodeShardsResult.allocationsFound);
                continue;
            }
            NodesToAllocate nodesToAllocate = this.buildNodesToAllocate(allocation, nodeShardsResult.orderedAllocationCandidates, shard, false);
            if (!nodesToAllocate.yesNodeShards.isEmpty()) {
                TransportNodesListGatewayStartedShards.NodeGatewayStartedShards nodeShardState = nodesToAllocate.yesNodeShards.get(0);
                this.logger.debug("[{}][{}]: allocating [{}] to [{}] on primary allocation", (Object)shard.index(), (Object)shard.id(), (Object)shard, (Object)nodeShardState.getNode());
                unassignedIterator.initialize(nodeShardState.getNode().getId(), nodeShardState.allocationId(), -1L, allocation.changes());
                continue;
            }
            if (nodesToAllocate.throttleNodeShards.isEmpty() && !nodesToAllocate.noNodeShards.isEmpty()) {
                NodesToAllocate nodesToForceAllocate = this.buildNodesToAllocate(allocation, nodeShardsResult.orderedAllocationCandidates, shard, true);
                if (!nodesToForceAllocate.yesNodeShards.isEmpty()) {
                    TransportNodesListGatewayStartedShards.NodeGatewayStartedShards nodeShardState = nodesToForceAllocate.yesNodeShards.get(0);
                    this.logger.debug("[{}][{}]: allocating [{}] to [{}] on forced primary allocation", (Object)shard.index(), (Object)shard.id(), (Object)shard, (Object)nodeShardState.getNode());
                    unassignedIterator.initialize(nodeShardState.getNode().getId(), nodeShardState.allocationId(), -1L, allocation.changes());
                    continue;
                }
                if (!nodesToForceAllocate.throttleNodeShards.isEmpty()) {
                    this.logger.debug("[{}][{}]: throttling allocation [{}] to [{}] on forced primary allocation", (Object)shard.index(), (Object)shard.id(), (Object)shard, nodesToForceAllocate.throttleNodeShards);
                    unassignedIterator.removeAndIgnore(UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED, allocation.changes());
                    continue;
                }
                this.logger.debug("[{}][{}]: forced primary allocation denied [{}]", (Object)shard.index(), (Object)shard.id(), (Object)shard);
                unassignedIterator.removeAndIgnore(UnassignedInfo.AllocationStatus.DECIDERS_NO, allocation.changes());
                continue;
            }
            this.logger.debug("[{}][{}]: throttling allocation [{}] to [{}] on primary allocation", (Object)shard.index(), (Object)shard.id(), (Object)shard, nodesToAllocate.throttleNodeShards);
            unassignedIterator.removeAndIgnore(UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED, allocation.changes());
        }
    }

    protected NodeShardsResult buildAllocationIdBasedNodeShardsResult(ShardRouting shard, boolean matchAnyShard, Set<String> ignoreNodes, Set<String> inSyncAllocationIds, AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> shardState) {
        LinkedList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> matchingNodeShardStates = new LinkedList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>();
        LinkedList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> nonMatchingNodeShardStates = new LinkedList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>();
        int numberOfAllocationsFound = 0;
        for (TransportNodesListGatewayStartedShards.NodeGatewayStartedShards nodeShardState : shardState.getData().values()) {
            DiscoveryNode node = nodeShardState.getNode();
            String allocationId = nodeShardState.allocationId();
            if (ignoreNodes.contains(node.getId())) continue;
            if (nodeShardState.storeException() == null) {
                if (allocationId == null && nodeShardState.legacyVersion() == -1L) {
                    this.logger.trace("[{}] on node [{}] has no shard state information", (Object)shard, (Object)nodeShardState.getNode());
                } else if (allocationId != null) {
                    assert (nodeShardState.legacyVersion() == -1L) : "Allocation id and legacy version cannot be both present";
                    this.logger.trace("[{}] on node [{}] has allocation id [{}]", (Object)shard, (Object)nodeShardState.getNode(), (Object)allocationId);
                } else {
                    this.logger.trace("[{}] on node [{}] has no allocation id, out-dated shard (shard state version: [{}])", (Object)shard, (Object)nodeShardState.getNode(), (Object)nodeShardState.legacyVersion());
                }
            } else {
                String finalAllocationId = allocationId;
                this.logger.trace(() -> new ParameterizedMessage("[{}] on node [{}] has allocation id [{}] but the store can not be opened, treating as no allocation id", new Object[]{shard, nodeShardState.getNode(), finalAllocationId}), (Throwable)nodeShardState.storeException());
                allocationId = null;
            }
            if (allocationId == null) continue;
            ++numberOfAllocationsFound;
            if (inSyncAllocationIds.contains(allocationId)) {
                if (nodeShardState.primary()) {
                    matchingNodeShardStates.addFirst(nodeShardState);
                    continue;
                }
                matchingNodeShardStates.addLast(nodeShardState);
                continue;
            }
            if (!matchAnyShard) continue;
            if (nodeShardState.primary()) {
                nonMatchingNodeShardStates.addFirst(nodeShardState);
                continue;
            }
            nonMatchingNodeShardStates.addLast(nodeShardState);
        }
        ArrayList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> nodeShardStates = new ArrayList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>();
        nodeShardStates.addAll(matchingNodeShardStates);
        nodeShardStates.addAll(nonMatchingNodeShardStates);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("{} candidates for allocation: {}", (Object)shard, (Object)nodeShardStates.stream().map(s -> s.getNode().getName()).collect(Collectors.joining(", ")));
        }
        return new NodeShardsResult(nodeShardStates, numberOfAllocationsFound);
    }

    private boolean isEnoughVersionBasedAllocationsFound(IndexMetaData indexMetaData, NodeShardsResult nodeShardsResult) {
        int requiredAllocation = 1;
        String initialShards = INDEX_RECOVERY_INITIAL_SHARDS_SETTING.get(indexMetaData.getSettings(), this.settings);
        if ("quorum".equals(initialShards)) {
            if (indexMetaData.getNumberOfReplicas() > 1) {
                requiredAllocation = (1 + indexMetaData.getNumberOfReplicas()) / 2 + 1;
            }
        } else if ("quorum-1".equals(initialShards) || "half".equals(initialShards)) {
            if (indexMetaData.getNumberOfReplicas() > 2) {
                requiredAllocation = (1 + indexMetaData.getNumberOfReplicas()) / 2;
            }
        } else if ("one".equals(initialShards)) {
            requiredAllocation = 1;
        } else if ("full".equals(initialShards) || "all".equals(initialShards)) {
            requiredAllocation = indexMetaData.getNumberOfReplicas() + 1;
        } else if ("full-1".equals(initialShards) || "all-1".equals(initialShards)) {
            if (indexMetaData.getNumberOfReplicas() > 1) {
                requiredAllocation = indexMetaData.getNumberOfReplicas();
            }
        } else {
            requiredAllocation = Integer.parseInt(initialShards);
        }
        return nodeShardsResult.allocationsFound >= requiredAllocation;
    }

    private NodesToAllocate buildNodesToAllocate(RoutingAllocation allocation, List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> nodeShardStates, ShardRouting shardRouting, boolean forceAllocate) {
        ArrayList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> yesNodeShards = new ArrayList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>();
        ArrayList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> throttledNodeShards = new ArrayList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>();
        ArrayList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> noNodeShards = new ArrayList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>();
        for (TransportNodesListGatewayStartedShards.NodeGatewayStartedShards nodeShardState : nodeShardStates) {
            Decision decision;
            RoutingNode node = allocation.routingNodes().node(nodeShardState.getNode().getId());
            if (node == null) continue;
            Decision decision2 = decision = forceAllocate ? allocation.deciders().canForceAllocatePrimary(shardRouting, node, allocation) : allocation.deciders().canAllocate(shardRouting, node, allocation);
            if (decision.type() == Decision.Type.THROTTLE) {
                throttledNodeShards.add(nodeShardState);
                continue;
            }
            if (decision.type() == Decision.Type.NO) {
                noNodeShards.add(nodeShardState);
                continue;
            }
            yesNodeShards.add(nodeShardState);
        }
        return new NodesToAllocate(Collections.unmodifiableList(yesNodeShards), Collections.unmodifiableList(throttledNodeShards), Collections.unmodifiableList(noNodeShards));
    }

    NodeShardsResult buildVersionBasedNodeShardsResult(ShardRouting shard, boolean matchAnyShard, Set<String> ignoreNodes, AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> shardState) {
        ArrayList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> allocationCandidates = new ArrayList<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>();
        int numberOfAllocationsFound = 0;
        long highestVersion = -1L;
        for (TransportNodesListGatewayStartedShards.NodeGatewayStartedShards nodeShardState : shardState.getData().values()) {
            long version = nodeShardState.legacyVersion();
            DiscoveryNode node = nodeShardState.getNode();
            if (ignoreNodes.contains(node.getId())) continue;
            if (nodeShardState.storeException() == null) {
                if (version == -1L && nodeShardState.allocationId() == null) {
                    this.logger.trace("[{}] on node [{}] has no shard state information", (Object)shard, (Object)nodeShardState.getNode());
                } else if (version != -1L) {
                    assert (nodeShardState.allocationId() == null) : "Allocation id and legacy version cannot be both present";
                    this.logger.trace("[{}] on node [{}] has version [{}] of shard", (Object)shard, (Object)nodeShardState.getNode(), (Object)version);
                } else {
                    version = Long.MAX_VALUE;
                    this.logger.trace("[{}] on node [{}] has allocation id [{}]", (Object)shard, (Object)nodeShardState.getNode(), (Object)nodeShardState.allocationId());
                }
            } else {
                long finalVerison = version;
                this.logger.trace(() -> new ParameterizedMessage("[{}] on node [{}] has version [{}] but the store can not be opened, treating no version", new Object[]{shard, nodeShardState.getNode(), finalVerison}), (Throwable)nodeShardState.storeException());
                version = -1L;
            }
            if (version == -1L) continue;
            ++numberOfAllocationsFound;
            if (version > highestVersion) {
                highestVersion = version;
                if (!matchAnyShard) {
                    allocationCandidates.clear();
                }
                allocationCandidates.add(nodeShardState);
                continue;
            }
            if (version != highestVersion) continue;
            allocationCandidates.add(nodeShardState);
        }
        CollectionUtil.timSort(allocationCandidates, Comparator.comparing(TransportNodesListGatewayStartedShards.NodeGatewayStartedShards::legacyVersion).reversed());
        if (this.logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("[");
            for (TransportNodesListGatewayStartedShards.NodeGatewayStartedShards n : allocationCandidates) {
                sb.append("[").append(n.getNode().getName()).append("]").append(" -> ").append(n.legacyVersion()).append(", ");
            }
            sb.append("]");
            this.logger.trace("{} candidates for allocation: {}", (Object)shard, (Object)sb.toString());
        }
        return new NodeShardsResult(Collections.unmodifiableList(allocationCandidates), numberOfAllocationsFound);
    }

    private boolean recoverOnAnyNode(IndexMetaData metaData) {
        return (IndexMetaData.isOnSharedFilesystem(metaData.getSettings()) || IndexMetaData.isOnSharedFilesystem(this.settings)) && IndexMetaData.INDEX_SHARED_FS_ALLOW_RECOVERY_ON_ANY_NODE_SETTING.get(metaData.getSettings(), this.settings) != false;
    }

    protected abstract AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> fetchData(ShardRouting var1, RoutingAllocation var2);

    static class NodesToAllocate {
        final List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> yesNodeShards;
        final List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> throttleNodeShards;
        final List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> noNodeShards;

        public NodesToAllocate(List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> yesNodeShards, List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> throttleNodeShards, List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> noNodeShards) {
            this.yesNodeShards = yesNodeShards;
            this.throttleNodeShards = throttleNodeShards;
            this.noNodeShards = noNodeShards;
        }
    }

    static class NodeShardsResult {
        public final List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> orderedAllocationCandidates;
        public final int allocationsFound;

        public NodeShardsResult(List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> orderedAllocationCandidates, int allocationsFound) {
            this.orderedAllocationCandidates = orderedAllocationCandidates;
            this.allocationsFound = allocationsFound;
        }
    }
}

