/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestGetMappingAction
extends BaseRestHandler {
    @Inject
    public RestGetMappingAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mapping", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mappings/{type}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping/{type}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_mapping/{type}", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        final String[] types = request.paramAsStringArrayOrEmptyIfAll("type");
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        ((GetMappingsRequest)getMappingsRequest.indices(indices)).types(types);
        getMappingsRequest.indicesOptions(IndicesOptions.fromRequest(request, getMappingsRequest.indicesOptions()));
        getMappingsRequest.local(request.paramAsBoolean("local", getMappingsRequest.local()));
        return channel -> client.admin().indices().getMappings(getMappingsRequest, (ActionListener<GetMappingsResponse>)new RestBuilderListener<GetMappingsResponse>(channel){

            @Override
            public RestResponse buildResponse(GetMappingsResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappingsByIndex = response.getMappings();
                if (mappingsByIndex.isEmpty()) {
                    if (indices.length != 0 && types.length != 0) {
                        return new BytesRestResponse(RestStatus.OK, builder.endObject());
                    }
                    if (indices.length != 0) {
                        return new BytesRestResponse(this.channel, new IndexNotFoundException(indices[0]));
                    }
                    if (types.length != 0) {
                        return new BytesRestResponse(this.channel, new TypeMissingException("_all", types[0]));
                    }
                    return new BytesRestResponse(RestStatus.OK, builder.endObject());
                }
                for (ObjectObjectCursor<String, ImmutableOpenMap<String, MappingMetaData>> objectObjectCursor : mappingsByIndex) {
                    if (((ImmutableOpenMap)objectObjectCursor.value).isEmpty()) continue;
                    builder.startObject((String)objectObjectCursor.key);
                    builder.startObject("mappings");
                    for (ObjectObjectCursor typeEntry : (ImmutableOpenMap)objectObjectCursor.value) {
                        builder.field((String)typeEntry.key);
                        builder.map(((MappingMetaData)typeEntry.value).sourceAsMap());
                    }
                    builder.endObject();
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    static class Fields {
        static final String MAPPINGS = "mappings";

        Fields() {
        }
    }
}

