/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoGridAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridParams;
import org.elasticsearch.search.aggregations.support.AbstractValuesSourceParser;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.aggregations.support.XContentParseContext;

public class GeoHashGridParser
extends AbstractValuesSourceParser.GeoPointValuesSourceParser {
    public static final int DEFAULT_PRECISION = 5;
    public static final int DEFAULT_MAX_NUM_CELLS = 10000;

    public GeoHashGridParser() {
        super(false, false);
    }

    protected GeoGridAggregationBuilder createFactory(String aggregationName, ValuesSourceType valuesSourceType, ValueType targetValueType, Map<ParseField, Object> otherOptions) {
        Integer shardSize;
        Integer size;
        GeoGridAggregationBuilder factory = new GeoGridAggregationBuilder(aggregationName);
        Integer precision = (Integer)otherOptions.get(GeoHashGridParams.FIELD_PRECISION);
        if (precision != null) {
            factory.precision(precision);
        }
        if ((size = (Integer)otherOptions.get(GeoHashGridParams.FIELD_SIZE)) != null) {
            factory.size(size);
        }
        if ((shardSize = (Integer)otherOptions.get(GeoHashGridParams.FIELD_SHARD_SIZE)) != null) {
            factory.shardSize(shardSize);
        }
        return factory;
    }

    @Override
    protected boolean token(String aggregationName, String currentFieldName, XContentParser.Token token, XContentParseContext context, Map<ParseField, Object> otherOptions) throws IOException {
        XContentParser parser = context.getParser();
        if (token == XContentParser.Token.VALUE_NUMBER || token == XContentParser.Token.VALUE_STRING) {
            if (context.matchField(currentFieldName, GeoHashGridParams.FIELD_PRECISION)) {
                otherOptions.put(GeoHashGridParams.FIELD_PRECISION, parser.intValue());
                return true;
            }
            if (context.matchField(currentFieldName, GeoHashGridParams.FIELD_SIZE)) {
                otherOptions.put(GeoHashGridParams.FIELD_SIZE, parser.intValue());
                return true;
            }
            if (context.matchField(currentFieldName, GeoHashGridParams.FIELD_SHARD_SIZE)) {
                otherOptions.put(GeoHashGridParams.FIELD_SHARD_SIZE, parser.intValue());
                return true;
            }
        }
        return false;
    }
}

