/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mortbay.jetty.plus.annotation.LifeCycleCallback;
import org.mortbay.log.Log;

public class PreDestroyCallback
extends LifeCycleCallback {
    public void validate(Class clazz, Method method) {
        if (method.getExceptionTypes().length > 0) {
            throw new IllegalArgumentException(clazz.getName() + "." + method.getName() + " cannot not throw a checked exception");
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new IllegalArgumentException(clazz.getName() + "." + method.getName() + " cannot not have a return type");
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException(clazz.getName() + "." + method.getName() + " cannot be static");
        }
    }

    public void callback(Object instance) {
        try {
            super.callback(instance);
        }
        catch (Exception e) {
            Log.warn((String)("Ignoring exception thrown on preDestroy call to " + this.getTargetClass() + "." + this.getTarget().getName()), (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        return super.equals(o) && o instanceof PreDestroyCallback;
    }
}

