/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.hub;

import org.gradle.api.Action;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ThreadSafe;
import org.gradle.internal.dispatch.BoundedDispatch;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.dispatch.ProxyDispatchAdapter;
import org.gradle.internal.dispatch.ReflectionDispatch;
import org.gradle.internal.dispatch.StreamCompletion;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.internal.remote.internal.ConnectCompletion;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.internal.remote.internal.hub.DefaultMethodArgsSerializer;
import org.gradle.internal.remote.internal.hub.InterHubMessageSerializer;
import org.gradle.internal.remote.internal.hub.JavaSerializationBackedMethodArgsSerializer;
import org.gradle.internal.remote.internal.hub.MessageHub;
import org.gradle.internal.remote.internal.hub.MethodArgsSerializer;
import org.gradle.internal.remote.internal.hub.MethodInvocationSerializer;
import org.gradle.internal.remote.internal.hub.protocol.InterHubMessage;
import org.gradle.internal.serialize.SerializerRegistry;
import org.gradle.internal.serialize.kryo.TypeSafeSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHubBackedObjectConnection
implements ObjectConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageHubBackedObjectConnection.class);
    private final MessageHub hub;
    private ConnectCompletion completion;
    private RemoteConnection<InterHubMessage> connection;
    private ClassLoader methodParamClassLoader;
    private SerializerRegistry paramSerializers;

    public MessageHubBackedObjectConnection(ExecutorFactory executorFactory, ConnectCompletion completion) {
        this.hub = new MessageHub(completion.toString(), executorFactory, (Action<? super Throwable>)new Action<Throwable>(){

            public void execute(Throwable throwable) {
                LOGGER.error("Unexpected exception thrown.", throwable);
            }
        });
        this.completion = completion;
    }

    @Override
    public void useJavaSerializationForParameters(ClassLoader incomingMessageClassLoader) {
        this.methodParamClassLoader = incomingMessageClassLoader;
    }

    @Override
    public <T> void addIncoming(Class<T> type, T instance) {
        if (this.methodParamClassLoader == null) {
            this.methodParamClassLoader = type.getClassLoader();
        }
        Dispatch<MethodInvocation> handler = new ReflectionDispatch(instance);
        if (instance instanceof StreamCompletion) {
            handler = new BoundedDispatchWrapper((StreamCompletion)instance, handler);
        }
        this.hub.addHandler(type.getName(), handler);
    }

    @Override
    public <T> T addOutgoing(Class<T> type) {
        if (this.methodParamClassLoader == null) {
            this.methodParamClassLoader = type.getClassLoader();
        }
        ProxyDispatchAdapter<T> adapter = new ProxyDispatchAdapter<T>(this.hub.getOutgoing(type.getName(), MethodInvocation.class), type, ThreadSafe.class);
        return adapter.getSource();
    }

    @Override
    public void useParameterSerializers(SerializerRegistry serializer) {
        this.paramSerializers = serializer;
    }

    @Override
    public void connect() {
        if (this.methodParamClassLoader == null) {
            this.methodParamClassLoader = this.getClass().getClassLoader();
        }
        MethodArgsSerializer argsSerializer = this.paramSerializers != null ? new DefaultMethodArgsSerializer(this.paramSerializers) : new JavaSerializationBackedMethodArgsSerializer(this.methodParamClassLoader);
        InterHubMessageSerializer serializer = new InterHubMessageSerializer(new TypeSafeSerializer<MethodInvocation>(MethodInvocation.class, new MethodInvocationSerializer(this.methodParamClassLoader, argsSerializer)));
        this.connection = this.completion.create(serializer);
        this.hub.addConnection(this.connection);
        this.hub.noFurtherConnections();
        this.completion = null;
    }

    @Override
    public void requestStop() {
        this.hub.requestStop();
    }

    @Override
    public void stop() {
        CompositeStoppable.stoppable((Object[])new Object[]{this.hub, this.connection}).stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BoundedDispatchWrapper
    implements BoundedDispatch<MethodInvocation> {
        private final StreamCompletion instance;
        private final Dispatch<MethodInvocation> handler;

        BoundedDispatchWrapper(StreamCompletion instance, Dispatch<MethodInvocation> handler) {
            this.instance = instance;
            this.handler = handler;
        }

        @Override
        public void endStream() {
            this.instance.endStream();
        }

        @Override
        public void dispatch(MethodInvocation message) {
            this.handler.dispatch(message);
        }
    }
}

