/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl;

import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.ClsStubPsiFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.SourceStubPsiFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.StubPsiFactory;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;

public class PsiJavaFileStubImpl
extends PsiFileStubImpl<PsiJavaFile>
implements PsiJavaFileStub {
    private final StringRef myPackageName;
    private final boolean myCompiled;
    private StubPsiFactory myFactory;

    public PsiJavaFileStubImpl(PsiJavaFile file2, StringRef packageName, boolean compiled) {
        super(file2);
        this.myPackageName = packageName;
        this.myCompiled = compiled;
        this.myFactory = compiled ? new ClsStubPsiFactory() : new SourceStubPsiFactory();
    }

    public PsiJavaFileStubImpl(String packageName, boolean compiled) {
        this(null, StringRef.fromString(packageName), compiled);
    }

    @Override
    public IStubFileElementType getType() {
        return JavaStubElementTypes.JAVA_FILE;
    }

    @Override
    public PsiClass[] getClasses() {
        return (PsiClass[])this.getChildrenByType(JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
    }

    @Override
    public String getPackageName() {
        return StringRef.toString(this.myPackageName);
    }

    @Override
    public boolean isCompiled() {
        return this.myCompiled;
    }

    @Override
    public StubPsiFactory getPsiFactory() {
        return this.myFactory;
    }

    @Override
    public void setPsiFactory(StubPsiFactory factory) {
        this.myFactory = factory;
    }

    public void setPackageName(String packageName) {
        throw new IncorrectOperationException();
    }

    @Override
    public String toString() {
        return "PsiJavaFileStub [" + this.myPackageName + "]";
    }
}

