/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;

public class XSElementDecl {
    public static final short NO_CONSTRAINT = 0;
    public static final short DEFAULT_VALUE = 1;
    public static final short FIXED_VALUE = 2;
    public String fName = null;
    public String fTargetNamespace = null;
    public XSTypeDecl fType = null;
    short fMiscFlags = 0;
    public short fBlock = 0;
    public short fFinal = 0;
    public ValidatedInfo fDefault = null;
    public XSElementDecl fSubGroup = null;
    static final int INITIAL_SIZE = 2;
    int fIDCPos = 0;
    IdentityConstraint[] fIDConstraints = new IdentityConstraint[2];
    private static final short CONSTRAINT_MASK = 3;
    private static final short NILLABLE = 4;
    private static final short ABSTRACT = 8;
    private static final short GLOBAL = 16;
    private String fDescription = null;

    public short getConstraintType() {
        return (short)(this.fMiscFlags & 3);
    }

    public boolean isNillable() {
        return (this.fMiscFlags & 4) != 0;
    }

    public boolean isAbstract() {
        return (this.fMiscFlags & 8) != 0;
    }

    public boolean isGlobal() {
        return (this.fMiscFlags & 0x10) != 0;
    }

    public void setConstraintType(short s) {
        this.fMiscFlags = (short)(this.fMiscFlags ^ this.fMiscFlags & 3);
        this.fMiscFlags = (short)(this.fMiscFlags | s & 3);
    }

    public void setIsNillable() {
        this.fMiscFlags = (short)(this.fMiscFlags | 4);
    }

    public void setIsAbstract() {
        this.fMiscFlags = (short)(this.fMiscFlags | 8);
    }

    public void setIsGlobal() {
        this.fMiscFlags = (short)(this.fMiscFlags | 0x10);
    }

    public void addIDConstaint(IdentityConstraint identityConstraint) {
        if (this.fIDCPos == this.fIDConstraints.length) {
            this.fIDConstraints = XSElementDecl.resize(this.fIDConstraints, this.fIDCPos * 2);
        }
        this.fIDConstraints[this.fIDCPos++] = identityConstraint;
    }

    public IdentityConstraint[] getIDConstraints() {
        if (this.fIDCPos < this.fIDConstraints.length) {
            this.fIDConstraints = XSElementDecl.resize(this.fIDConstraints, this.fIDCPos);
        }
        return this.fIDConstraints;
    }

    static final IdentityConstraint[] resize(IdentityConstraint[] identityConstraintArray, int n) {
        IdentityConstraint[] identityConstraintArray2 = new IdentityConstraint[n];
        System.arraycopy(identityConstraintArray, 0, identityConstraintArray2, 0, Math.min(identityConstraintArray.length, n));
        return identityConstraintArray2;
    }

    public String toString() {
        if (this.fDescription == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\"");
            if (this.fTargetNamespace != null) {
                stringBuffer.append(this.fTargetNamespace);
            }
            stringBuffer.append("\"");
            stringBuffer.append(":");
            stringBuffer.append(this.fName);
            this.fDescription = stringBuffer.toString();
        }
        return this.fDescription;
    }

    public int hashCode() {
        int n = this.fName.hashCode();
        if (this.fTargetNamespace != null) {
            n = (n << 16) + this.fTargetNamespace.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        return object == this;
    }
}

