/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmServerHistoryReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class HistoryLoadTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private Exception lastException;
    private final Set<PrimitiveId> toLoad = new HashSet<PrimitiveId>();
    private HistoryDataSet loadedData;
    private OsmServerHistoryReader reader;

    public HistoryLoadTask() {
        super(I18n.tr("Load history", new Object[0]), true);
    }

    public HistoryLoadTask(Component component) {
        super(component, I18n.tr("Load history", new Object[0]), true);
        CheckParameterUtil.ensureParameterNotNull(component, "parent");
    }

    public HistoryLoadTask add(PrimitiveId primitiveId) {
        CheckParameterUtil.ensureValidPrimitiveId(primitiveId, "pid");
        this.toLoad.add(primitiveId);
        return this;
    }

    public HistoryLoadTask add(HistoryOsmPrimitive historyOsmPrimitive) {
        CheckParameterUtil.ensureParameterNotNull(historyOsmPrimitive, "primitive");
        return this.add(historyOsmPrimitive.getPrimitiveId());
    }

    public HistoryLoadTask add(History history) {
        CheckParameterUtil.ensureParameterNotNull(history, "history");
        return this.add(history.getPrimitiveId());
    }

    public HistoryLoadTask add(OsmPrimitive osmPrimitive) {
        CheckParameterUtil.ensureValidPrimitiveId(osmPrimitive, "primitive");
        return this.add(osmPrimitive.getPrimitiveId());
    }

    public HistoryLoadTask add(Collection<? extends OsmPrimitive> collection) {
        CheckParameterUtil.ensureParameterNotNull(collection, "primitives");
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive == null) continue;
            this.add(osmPrimitive);
        }
        return this;
    }

    @Override
    protected void cancel() {
        if (this.reader != null) {
            this.reader.cancel();
        }
        this.canceled = true;
    }

    @Override
    protected void finish() {
        if (this.isCanceled()) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        HistoryDataSet.getInstance().mergeInto(this.loadedData);
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        this.loadedData = new HistoryDataSet();
        try {
            this.progressMonitor.setTicksCount(this.toLoad.size());
            for (PrimitiveId primitiveId : this.toLoad) {
                HistoryDataSet historyDataSet;
                if (this.canceled) break;
                String string = HistoryLoadTask.getLoadingMessage(primitiveId);
                this.progressMonitor.indeterminateSubTask(I18n.tr(string, Long.toString(primitiveId.getUniqueId())));
                this.reader = null;
                try {
                    this.reader = new OsmServerHistoryReader(primitiveId.getType(), primitiveId.getUniqueId());
                    historyDataSet = HistoryLoadTask.loadHistory(this.reader, this.progressMonitor);
                }
                catch (OsmTransferException osmTransferException) {
                    if (this.canceled) {
                        return;
                    }
                    throw osmTransferException;
                }
                this.loadedData.mergeInto(historyDataSet);
            }
        }
        catch (OsmTransferException osmTransferException) {
            this.lastException = osmTransferException;
            return;
        }
    }

    protected static HistoryDataSet loadHistory(OsmServerHistoryReader osmServerHistoryReader, ProgressMonitor progressMonitor) throws OsmTransferException {
        HistoryDataSet historyDataSet = osmServerHistoryReader.parseHistory(progressMonitor.createSubTaskMonitor(1, false));
        if (historyDataSet != null) {
            OsmServerChangesetReader osmServerChangesetReader = new OsmServerChangesetReader();
            ArrayList<Long> arrayList = new ArrayList<Long>(historyDataSet.getChangesetIds());
            int n = 100;
            for (int i = 0; i < arrayList.size(); i += n) {
                for (Changeset changeset : osmServerChangesetReader.queryChangesets(new ChangesetQuery().forChangesetIds(arrayList.subList(i, Math.min(i + n, arrayList.size()))), progressMonitor.createSubTaskMonitor(1, false))) {
                    historyDataSet.putChangeset(changeset);
                }
            }
        }
        return historyDataSet;
    }

    protected static String getLoadingMessage(PrimitiveId primitiveId) {
        switch (primitiveId.getType()) {
            case NODE: {
                return I18n.marktr("Loading history for node {0}");
            }
            case WAY: {
                return I18n.marktr("Loading history for way {0}");
            }
            case RELATION: {
                return I18n.marktr("Loading history for relation {0}");
            }
        }
        return "";
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Exception getLastException() {
        return this.lastException;
    }
}

