/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.StrokeProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public final class GuiHelper {
    private GuiHelper() {
    }

    public static void setEnabledRec(Container container, boolean bl) {
        Component[] componentArray;
        container.setEnabled(bl);
        for (Component component : componentArray = container.getComponents()) {
            if (component instanceof Container) {
                GuiHelper.setEnabledRec((Container)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    public static void executeByMainWorkerInEDT(Runnable runnable) {
        Main.worker.submit(() -> GuiHelper.runInEDTAndWait(runnable));
    }

    public static void runInEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void runInEDTAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                Main.error(exception);
            }
        }
    }

    public static void runInEDTAndWaitWithException(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException | InvocationTargetException exception) {
                throw BugReport.intercept(exception).put("task", runnable);
            }
        }
    }

    public static <V> V runInEDTAndWaitAndReturn(Callable<V> callable) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                Main.error(exception);
                return null;
            }
        }
        FutureTask<V> futureTask = new FutureTask<V>(callable);
        SwingUtilities.invokeLater(futureTask);
        try {
            return futureTask.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Main.error(exception);
            return null;
        }
    }

    public static void assertCallFromEdt() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Needs to be called from the EDT thread, not from " + Thread.currentThread().getName());
        }
    }

    public static boolean warnUser(String string, String string2, ImageIcon imageIcon, String string3) {
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, string, I18n.tr("Cancel", new Object[0]), I18n.tr("Continue", new Object[0]));
        extendedDialog.setContent(string2);
        extendedDialog.setButtonIcons(new ImageProvider("cancel").setMaxSize(ImageProvider.ImageSizes.LARGEICON).get(), new ImageProvider("upload").setMaxSize(ImageProvider.ImageSizes.LARGEICON).addOverlay(new ImageOverlay(new ImageProvider("warning-small"), 0.5, 0.5, 1.0, 1.0)).get());
        extendedDialog.setToolTipTexts(I18n.tr("Cancel", new Object[0]), string3);
        extendedDialog.setIcon(2);
        extendedDialog.setCancelButton(1);
        return extendedDialog.showDialog().getValue() != 2;
    }

    public static void notifyUserHtmlError(Component component, String string, String string2, String string3) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(string2), GBC.eol());
        jPanel.add((Component)new JLabel(I18n.tr("Received error page:", new Object[0])), GBC.eol());
        JScrollPane jScrollPane = GuiHelper.embedInVerticalScrollPane(new HtmlPanel(string3));
        jScrollPane.setPreferredSize(new Dimension(640, 240));
        jPanel.add((Component)jScrollPane, GBC.eol().fill(1));
        ExtendedDialog extendedDialog = new ExtendedDialog(component, string, I18n.tr("OK", new Object[0]));
        extendedDialog.setButtonIcons("ok.png");
        extendedDialog.setContent(jPanel);
        extendedDialog.showDialog();
    }

    public static Image getDisabledImage(Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), new GrayFilter(true, 20)));
    }

    public static ImageIcon getDisabledIcon(ImageIcon imageIcon) {
        return new ImageIcon(GuiHelper.getDisabledImage(imageIcon.getImage()));
    }

    public static Component prepareResizeableOptionPane(Component component, Dimension dimension) {
        if (component != null) {
            component.addHierarchyListener(hierarchyEvent -> {
                Dialog dialog;
                Window window = SwingUtilities.getWindowAncestor(component);
                if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                    dialog.setResizable(true);
                    if (dimension != null) {
                        dialog.setMinimumSize(dimension);
                    }
                }
            });
        }
        return component;
    }

    public static Timer scheduleTimer(int n, ActionListener actionListener, boolean bl) {
        Timer timer = new Timer(n, actionListener);
        timer.setRepeats(bl);
        timer.start();
        return timer;
    }

    public static Stroke getCustomizedStroke(String string) {
        return StrokeProperty.getFromString(string);
    }

    public static Font getMonospacedFont(JComponent jComponent) {
        if ("km".equals(LanguageInfo.getJOSMLocaleCode())) {
            return jComponent.getFont();
        }
        return new Font("Monospaced", jComponent.getFont().getStyle(), jComponent.getFont().getSize());
    }

    public static Font getTitleFont() {
        return new Font("SansSerif", 1, 23);
    }

    public static JScrollPane embedInVerticalScrollPane(Component component) {
        return new JScrollPane(component, 20, 31);
    }

    public static JScrollPane setDefaultIncrement(JScrollPane jScrollPane) {
        if (jScrollPane.getViewport().getView() instanceof Scrollable) {
            throw new IllegalArgumentException();
        }
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        return jScrollPane;
    }

    public static int getMenuShortcutKeyMaskEx() {
        return Main.isPlatformOsx() ? 256 : 128;
    }

    public static void setUIFont(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "name");
        Main.info("Setting " + string + " as the default UI font");
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (!(object instanceof FontUIResource)) continue;
            FontUIResource fontUIResource = (FontUIResource)object;
            UIManager.put(k, new FontUIResource(string, fontUIResource.getStyle(), fontUIResource.getSize()));
        }
    }

    public static void setBackgroundReadable(JComponent jComponent, Color color) {
        jComponent.setBackground(color);
        jComponent.setForeground(ColorHelper.getForegroundColor(color));
    }

    public static Dimension getScreenSize() {
        return GraphicsEnvironment.isHeadless() ? new Dimension(800, 600) : Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static Dimension getMaximumScreenSize() {
        if (GraphicsEnvironment.isHeadless()) {
            return new Dimension(800, 600);
        }
        int n = 0;
        int n2 = 0;
        for (GraphicsDevice graphicsDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            DisplayMode displayMode = graphicsDevice.getDisplayMode();
            if (displayMode == null) continue;
            n = Math.max(n, displayMode.getHeight());
            n2 = Math.max(n2, displayMode.getWidth());
        }
        if (n == 0 || n2 == 0) {
            return new Dimension(800, 600);
        }
        return new Dimension(n2, n);
    }

    public static Window getWindowAncestorFor(EventObject eventObject) {
        Object object;
        if (eventObject != null && (object = eventObject.getSource()) instanceof Component) {
            Window window = SwingUtilities.getWindowAncestor((Component)object);
            if (window != null) {
                return window;
            }
            Container container = ((Component)object).getParent();
            if (container instanceof JPopupMenu) {
                Component component = ((JPopupMenu)container).getInvoker();
                return SwingUtilities.getWindowAncestor(component);
            }
        }
        return null;
    }

    public static void extendTooltipDelay(Component component) {
        GuiHelper.extendTooltipDelay(component, 60000);
    }

    public static void extendTooltipDelay(Component component, final int n) {
        final int n2 = ToolTipManager.sharedInstance().getDismissDelay();
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ToolTipManager.sharedInstance().setDismissDelay(n);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ToolTipManager.sharedInstance().setDismissDelay(n2);
            }
        });
    }

    public static Frame getFrameForComponent(Component component) {
        try {
            return JOptionPane.getFrameForComponent(component);
        }
        catch (HeadlessException headlessException) {
            Main.debug(headlessException);
            return null;
        }
    }
}

