/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.logging;

import ch.ehi.basics.logging.AbstractFilteringListener;
import ch.ehi.basics.logging.StdListener;
import ch.ehi.basics.logging.StdLogEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class FileListener
extends AbstractFilteringListener {
    private PrintWriter out = null;
    private File file = null;
    private boolean doTimeStamp = false;

    @Override
    public void outputMsgLine(int n, int n2, String string) {
        if (this.out == null) {
            try {
                this.out = new PrintWriter(new BufferedWriter(new FileWriter(this.file)));
            }
            catch (IOException iOException) {
                StdListener.getInstance().logEvent(new StdLogEvent(7, null, iOException, null));
            }
        }
        if (this.out != null) {
            if (string.endsWith("\n")) {
                this.out.print(string);
            } else {
                this.out.println(string);
            }
            this.out.flush();
        }
    }

    @Override
    public String getTimestamp() {
        if (!this.doTimeStamp) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SS");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        String string = simpleDateFormat.format(new Date()) + "Z";
        return string;
    }

    public FileListener(File file) {
        this.file = file;
    }

    public FileListener(File file, boolean bl) {
        this.file = file;
        this.doTimeStamp = bl;
    }

    public void close() {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }
}

