'''OpenGL extension OES.byte_coordinates

This module customises the behaviour of the 
OpenGL.raw.GL.OES.byte_coordinates to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/OES/byte_coordinates.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.OES.byte_coordinates import *
from OpenGL.raw.GL.OES.byte_coordinates import _EXTENSION_NAME

def glInitByteCoordinatesOES():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

glMultiTexCoord1bvOES=wrapper.wrapper(glMultiTexCoord1bvOES).setInputArraySize(
    'coords', 1
)
glMultiTexCoord2bvOES=wrapper.wrapper(glMultiTexCoord2bvOES).setInputArraySize(
    'coords', 2
)
glMultiTexCoord3bvOES=wrapper.wrapper(glMultiTexCoord3bvOES).setInputArraySize(
    'coords', 3
)
glMultiTexCoord4bvOES=wrapper.wrapper(glMultiTexCoord4bvOES).setInputArraySize(
    'coords', 4
)
glTexCoord1bvOES=wrapper.wrapper(glTexCoord1bvOES).setInputArraySize(
    'coords', 1
)
glTexCoord2bvOES=wrapper.wrapper(glTexCoord2bvOES).setInputArraySize(
    'coords', 2
)
glTexCoord3bvOES=wrapper.wrapper(glTexCoord3bvOES).setInputArraySize(
    'coords', 3
)
glTexCoord4bvOES=wrapper.wrapper(glTexCoord4bvOES).setInputArraySize(
    'coords', 4
)
glVertex2bvOES=wrapper.wrapper(glVertex2bvOES).setInputArraySize(
    'coords', 2
)
glVertex3bvOES=wrapper.wrapper(glVertex3bvOES).setInputArraySize(
    'coords', 3
)
glVertex4bvOES=wrapper.wrapper(glVertex4bvOES).setInputArraySize(
    'coords', 4
)
### END AUTOGENERATED SECTION