#pragma once
#include <stdlib.h>
#include <stdint.h>

typedef size_t GType;
typedef void *GVaClosureMarshal;
static unsigned int _array_length(void* _array)
{
	void** array = (void**)_array;
	unsigned int i=0;
	while (array && array[i] != 0) i++;
	return i;
}

typedef struct _GArray GArray;
typedef uint32_t GAsciiType;
typedef struct _GAsyncQueue GAsyncQueue;
typedef struct _GBookmarkFile GBookmarkFile;
typedef uint32_t GBookmarkFileError;
typedef struct _GByteArray GByteArray;
typedef struct _GBytes GBytes;
typedef struct _GChecksum GChecksum;
typedef uint32_t GChecksumType;
typedef void* GChildWatchFunc;
typedef void* GCompareDataFunc;
typedef void* GCompareFunc;
typedef struct _GCond GCond;
typedef uint32_t GConvertError;
typedef void* GCopyFunc;
typedef struct _GData GData;
typedef void* GDataForeachFunc;
typedef struct _GDate GDate;
typedef uint32_t GDateDMY;
typedef uint32_t GDateMonth;
typedef struct _GDateTime GDateTime;
typedef uint32_t GDateWeekday;
typedef struct _GDebugKey GDebugKey;
typedef void* GDestroyNotify;
typedef struct _GDir GDir;
typedef struct _GDoubleIEEE754 GDoubleIEEE754;
typedef void* GDuplicateFunc;
typedef void* GEqualFunc;
typedef struct _GError GError;
typedef uint32_t GErrorType;
typedef uint32_t GFileError;
typedef uint32_t GFileTest;
typedef struct _GFloatIEEE754 GFloatIEEE754;
typedef uint32_t GFormatSizeFlags;
typedef void* GFreeFunc;
typedef void* GFunc;
typedef void* GHFunc;
typedef void* GHRFunc;
typedef void* GHashFunc;
typedef struct _GHashTable GHashTable;
typedef struct _GHashTableIter GHashTableIter;
typedef struct _GHmac GHmac;
typedef struct _GHook GHook;
typedef void* GHookCheckFunc;
typedef void* GHookCheckMarshaller;
typedef void* GHookCompareFunc;
typedef void* GHookFinalizeFunc;
typedef void* GHookFindFunc;
typedef uint32_t GHookFlagMask;
typedef void* GHookFunc;
typedef struct _GHookList GHookList;
typedef void* GHookMarshaller;
typedef struct _GIConv GIConv;
typedef struct _GIOChannel GIOChannel;
typedef uint32_t GIOChannelError;
typedef uint32_t GIOCondition;
typedef uint32_t GIOError;
typedef uint32_t GIOFlags;
typedef void* GIOFunc;
typedef struct _GIOFuncs GIOFuncs;
typedef uint32_t GIOStatus;
typedef struct _GKeyFile GKeyFile;
typedef uint32_t GKeyFileError;
typedef uint32_t GKeyFileFlags;
typedef struct _GList GList;
typedef struct _GLogField GLogField;
typedef void* GLogFunc;
typedef int32_t GLogLevelFlags;
typedef void* GLogWriterFunc;
typedef uint32_t GLogWriterOutput;
typedef struct _GMainContext GMainContext;
typedef struct _GMainLoop GMainLoop;
typedef struct _GMappedFile GMappedFile;
typedef uint32_t GMarkupCollectType;
typedef uint32_t GMarkupError;
typedef struct _GMarkupParseContext GMarkupParseContext;
typedef uint32_t GMarkupParseFlags;
typedef struct _GMarkupParser GMarkupParser;
typedef struct _GMatchInfo GMatchInfo;
typedef struct _GMemVTable GMemVTable;
typedef struct _GMutex GMutex;
typedef struct _GNode GNode;
typedef void* GNodeForeachFunc;
typedef void* GNodeTraverseFunc;
typedef uint32_t GNormalizeMode;
typedef struct _GOnce GOnce;
typedef uint32_t GOnceStatus;
typedef uint32_t GOptionArg;
typedef void* GOptionArgFunc;
typedef struct _GOptionContext GOptionContext;
typedef struct _GOptionEntry GOptionEntry;
typedef uint32_t GOptionError;
typedef void* GOptionErrorFunc;
typedef uint32_t GOptionFlags;
typedef struct _GOptionGroup GOptionGroup;
typedef void* GOptionParseFunc;
typedef struct _GPatternSpec GPatternSpec;
typedef struct _GPollFD GPollFD;
typedef void* GPollFunc;
typedef void* GPrintFunc;
typedef struct _GPrivate GPrivate;
typedef struct _GPtrArray GPtrArray;
typedef struct _GQueue GQueue;
typedef struct _GRWLock GRWLock;
typedef struct _GRand GRand;
typedef struct _GRecMutex GRecMutex;
typedef struct _GRegex GRegex;
typedef uint32_t GRegexCompileFlags;
typedef uint32_t GRegexError;
typedef void* GRegexEvalCallback;
typedef uint32_t GRegexMatchFlags;
typedef struct _GSList GSList;
typedef struct _GScanner GScanner;
typedef struct _GScannerConfig GScannerConfig;
typedef void* GScannerMsgFunc;
typedef uint32_t GSeekType;
typedef struct _GSequence GSequence;
typedef struct _GSequenceIter GSequenceIter;
typedef void* GSequenceIterCompareFunc;
typedef uint32_t GShellError;
typedef uint32_t GSliceConfig;
typedef struct _GSource GSource;
typedef struct _GSourceCallbackFuncs GSourceCallbackFuncs;
typedef void* GSourceDummyMarshal;
typedef void* GSourceFunc;
typedef struct _GSourceFuncs GSourceFuncs;
typedef struct _GSourcePrivate GSourcePrivate;
typedef void* GSpawnChildSetupFunc;
typedef uint32_t GSpawnError;
typedef uint32_t GSpawnFlags;
typedef struct _GStatBuf GStatBuf;
typedef struct _GString GString;
typedef struct _GStringChunk GStringChunk;
typedef struct _GTestCase GTestCase;
typedef struct _GTestConfig GTestConfig;
typedef void* GTestDataFunc;
typedef uint32_t GTestFileType;
typedef void* GTestFixtureFunc;
typedef void* GTestFunc;
typedef struct _GTestLogBuffer GTestLogBuffer;
typedef void* GTestLogFatalFunc;
typedef struct _GTestLogMsg GTestLogMsg;
typedef uint32_t GTestLogType;
typedef uint32_t GTestSubprocessFlags;
typedef struct _GTestSuite GTestSuite;
typedef uint32_t GTestTrapFlags;
typedef struct _GThread GThread;
typedef uint32_t GThreadError;
typedef void* GThreadFunc;
typedef struct _GThreadPool GThreadPool;
typedef uint32_t GTimeType;
typedef struct _GTimeVal GTimeVal;
typedef struct _GTimeZone GTimeZone;
typedef struct _GTimer GTimer;
typedef uint32_t GTokenType;
typedef struct _GTokenValue GTokenValue;
typedef void* GTranslateFunc;
typedef struct _GTrashStack GTrashStack;
typedef uint32_t GTraverseFlags;
typedef void* GTraverseFunc;
typedef uint32_t GTraverseType;
typedef struct _GTree GTree;
typedef uint32_t GUnicodeBreakType;
typedef int32_t GUnicodeScript;
typedef uint32_t GUnicodeType;
typedef void* GUnixFDSourceFunc;
typedef uint32_t GUserDirectory;
typedef struct _GVariant GVariant;
typedef struct _GVariantBuilder GVariantBuilder;
typedef uint32_t GVariantClass;
typedef struct _GVariantDict GVariantDict;
typedef uint32_t GVariantParseError;
typedef struct _GVariantType GVariantType;
typedef void* GVoidFunc;
extern int32_t g_async_queue_length(GAsyncQueue*);
extern int32_t g_async_queue_length_unlocked(GAsyncQueue*);
extern void g_async_queue_lock(GAsyncQueue*);
extern void* g_async_queue_pop(GAsyncQueue*);
extern void* g_async_queue_pop_unlocked(GAsyncQueue*);
extern void g_async_queue_push(GAsyncQueue*, void*);
extern void g_async_queue_push_front(GAsyncQueue*, void*);
extern void g_async_queue_push_front_unlocked(GAsyncQueue*, void*);
extern void g_async_queue_push_unlocked(GAsyncQueue*, void*);
extern void g_async_queue_ref_unlocked(GAsyncQueue*);
extern int g_async_queue_remove(GAsyncQueue*, void*);
extern int g_async_queue_remove_unlocked(GAsyncQueue*, void*);
extern void* g_async_queue_timed_pop(GAsyncQueue*, GTimeVal*);
extern void* g_async_queue_timed_pop_unlocked(GAsyncQueue*, GTimeVal*);
extern void* g_async_queue_timeout_pop(GAsyncQueue*, uint64_t);
extern void* g_async_queue_timeout_pop_unlocked(GAsyncQueue*, uint64_t);
extern void* g_async_queue_try_pop(GAsyncQueue*);
extern void* g_async_queue_try_pop_unlocked(GAsyncQueue*);
extern void g_async_queue_unlock(GAsyncQueue*);
extern void g_async_queue_unref(GAsyncQueue*);
extern void g_async_queue_unref_and_unlock(GAsyncQueue*);
extern void g_bookmark_file_add_application(GBookmarkFile*, char*, char*, char*);
extern void g_bookmark_file_add_group(GBookmarkFile*, char*, char*);
extern void g_bookmark_file_free(GBookmarkFile*);
extern int32_t g_bookmark_file_get_added(GBookmarkFile*, char*, GError**);
extern int g_bookmark_file_get_app_info(GBookmarkFile*, char*, char*, char**, uint32_t*, int32_t*, GError**);
extern char** g_bookmark_file_get_applications(GBookmarkFile*, char*, uint32_t*, GError**);
extern char* g_bookmark_file_get_description(GBookmarkFile*, char*, GError**);
extern char** g_bookmark_file_get_groups(GBookmarkFile*, char*, uint32_t*, GError**);
extern int g_bookmark_file_get_icon(GBookmarkFile*, char*, char**, char**, GError**);
extern int g_bookmark_file_get_is_private(GBookmarkFile*, char*, GError**);
extern char* g_bookmark_file_get_mime_type(GBookmarkFile*, char*, GError**);
extern int32_t g_bookmark_file_get_modified(GBookmarkFile*, char*, GError**);
extern int32_t g_bookmark_file_get_size(GBookmarkFile*);
extern char* g_bookmark_file_get_title(GBookmarkFile*, char*, GError**);
extern char** g_bookmark_file_get_uris(GBookmarkFile*, uint32_t*);
extern int32_t g_bookmark_file_get_visited(GBookmarkFile*, char*, GError**);
extern int g_bookmark_file_has_application(GBookmarkFile*, char*, char*, GError**);
extern int g_bookmark_file_has_group(GBookmarkFile*, char*, char*, GError**);
extern int g_bookmark_file_has_item(GBookmarkFile*, char*);
extern int g_bookmark_file_load_from_data(GBookmarkFile*, char*, uint32_t, GError**);
extern int g_bookmark_file_load_from_data_dirs(GBookmarkFile*, char*, char*, GError**);
extern int g_bookmark_file_load_from_file(GBookmarkFile*, char*, GError**);
extern int g_bookmark_file_move_item(GBookmarkFile*, char*, char*, GError**);
extern int g_bookmark_file_remove_application(GBookmarkFile*, char*, char*, GError**);
extern int g_bookmark_file_remove_group(GBookmarkFile*, char*, char*, GError**);
extern int g_bookmark_file_remove_item(GBookmarkFile*, char*, GError**);
extern void g_bookmark_file_set_added(GBookmarkFile*, char*, int32_t);
extern int g_bookmark_file_set_app_info(GBookmarkFile*, char*, char*, char*, int32_t, int32_t, GError**);
extern void g_bookmark_file_set_description(GBookmarkFile*, char*, char*);
extern void g_bookmark_file_set_groups(GBookmarkFile*, char*, char*, uint32_t);
extern void g_bookmark_file_set_icon(GBookmarkFile*, char*, char*, char*);
extern void g_bookmark_file_set_is_private(GBookmarkFile*, char*, int);
extern void g_bookmark_file_set_mime_type(GBookmarkFile*, char*, char*);
extern void g_bookmark_file_set_modified(GBookmarkFile*, char*, int32_t);
extern void g_bookmark_file_set_title(GBookmarkFile*, char*, char*);
extern void g_bookmark_file_set_visited(GBookmarkFile*, char*, int32_t);
extern char* g_bookmark_file_to_data(GBookmarkFile*, uint32_t*, GError**);
extern int g_bookmark_file_to_file(GBookmarkFile*, char*, GError**);
extern uint32_t g_bookmark_file_error_quark();
extern uint8_t* g_byte_array_free(GByteArray*, int);
extern GBytes* g_byte_array_free_to_bytes(GByteArray*);
extern GByteArray* g_byte_array_new();
extern GByteArray* g_byte_array_new_take(uint8_t*, uint32_t);
extern void g_byte_array_unref(GByteArray*);
extern GBytes* g_bytes_new(uint8_t*, uint32_t);
extern GBytes* g_bytes_new_take(uint8_t*, uint32_t);
extern int32_t g_bytes_compare(GBytes*, GBytes*);
extern int g_bytes_equal(GBytes*, GBytes*);
extern uint8_t* g_bytes_get_data(GBytes*, uint32_t*);
extern uint32_t g_bytes_get_size(GBytes*);
extern uint32_t g_bytes_hash(GBytes*);
extern GBytes* g_bytes_new_from_bytes(GBytes*, uint32_t, uint32_t);
extern GBytes* g_bytes_ref(GBytes*);
extern void g_bytes_unref(GBytes*);
extern GByteArray* g_bytes_unref_to_array(GBytes*);
extern uint8_t* g_bytes_unref_to_data(GBytes*, uint32_t*);
extern GChecksum* g_checksum_new(GChecksumType);
extern GChecksum* g_checksum_copy(GChecksum*);
extern void g_checksum_free(GChecksum*);
extern char* g_checksum_get_string(GChecksum*);
extern void g_checksum_reset(GChecksum*);
extern void g_checksum_update(GChecksum*, uint8_t*, int32_t);
extern int32_t g_checksum_type_get_length(GChecksumType);
extern void g_cond_broadcast(GCond*);
extern void g_cond_clear(GCond*);
extern void g_cond_init(GCond*);
extern void g_cond_signal(GCond*);
extern void g_cond_wait(GCond*, GMutex*);
extern int g_cond_wait_until(GCond*, GMutex*, int64_t);
extern GDate* g_date_new();
extern GDate* g_date_new_dmy(uint8_t, GDateMonth, uint16_t);
extern GDate* g_date_new_julian(uint32_t);
extern void g_date_add_days(GDate*, uint32_t);
extern void g_date_add_months(GDate*, uint32_t);
extern void g_date_add_years(GDate*, uint32_t);
extern void g_date_clamp(GDate*, GDate*, GDate*);
extern void g_date_clear(GDate*, uint32_t);
extern int32_t g_date_compare(GDate*, GDate*);
extern int32_t g_date_days_between(GDate*, GDate*);
extern void g_date_free(GDate*);
extern uint8_t g_date_get_day(GDate*);
extern uint32_t g_date_get_day_of_year(GDate*);
extern uint32_t g_date_get_iso8601_week_of_year(GDate*);
extern uint32_t g_date_get_julian(GDate*);
extern uint32_t g_date_get_monday_week_of_year(GDate*);
extern GDateMonth g_date_get_month(GDate*);
extern uint32_t g_date_get_sunday_week_of_year(GDate*);
extern GDateWeekday g_date_get_weekday(GDate*);
extern uint16_t g_date_get_year(GDate*);
extern int g_date_is_first_of_month(GDate*);
extern int g_date_is_last_of_month(GDate*);
extern void g_date_order(GDate*, GDate*);
extern void g_date_set_day(GDate*, uint8_t);
extern void g_date_set_dmy(GDate*, uint8_t, GDateMonth, uint16_t);
extern void g_date_set_julian(GDate*, uint32_t);
extern void g_date_set_month(GDate*, GDateMonth);
extern void g_date_set_parse(GDate*, char*);
extern void g_date_set_time(GDate*, int32_t);
extern void g_date_set_time_t(GDate*, int32_t);
extern void g_date_set_time_val(GDate*, GTimeVal*);
extern void g_date_set_year(GDate*, uint16_t);
extern void g_date_subtract_days(GDate*, uint32_t);
extern void g_date_subtract_months(GDate*, uint32_t);
extern void g_date_subtract_years(GDate*, uint32_t);
extern void g_date_to_struct_tm(GDate*, void*);
extern int g_date_valid(GDate*);
extern uint8_t g_date_get_days_in_month(GDateMonth, uint16_t);
extern uint8_t g_date_get_monday_weeks_in_year(uint16_t);
extern uint8_t g_date_get_sunday_weeks_in_year(uint16_t);
extern int g_date_is_leap_year(uint16_t);
extern uint32_t g_date_strftime(char*, uint32_t, char*, GDate*);
extern int g_date_valid_day(uint8_t);
extern int g_date_valid_dmy(uint8_t, GDateMonth, uint16_t);
extern int g_date_valid_julian(uint32_t);
extern int g_date_valid_month(GDateMonth);
extern int g_date_valid_weekday(GDateWeekday);
extern int g_date_valid_year(uint16_t);
extern GDateTime* g_date_time_new(GTimeZone*, int32_t, int32_t, int32_t, int32_t, int32_t, double);
extern GDateTime* g_date_time_new_from_timeval_local(GTimeVal*);
extern GDateTime* g_date_time_new_from_timeval_utc(GTimeVal*);
extern GDateTime* g_date_time_new_from_unix_local(int64_t);
extern GDateTime* g_date_time_new_from_unix_utc(int64_t);
extern GDateTime* g_date_time_new_local(int32_t, int32_t, int32_t, int32_t, int32_t, double);
extern GDateTime* g_date_time_new_now(GTimeZone*);
extern GDateTime* g_date_time_new_now_local();
extern GDateTime* g_date_time_new_now_utc();
extern GDateTime* g_date_time_new_utc(int32_t, int32_t, int32_t, int32_t, int32_t, double);
extern GDateTime* g_date_time_add(GDateTime*, int64_t);
extern GDateTime* g_date_time_add_days(GDateTime*, int32_t);
extern GDateTime* g_date_time_add_full(GDateTime*, int32_t, int32_t, int32_t, int32_t, int32_t, double);
extern GDateTime* g_date_time_add_hours(GDateTime*, int32_t);
extern GDateTime* g_date_time_add_minutes(GDateTime*, int32_t);
extern GDateTime* g_date_time_add_months(GDateTime*, int32_t);
extern GDateTime* g_date_time_add_seconds(GDateTime*, double);
extern GDateTime* g_date_time_add_weeks(GDateTime*, int32_t);
extern GDateTime* g_date_time_add_years(GDateTime*, int32_t);
extern int64_t g_date_time_difference(GDateTime*, GDateTime*);
extern char* g_date_time_format(GDateTime*, char*);
extern int32_t g_date_time_get_day_of_month(GDateTime*);
extern int32_t g_date_time_get_day_of_week(GDateTime*);
extern int32_t g_date_time_get_day_of_year(GDateTime*);
extern int32_t g_date_time_get_hour(GDateTime*);
extern int32_t g_date_time_get_microsecond(GDateTime*);
extern int32_t g_date_time_get_minute(GDateTime*);
extern int32_t g_date_time_get_month(GDateTime*);
extern int32_t g_date_time_get_second(GDateTime*);
extern double g_date_time_get_seconds(GDateTime*);
extern char* g_date_time_get_timezone_abbreviation(GDateTime*);
extern int64_t g_date_time_get_utc_offset(GDateTime*);
extern int32_t g_date_time_get_week_numbering_year(GDateTime*);
extern int32_t g_date_time_get_week_of_year(GDateTime*);
extern int32_t g_date_time_get_year(GDateTime*);
extern void g_date_time_get_ymd(GDateTime*, int32_t*, int32_t*, int32_t*);
extern int g_date_time_is_daylight_savings(GDateTime*);
extern GDateTime* g_date_time_ref(GDateTime*);
extern GDateTime* g_date_time_to_local(GDateTime*);
extern int g_date_time_to_timeval(GDateTime*, GTimeVal*);
extern GDateTime* g_date_time_to_timezone(GDateTime*, GTimeZone*);
extern int64_t g_date_time_to_unix(GDateTime*);
extern GDateTime* g_date_time_to_utc(GDateTime*);
extern void g_date_time_unref(GDateTime*);
extern int32_t g_date_time_compare(void*, void*);
extern int g_date_time_equal(void*, void*);
extern uint32_t g_date_time_hash(void*);
extern void g_dir_close(GDir*);
extern char* g_dir_read_name(GDir*);
extern void g_dir_rewind(GDir*);
extern char* g_dir_make_tmp(char*, GError**);
extern GError* g_error_new_literal(uint32_t, int32_t, char*);
extern GError* g_error_copy(GError*);
extern void g_error_free(GError*);
extern int g_error_matches(GError*, uint32_t, int32_t);
extern int g_hash_table_add(GHashTable*, void*);
extern int g_hash_table_contains(GHashTable*, void*);
extern void g_hash_table_destroy(GHashTable*);
extern int g_hash_table_insert(GHashTable*, void*, void*);
extern void* g_hash_table_lookup(GHashTable*, void*);
extern int g_hash_table_lookup_extended(GHashTable*, void*, void**, void**);
extern int g_hash_table_remove(GHashTable*, void*);
extern void g_hash_table_remove_all(GHashTable*);
extern int g_hash_table_replace(GHashTable*, void*, void*);
extern uint32_t g_hash_table_size(GHashTable*);
extern int g_hash_table_steal(GHashTable*, void*);
extern void g_hash_table_steal_all(GHashTable*);
extern void g_hash_table_unref(GHashTable*);
extern void g_hash_table_iter_init(GHashTableIter*, GHashTable*);
extern int g_hash_table_iter_next(GHashTableIter*, void**, void**);
extern void g_hash_table_iter_remove(GHashTableIter*);
extern void g_hash_table_iter_replace(GHashTableIter*, void*);
extern void g_hash_table_iter_steal(GHashTableIter*);
extern void g_hmac_get_digest(GHmac*, uint8_t*, uint32_t*);
extern char* g_hmac_get_string(GHmac*);
extern void g_hmac_unref(GHmac*);
extern void g_hmac_update(GHmac*, uint8_t*, int32_t);
extern int32_t g_hook_compare_ids(GHook*, GHook*);
extern int g_hook_destroy(GHookList*, uint32_t);
extern void g_hook_destroy_link(GHookList*, GHook*);
extern void g_hook_free(GHookList*, GHook*);
extern void g_hook_insert_before(GHookList*, GHook*, GHook*);
extern void g_hook_prepend(GHookList*, GHook*);
extern void g_hook_unref(GHookList*, GHook*);
extern void g_hook_list_clear(GHookList*);
extern void g_hook_list_init(GHookList*, uint32_t);
extern void g_hook_list_invoke(GHookList*, int);
extern void g_hook_list_invoke_check(GHookList*, int);
extern uint32_t g_iconv(GIConv*, char*, uint32_t*, char*, uint32_t*);
extern int32_t g_iconv_close(GIConv*);
extern GIOChannel* g_io_channel_new_file(char*, char*, GError**);
extern GIOChannel* g_io_channel_unix_new(int32_t);
extern void g_io_channel_close(GIOChannel*);
extern GIOStatus g_io_channel_flush(GIOChannel*, GError**);
extern GIOCondition g_io_channel_get_buffer_condition(GIOChannel*);
extern uint32_t g_io_channel_get_buffer_size(GIOChannel*);
extern int g_io_channel_get_buffered(GIOChannel*);
extern int g_io_channel_get_close_on_unref(GIOChannel*);
extern char* g_io_channel_get_encoding(GIOChannel*);
extern GIOFlags g_io_channel_get_flags(GIOChannel*);
extern char* g_io_channel_get_line_term(GIOChannel*, int32_t*);
extern void g_io_channel_init(GIOChannel*);
extern GIOError g_io_channel_read(GIOChannel*, char*, uint32_t, uint32_t*);
extern GIOStatus g_io_channel_read_chars(GIOChannel*, uint8_t**, uint32_t, uint32_t*, GError**);
extern GIOStatus g_io_channel_read_line(GIOChannel*, char**, uint32_t*, uint32_t*, GError**);
extern GIOStatus g_io_channel_read_line_string(GIOChannel*, GString*, uint32_t*, GError**);
extern GIOStatus g_io_channel_read_to_end(GIOChannel*, uint8_t**, uint32_t*, GError**);
extern GIOStatus g_io_channel_read_unichar(GIOChannel*, uint32_t*, GError**);
extern GIOChannel* g_io_channel_ref(GIOChannel*);
extern GIOError g_io_channel_seek(GIOChannel*, int64_t, GSeekType);
extern GIOStatus g_io_channel_seek_position(GIOChannel*, int64_t, GSeekType, GError**);
extern void g_io_channel_set_buffer_size(GIOChannel*, uint32_t);
extern void g_io_channel_set_buffered(GIOChannel*, int);
extern void g_io_channel_set_close_on_unref(GIOChannel*, int);
extern GIOStatus g_io_channel_set_encoding(GIOChannel*, char*, GError**);
extern GIOStatus g_io_channel_set_flags(GIOChannel*, GIOFlags, GError**);
extern void g_io_channel_set_line_term(GIOChannel*, char*, int32_t);
extern GIOStatus g_io_channel_shutdown(GIOChannel*, int, GError**);
extern int32_t g_io_channel_unix_get_fd(GIOChannel*);
extern void g_io_channel_unref(GIOChannel*);
extern GIOError g_io_channel_write(GIOChannel*, char*, uint32_t, uint32_t*);
extern GIOStatus g_io_channel_write_chars(GIOChannel*, uint8_t*, int32_t, uint32_t*, GError**);
extern GIOStatus g_io_channel_write_unichar(GIOChannel*, uint32_t, GError**);
extern GIOChannelError g_io_channel_error_from_errno(int32_t);
extern uint32_t g_io_channel_error_quark();
extern GKeyFile* g_key_file_new();
extern int g_key_file_get_boolean(GKeyFile*, char*, char*, GError**);
extern int* g_key_file_get_boolean_list(GKeyFile*, char*, char*, uint32_t*, GError**);
extern char* g_key_file_get_comment(GKeyFile*, char*, char*, GError**);
extern double g_key_file_get_double(GKeyFile*, char*, char*, GError**);
extern double* g_key_file_get_double_list(GKeyFile*, char*, char*, uint32_t*, GError**);
extern char** g_key_file_get_groups(GKeyFile*, uint32_t*);
extern int64_t g_key_file_get_int64(GKeyFile*, char*, char*, GError**);
extern int32_t g_key_file_get_integer(GKeyFile*, char*, char*, GError**);
extern int32_t* g_key_file_get_integer_list(GKeyFile*, char*, char*, uint32_t*, GError**);
extern char** g_key_file_get_keys(GKeyFile*, char*, uint32_t*, GError**);
extern char* g_key_file_get_locale_string(GKeyFile*, char*, char*, char*, GError**);
extern char** g_key_file_get_locale_string_list(GKeyFile*, char*, char*, char*, uint32_t*, GError**);
extern char* g_key_file_get_start_group(GKeyFile*);
extern char* g_key_file_get_string(GKeyFile*, char*, char*, GError**);
extern char** g_key_file_get_string_list(GKeyFile*, char*, char*, uint32_t*, GError**);
extern uint64_t g_key_file_get_uint64(GKeyFile*, char*, char*, GError**);
extern char* g_key_file_get_value(GKeyFile*, char*, char*, GError**);
extern int g_key_file_has_group(GKeyFile*, char*);
extern int g_key_file_load_from_bytes(GKeyFile*, GBytes*, GKeyFileFlags, GError**);
extern int g_key_file_load_from_data(GKeyFile*, char*, uint32_t, GKeyFileFlags, GError**);
extern int g_key_file_load_from_data_dirs(GKeyFile*, char*, char**, GKeyFileFlags, GError**);
extern int g_key_file_load_from_dirs(GKeyFile*, char*, char**, char**, GKeyFileFlags, GError**);
extern int g_key_file_load_from_file(GKeyFile*, char*, GKeyFileFlags, GError**);
extern int g_key_file_remove_comment(GKeyFile*, char*, char*, GError**);
extern int g_key_file_remove_group(GKeyFile*, char*, GError**);
extern int g_key_file_remove_key(GKeyFile*, char*, char*, GError**);
extern int g_key_file_save_to_file(GKeyFile*, char*, GError**);
extern void g_key_file_set_boolean(GKeyFile*, char*, char*, int);
extern void g_key_file_set_boolean_list(GKeyFile*, char*, char*, int*, uint32_t);
extern int g_key_file_set_comment(GKeyFile*, char*, char*, char*, GError**);
extern void g_key_file_set_double(GKeyFile*, char*, char*, double);
extern void g_key_file_set_double_list(GKeyFile*, char*, char*, double*, uint32_t);
extern void g_key_file_set_int64(GKeyFile*, char*, char*, int64_t);
extern void g_key_file_set_integer(GKeyFile*, char*, char*, int32_t);
extern void g_key_file_set_integer_list(GKeyFile*, char*, char*, int32_t*, uint32_t);
extern void g_key_file_set_list_separator(GKeyFile*, int8_t);
extern void g_key_file_set_locale_string(GKeyFile*, char*, char*, char*, char*);
extern void g_key_file_set_locale_string_list(GKeyFile*, char*, char*, char*, char**, uint32_t);
extern void g_key_file_set_string(GKeyFile*, char*, char*, char*);
extern void g_key_file_set_string_list(GKeyFile*, char*, char*, char**, uint32_t);
extern void g_key_file_set_uint64(GKeyFile*, char*, char*, uint64_t);
extern void g_key_file_set_value(GKeyFile*, char*, char*, char*);
extern char* g_key_file_to_data(GKeyFile*, uint32_t*, GError**);
extern void g_key_file_unref(GKeyFile*);
extern uint32_t g_key_file_error_quark();
extern GMainContext* g_main_context_new();
extern int g_main_context_acquire(GMainContext*);
extern void g_main_context_add_poll(GMainContext*, GPollFD*, int32_t);
extern int32_t g_main_context_check(GMainContext*, int32_t, GPollFD*, int32_t);
extern void g_main_context_dispatch(GMainContext*);
extern GSource* g_main_context_find_source_by_funcs_user_data(GMainContext*, GSourceFuncs*, void*);
extern GSource* g_main_context_find_source_by_id(GMainContext*, uint32_t);
extern GSource* g_main_context_find_source_by_user_data(GMainContext*, void*);
extern void g_main_context_invoke_full(GMainContext*, int32_t, GSourceFunc, void*, GDestroyNotify);
extern int g_main_context_is_owner(GMainContext*);
extern int g_main_context_iteration(GMainContext*, int);
extern int g_main_context_pending(GMainContext*);
extern void g_main_context_pop_thread_default(GMainContext*);
extern int g_main_context_prepare(GMainContext*, int32_t*);
extern void g_main_context_push_thread_default(GMainContext*);
extern int32_t g_main_context_query(GMainContext*, int32_t, int32_t*, GPollFD**, int32_t);
extern GMainContext* g_main_context_ref(GMainContext*);
extern void g_main_context_release(GMainContext*);
extern void g_main_context_remove_poll(GMainContext*, GPollFD*);
extern void g_main_context_unref(GMainContext*);
extern int g_main_context_wait(GMainContext*, GCond*, GMutex*);
extern void g_main_context_wakeup(GMainContext*);
extern GMainContext* g_main_context_default();
extern GMainContext* g_main_context_get_thread_default();
extern GMainContext* g_main_context_ref_thread_default();
extern GMainLoop* g_main_loop_new(GMainContext*, int);
extern GMainContext* g_main_loop_get_context(GMainLoop*);
extern int g_main_loop_is_running(GMainLoop*);
extern void g_main_loop_quit(GMainLoop*);
extern GMainLoop* g_main_loop_ref(GMainLoop*);
extern void g_main_loop_run(GMainLoop*);
extern void g_main_loop_unref(GMainLoop*);
extern GMappedFile* g_mapped_file_new(char*, int, GError**);
extern GMappedFile* g_mapped_file_new_from_fd(int32_t, int, GError**);
extern void g_mapped_file_free(GMappedFile*);
extern GBytes* g_mapped_file_get_bytes(GMappedFile*);
extern char* g_mapped_file_get_contents(GMappedFile*);
extern uint32_t g_mapped_file_get_length(GMappedFile*);
extern GMappedFile* g_mapped_file_ref(GMappedFile*);
extern void g_mapped_file_unref(GMappedFile*);
extern GMarkupParseContext* g_markup_parse_context_new(GMarkupParser*, GMarkupParseFlags, void*, GDestroyNotify);
extern int g_markup_parse_context_end_parse(GMarkupParseContext*, GError**);
extern void g_markup_parse_context_free(GMarkupParseContext*);
extern char* g_markup_parse_context_get_element(GMarkupParseContext*);
extern void g_markup_parse_context_get_position(GMarkupParseContext*, int32_t*, int32_t*);
extern void* g_markup_parse_context_get_user_data(GMarkupParseContext*);
extern int g_markup_parse_context_parse(GMarkupParseContext*, char*, int32_t, GError**);
extern void* g_markup_parse_context_pop(GMarkupParseContext*);
extern void g_markup_parse_context_push(GMarkupParseContext*, GMarkupParser*, void*);
extern GMarkupParseContext* g_markup_parse_context_ref(GMarkupParseContext*);
extern void g_markup_parse_context_unref(GMarkupParseContext*);
extern char* g_match_info_expand_references(GMatchInfo*, char*, GError**);
extern char* g_match_info_fetch(GMatchInfo*, int32_t);
extern char** g_match_info_fetch_all(GMatchInfo*);
extern char* g_match_info_fetch_named(GMatchInfo*, char*);
extern int g_match_info_fetch_named_pos(GMatchInfo*, char*, int32_t*, int32_t*);
extern int g_match_info_fetch_pos(GMatchInfo*, int32_t, int32_t*, int32_t*);
extern void g_match_info_free(GMatchInfo*);
extern int32_t g_match_info_get_match_count(GMatchInfo*);
extern GRegex* g_match_info_get_regex(GMatchInfo*);
extern char* g_match_info_get_string(GMatchInfo*);
extern int g_match_info_is_partial_match(GMatchInfo*);
extern int g_match_info_matches(GMatchInfo*);
extern int g_match_info_next(GMatchInfo*, GError**);
extern GMatchInfo* g_match_info_ref(GMatchInfo*);
extern void g_match_info_unref(GMatchInfo*);
extern void g_mutex_clear(GMutex*);
extern void g_mutex_init(GMutex*);
extern void g_mutex_lock(GMutex*);
extern int g_mutex_trylock(GMutex*);
extern void g_mutex_unlock(GMutex*);
extern int32_t g_node_child_index(GNode*, void*);
extern int32_t g_node_child_position(GNode*, GNode*);
extern uint32_t g_node_depth(GNode*);
extern void g_node_destroy(GNode*);
extern int g_node_is_ancestor(GNode*, GNode*);
extern uint32_t g_node_max_height(GNode*);
extern uint32_t g_node_n_children(GNode*);
extern uint32_t g_node_n_nodes(GNode*, GTraverseFlags);
extern void g_node_reverse_children(GNode*);
extern void g_node_unlink(GNode*);
extern int g_once_init_enter(void*);
extern void g_once_init_leave(void*, uint32_t);
extern void g_option_context_add_group(GOptionContext*, GOptionGroup*);
extern void g_option_context_add_main_entries(GOptionContext*, GOptionEntry*, char*);
extern void g_option_context_free(GOptionContext*);
extern char* g_option_context_get_description(GOptionContext*);
extern char* g_option_context_get_help(GOptionContext*, int, GOptionGroup*);
extern int g_option_context_get_help_enabled(GOptionContext*);
extern int g_option_context_get_ignore_unknown_options(GOptionContext*);
extern GOptionGroup* g_option_context_get_main_group(GOptionContext*);
extern int g_option_context_get_strict_posix(GOptionContext*);
extern char* g_option_context_get_summary(GOptionContext*);
extern int g_option_context_parse(GOptionContext*, int32_t*, char***, GError**);
extern int g_option_context_parse_strv(GOptionContext*, char***, GError**);
extern void g_option_context_set_description(GOptionContext*, char*);
extern void g_option_context_set_help_enabled(GOptionContext*, int);
extern void g_option_context_set_ignore_unknown_options(GOptionContext*, int);
extern void g_option_context_set_main_group(GOptionContext*, GOptionGroup*);
extern void g_option_context_set_strict_posix(GOptionContext*, int);
extern void g_option_context_set_summary(GOptionContext*, char*);
extern void g_option_context_set_translate_func(GOptionContext*, GTranslateFunc, void*, GDestroyNotify);
extern void g_option_context_set_translation_domain(GOptionContext*, char*);
extern GOptionGroup* g_option_group_new(char*, char*, char*, void*, GDestroyNotify);
extern void g_option_group_add_entries(GOptionGroup*, GOptionEntry*);
extern void g_option_group_free(GOptionGroup*);
extern GOptionGroup* g_option_group_ref(GOptionGroup*);
extern void g_option_group_set_translate_func(GOptionGroup*, GTranslateFunc, void*, GDestroyNotify);
extern void g_option_group_set_translation_domain(GOptionGroup*, char*);
extern void g_option_group_unref(GOptionGroup*);
extern int g_pattern_spec_equal(GPatternSpec*, GPatternSpec*);
extern void g_pattern_spec_free(GPatternSpec*);
extern void* g_private_get(GPrivate*);
extern void g_private_replace(GPrivate*, void*);
extern void g_private_set(GPrivate*, void*);
extern void g_queue_clear(GQueue*);
extern void g_queue_free(GQueue*);
extern void g_queue_free_full(GQueue*, GDestroyNotify);
extern uint32_t g_queue_get_length(GQueue*);
extern int32_t g_queue_index(GQueue*, void*);
extern void g_queue_init(GQueue*);
extern int g_queue_is_empty(GQueue*);
extern void* g_queue_peek_head(GQueue*);
extern void* g_queue_peek_nth(GQueue*, uint32_t);
extern void* g_queue_peek_tail(GQueue*);
extern void* g_queue_pop_head(GQueue*);
extern void* g_queue_pop_nth(GQueue*, uint32_t);
extern void* g_queue_pop_tail(GQueue*);
extern void g_queue_push_head(GQueue*, void*);
extern void g_queue_push_nth(GQueue*, void*, int32_t);
extern void g_queue_push_tail(GQueue*, void*);
extern int g_queue_remove(GQueue*, void*);
extern uint32_t g_queue_remove_all(GQueue*, void*);
extern void g_queue_reverse(GQueue*);
extern void g_rw_lock_clear(GRWLock*);
extern void g_rw_lock_init(GRWLock*);
extern void g_rw_lock_reader_lock(GRWLock*);
extern int g_rw_lock_reader_trylock(GRWLock*);
extern void g_rw_lock_reader_unlock(GRWLock*);
extern void g_rw_lock_writer_lock(GRWLock*);
extern int g_rw_lock_writer_trylock(GRWLock*);
extern void g_rw_lock_writer_unlock(GRWLock*);
extern double g_rand_double(GRand*);
extern double g_rand_double_range(GRand*, double, double);
extern void g_rand_free(GRand*);
extern uint32_t g_rand_int(GRand*);
extern int32_t g_rand_int_range(GRand*, int32_t, int32_t);
extern void g_rand_set_seed(GRand*, uint32_t);
extern void g_rand_set_seed_array(GRand*, uint32_t*, uint32_t);
extern void g_rec_mutex_clear(GRecMutex*);
extern void g_rec_mutex_init(GRecMutex*);
extern void g_rec_mutex_lock(GRecMutex*);
extern int g_rec_mutex_trylock(GRecMutex*);
extern void g_rec_mutex_unlock(GRecMutex*);
extern GRegex* g_regex_new(char*, GRegexCompileFlags, GRegexMatchFlags, GError**);
extern int32_t g_regex_get_capture_count(GRegex*);
extern GRegexCompileFlags g_regex_get_compile_flags(GRegex*);
extern int g_regex_get_has_cr_or_lf(GRegex*);
extern GRegexMatchFlags g_regex_get_match_flags(GRegex*);
extern int32_t g_regex_get_max_backref(GRegex*);
extern int32_t g_regex_get_max_lookbehind(GRegex*);
extern char* g_regex_get_pattern(GRegex*);
extern int32_t g_regex_get_string_number(GRegex*, char*);
extern int g_regex_match(GRegex*, char*, GRegexMatchFlags, GMatchInfo**);
extern int g_regex_match_all(GRegex*, char*, GRegexMatchFlags, GMatchInfo**);
extern int g_regex_match_all_full(GRegex*, char**, int32_t, int32_t, GRegexMatchFlags, GMatchInfo**, GError**);
extern int g_regex_match_full(GRegex*, char**, int32_t, int32_t, GRegexMatchFlags, GMatchInfo**, GError**);
extern GRegex* g_regex_ref(GRegex*);
extern char* g_regex_replace(GRegex*, char**, int32_t, int32_t, char*, GRegexMatchFlags, GError**);
extern char* g_regex_replace_literal(GRegex*, char**, int32_t, int32_t, char*, GRegexMatchFlags, GError**);
extern char** g_regex_split(GRegex*, char*, GRegexMatchFlags);
extern char** g_regex_split_full(GRegex*, char**, int32_t, int32_t, GRegexMatchFlags, int32_t, GError**);
extern void g_regex_unref(GRegex*);
extern int g_regex_check_replacement(char*, int*, GError**);
extern uint32_t g_regex_error_quark();
extern char* g_regex_escape_nul(char*, int32_t);
extern char* g_regex_escape_string(char**, int32_t);
extern int g_regex_match_simple(char*, char*, GRegexCompileFlags, GRegexMatchFlags);
extern char** g_regex_split_simple(char*, char*, GRegexCompileFlags, GRegexMatchFlags);
extern uint32_t g_scanner_cur_line(GScanner*);
extern uint32_t g_scanner_cur_position(GScanner*);
extern GTokenType g_scanner_cur_token(GScanner*);
extern void g_scanner_destroy(GScanner*);
extern int g_scanner_eof(GScanner*);
extern GTokenType g_scanner_get_next_token(GScanner*);
extern void g_scanner_input_file(GScanner*, int32_t);
extern void g_scanner_input_text(GScanner*, char*, uint32_t);
extern void* g_scanner_lookup_symbol(GScanner*, char*);
extern GTokenType g_scanner_peek_next_token(GScanner*);
extern void g_scanner_scope_add_symbol(GScanner*, uint32_t, char*, void*);
extern void* g_scanner_scope_lookup_symbol(GScanner*, uint32_t, char*);
extern void g_scanner_scope_remove_symbol(GScanner*, uint32_t, char*);
extern uint32_t g_scanner_set_scope(GScanner*, uint32_t);
extern void g_scanner_sync_file_offset(GScanner*);
extern void g_scanner_unexp_token(GScanner*, GTokenType, char*, char*, char*, char*, int32_t);
extern void g_sequence_free(GSequence*);
extern int32_t g_sequence_get_length(GSequence*);
extern int g_sequence_is_empty(GSequence*);
extern void* g_sequence_get(GSequenceIter*);
extern void g_sequence_move(GSequenceIter*, GSequenceIter*);
extern void g_sequence_move_range(GSequenceIter*, GSequenceIter*, GSequenceIter*);
extern void g_sequence_remove(GSequenceIter*);
extern void g_sequence_remove_range(GSequenceIter*, GSequenceIter*);
extern void g_sequence_set(GSequenceIter*, void*);
extern void g_sequence_swap(GSequenceIter*, GSequenceIter*);
extern int32_t g_sequence_iter_compare(GSequenceIter*, GSequenceIter*);
extern int32_t g_sequence_iter_get_position(GSequenceIter*);
extern int g_sequence_iter_is_begin(GSequenceIter*);
extern int g_sequence_iter_is_end(GSequenceIter*);
extern GSource* g_source_new(GSourceFuncs*, uint32_t);
extern void g_source_add_child_source(GSource*, GSource*);
extern void g_source_add_poll(GSource*, GPollFD*);
extern void* g_source_add_unix_fd(GSource*, int32_t, GIOCondition);
extern uint32_t g_source_attach(GSource*, GMainContext*);
extern void g_source_destroy(GSource*);
extern int g_source_get_can_recurse(GSource*);
extern GMainContext* g_source_get_context(GSource*);
extern void g_source_get_current_time(GSource*, GTimeVal*);
extern uint32_t g_source_get_id(GSource*);
extern char* g_source_get_name(GSource*);
extern int32_t g_source_get_priority(GSource*);
extern int64_t g_source_get_ready_time(GSource*);
extern int64_t g_source_get_time(GSource*);
extern int g_source_is_destroyed(GSource*);
extern void g_source_modify_unix_fd(GSource*, void*, GIOCondition);
extern GIOCondition g_source_query_unix_fd(GSource*, void*);
extern GSource* g_source_ref(GSource*);
extern void g_source_remove_child_source(GSource*, GSource*);
extern void g_source_remove_poll(GSource*, GPollFD*);
extern void g_source_remove_unix_fd(GSource*, void*);
extern void g_source_set_callback(GSource*, GSourceFunc, void*, GDestroyNotify);
extern void g_source_set_callback_indirect(GSource*, void*, GSourceCallbackFuncs*);
extern void g_source_set_can_recurse(GSource*, int);
extern void g_source_set_funcs(GSource*, GSourceFuncs*);
extern void g_source_set_name(GSource*, char*);
extern void g_source_set_priority(GSource*, int32_t);
extern void g_source_set_ready_time(GSource*, int64_t);
extern void g_source_unref(GSource*);
extern int g_source_remove(uint32_t);
extern int g_source_remove_by_funcs_user_data(GSourceFuncs*, void*);
extern int g_source_remove_by_user_data(void*);
extern void g_source_set_name_by_id(uint32_t, char*);
extern GString* g_string_append(GString*, char*);
extern GString* g_string_append_c(GString*, int8_t);
extern GString* g_string_append_len(GString*, char*, int32_t);
extern GString* g_string_append_unichar(GString*, uint32_t);
extern GString* g_string_append_uri_escaped(GString*, char*, char*, int);
extern GString* g_string_ascii_down(GString*);
extern GString* g_string_ascii_up(GString*);
extern GString* g_string_assign(GString*, char*);
extern GString* g_string_down(GString*);
extern int g_string_equal(GString*, GString*);
extern GString* g_string_erase(GString*, int32_t, int32_t);
extern char* g_string_free(GString*, int);
extern GBytes* g_string_free_to_bytes(GString*);
extern uint32_t g_string_hash(GString*);
extern GString* g_string_insert(GString*, int32_t, char*);
extern GString* g_string_insert_c(GString*, int32_t, int8_t);
extern GString* g_string_insert_len(GString*, int32_t, char*, int32_t);
extern GString* g_string_insert_unichar(GString*, int32_t, uint32_t);
extern GString* g_string_overwrite(GString*, uint32_t, char*);
extern GString* g_string_overwrite_len(GString*, uint32_t, char*, int32_t);
extern GString* g_string_prepend(GString*, char*);
extern GString* g_string_prepend_c(GString*, int8_t);
extern GString* g_string_prepend_len(GString*, char*, int32_t);
extern GString* g_string_prepend_unichar(GString*, uint32_t);
extern GString* g_string_set_size(GString*, uint32_t);
extern GString* g_string_truncate(GString*, uint32_t);
extern GString* g_string_up(GString*);
extern void g_string_chunk_clear(GStringChunk*);
extern void g_string_chunk_free(GStringChunk*);
extern char* g_string_chunk_insert(GStringChunk*, char*);
extern char* g_string_chunk_insert_const(GStringChunk*, char*);
extern char* g_string_chunk_insert_len(GStringChunk*, char*, int32_t);
extern void g_test_log_buffer_free(GTestLogBuffer*);
extern void g_test_log_buffer_push(GTestLogBuffer*, uint32_t, uint8_t*);
extern void g_test_log_msg_free(GTestLogMsg*);
extern void g_test_suite_add(GTestSuite*, GTestCase*);
extern void g_test_suite_add_suite(GTestSuite*, GTestSuite*);
extern void* g_thread_join(GThread*);
extern GThread* g_thread_ref(GThread*);
extern void g_thread_unref(GThread*);
extern uint32_t g_thread_error_quark();
extern void g_thread_exit(void*);
extern GThread* g_thread_self();
extern void g_thread_yield();
extern void g_thread_pool_free(GThreadPool*, int, int);
extern int32_t g_thread_pool_get_max_threads(GThreadPool*);
extern uint32_t g_thread_pool_get_num_threads(GThreadPool*);
extern int g_thread_pool_move_to_front(GThreadPool*, void*);
extern int g_thread_pool_push(GThreadPool*, void*, GError**);
extern int g_thread_pool_set_max_threads(GThreadPool*, int32_t, GError**);
extern uint32_t g_thread_pool_unprocessed(GThreadPool*);
extern uint32_t g_thread_pool_get_max_idle_time();
extern int32_t g_thread_pool_get_max_unused_threads();
extern uint32_t g_thread_pool_get_num_unused_threads();
extern void g_thread_pool_set_max_idle_time(uint32_t);
extern void g_thread_pool_set_max_unused_threads(int32_t);
extern void g_thread_pool_stop_unused_threads();
extern void g_time_val_add(GTimeVal*, int32_t);
extern char* g_time_val_to_iso8601(GTimeVal*);
extern int g_time_val_from_iso8601(char*, GTimeVal*);
extern GTimeZone* g_time_zone_new(char*);
extern GTimeZone* g_time_zone_new_local();
extern GTimeZone* g_time_zone_new_utc();
extern int32_t g_time_zone_adjust_time(GTimeZone*, GTimeType, int64_t*);
extern int32_t g_time_zone_find_interval(GTimeZone*, GTimeType, int64_t);
extern char* g_time_zone_get_abbreviation(GTimeZone*, int32_t);
extern int32_t g_time_zone_get_offset(GTimeZone*, int32_t);
extern int g_time_zone_is_dst(GTimeZone*, int32_t);
extern GTimeZone* g_time_zone_ref(GTimeZone*);
extern void g_time_zone_unref(GTimeZone*);
extern void g_timer_continue(GTimer*);
extern void g_timer_destroy(GTimer*);
extern double g_timer_elapsed(GTimer*, uint32_t*);
extern void g_timer_reset(GTimer*);
extern void g_timer_start(GTimer*);
extern void g_timer_stop(GTimer*);
extern uint32_t g_trash_stack_height(GTrashStack*);
extern void* g_trash_stack_peek(GTrashStack*);
extern void* g_trash_stack_pop(GTrashStack*);
extern void g_trash_stack_push(GTrashStack*, void*);
extern void g_tree_destroy(GTree*);
extern int32_t g_tree_height(GTree*);
extern void g_tree_insert(GTree*, void*, void*);
extern void* g_tree_lookup(GTree*, void*);
extern int g_tree_lookup_extended(GTree*, void*, void*, void*);
extern int32_t g_tree_nnodes(GTree*);
extern int g_tree_remove(GTree*, void*);
extern void g_tree_replace(GTree*, void*, void*);
extern int g_tree_steal(GTree*, void*);
extern void g_tree_unref(GTree*);
extern GVariant* g_variant_new_array(GVariantType*, GVariant**, uint32_t);
extern GVariant* g_variant_new_boolean(int);
extern GVariant* g_variant_new_byte(uint8_t);
extern GVariant* g_variant_new_bytestring(uint8_t*);
extern GVariant* g_variant_new_bytestring_array(char**, int32_t);
extern GVariant* g_variant_new_dict_entry(GVariant*, GVariant*);
extern GVariant* g_variant_new_double(double);
extern GVariant* g_variant_new_fixed_array(GVariantType*, void*, uint32_t, uint32_t);
extern GVariant* g_variant_new_from_bytes(GVariantType*, GBytes*, int);
extern GVariant* g_variant_new_from_data(GVariantType*, uint8_t*, uint32_t, int, GDestroyNotify, void*);
extern GVariant* g_variant_new_handle(int32_t);
extern GVariant* g_variant_new_int16(int16_t);
extern GVariant* g_variant_new_int32(int32_t);
extern GVariant* g_variant_new_int64(int64_t);
extern GVariant* g_variant_new_maybe(GVariantType*, GVariant*);
extern GVariant* g_variant_new_object_path(char*);
extern GVariant* g_variant_new_objv(char**, int32_t);
extern GVariant* g_variant_new_signature(char*);
extern GVariant* g_variant_new_string(char*);
extern GVariant* g_variant_new_strv(char**, int32_t);
extern GVariant* g_variant_new_tuple(GVariant**, uint32_t);
extern GVariant* g_variant_new_uint16(uint16_t);
extern GVariant* g_variant_new_uint32(uint32_t);
extern GVariant* g_variant_new_uint64(uint64_t);
extern GVariant* g_variant_new_variant(GVariant*);
extern GVariant* g_variant_byteswap(GVariant*);
extern int g_variant_check_format_string(GVariant*, char*, int);
extern GVariantClass g_variant_classify(GVariant*);
extern int32_t g_variant_compare(GVariant*, GVariant*);
extern uint8_t* g_variant_dup_bytestring(GVariant*, uint32_t*);
extern char** g_variant_dup_bytestring_array(GVariant*, uint32_t*);
extern char** g_variant_dup_objv(GVariant*, uint32_t*);
extern char* g_variant_dup_string(GVariant*, uint32_t*);
extern char** g_variant_dup_strv(GVariant*, uint32_t*);
extern int g_variant_equal(GVariant*, GVariant*);
extern int g_variant_get_boolean(GVariant*);
extern uint8_t g_variant_get_byte(GVariant*);
extern uint8_t* g_variant_get_bytestring(GVariant*);
extern char** g_variant_get_bytestring_array(GVariant*, uint32_t*);
extern GVariant* g_variant_get_child_value(GVariant*, uint32_t);
extern void* g_variant_get_data(GVariant*);
extern GBytes* g_variant_get_data_as_bytes(GVariant*);
extern double g_variant_get_double(GVariant*);
extern int32_t g_variant_get_handle(GVariant*);
extern int16_t g_variant_get_int16(GVariant*);
extern int32_t g_variant_get_int32(GVariant*);
extern int64_t g_variant_get_int64(GVariant*);
extern GVariant* g_variant_get_maybe(GVariant*);
extern GVariant* g_variant_get_normal_form(GVariant*);
extern char** g_variant_get_objv(GVariant*, uint32_t*);
extern uint32_t g_variant_get_size(GVariant*);
extern char* g_variant_get_string(GVariant*, uint32_t*);
extern char** g_variant_get_strv(GVariant*, uint32_t*);
extern GVariantType* g_variant_get_type(GVariant*);
extern char* g_variant_get_type_string(GVariant*);
extern uint16_t g_variant_get_uint16(GVariant*);
extern uint32_t g_variant_get_uint32(GVariant*);
extern uint64_t g_variant_get_uint64(GVariant*);
extern GVariant* g_variant_get_variant(GVariant*);
extern uint32_t g_variant_hash(GVariant*);
extern int g_variant_is_container(GVariant*);
extern int g_variant_is_floating(GVariant*);
extern int g_variant_is_normal_form(GVariant*);
extern int g_variant_is_of_type(GVariant*, GVariantType*);
extern GVariant* g_variant_lookup_value(GVariant*, char*, GVariantType*);
extern uint32_t g_variant_n_children(GVariant*);
extern char* g_variant_print(GVariant*, int);
extern GVariant* g_variant_ref(GVariant*);
extern GVariant* g_variant_ref_sink(GVariant*);
extern void g_variant_store(GVariant*, void*);
extern GVariant* g_variant_take_ref(GVariant*);
extern void g_variant_unref(GVariant*);
extern int g_variant_is_object_path(char*);
extern int g_variant_is_signature(char*);
extern GVariant* g_variant_parse(GVariantType*, char*, char*, char*, GError**);
extern char* g_variant_parse_error_print_context(GError*, char*);
extern uint32_t g_variant_parse_error_quark();
extern uint32_t g_variant_parser_get_error_quark();
extern GVariantBuilder* g_variant_builder_new(GVariantType*);
extern void g_variant_builder_add_value(GVariantBuilder*, GVariant*);
extern void g_variant_builder_close(GVariantBuilder*);
extern GVariant* g_variant_builder_end(GVariantBuilder*);
extern void g_variant_builder_open(GVariantBuilder*, GVariantType*);
extern GVariantBuilder* g_variant_builder_ref(GVariantBuilder*);
extern void g_variant_builder_unref(GVariantBuilder*);
extern GVariantDict* g_variant_dict_new(GVariant*);
extern void g_variant_dict_clear(GVariantDict*);
extern int g_variant_dict_contains(GVariantDict*, char*);
extern GVariant* g_variant_dict_end(GVariantDict*);
extern void g_variant_dict_insert_value(GVariantDict*, char*, GVariant*);
extern GVariant* g_variant_dict_lookup_value(GVariantDict*, char*, GVariantType*);
extern GVariantDict* g_variant_dict_ref(GVariantDict*);
extern int g_variant_dict_remove(GVariantDict*, char*);
extern void g_variant_dict_unref(GVariantDict*);
extern GVariantType* g_variant_type_new(char*);
extern GVariantType* g_variant_type_new_array(GVariantType*);
extern GVariantType* g_variant_type_new_dict_entry(GVariantType*, GVariantType*);
extern GVariantType* g_variant_type_new_maybe(GVariantType*);
extern GVariantType* g_variant_type_new_tuple(GVariantType**, int32_t);
extern GVariantType* g_variant_type_copy(GVariantType*);
extern char* g_variant_type_dup_string(GVariantType*);
extern GVariantType* g_variant_type_element(GVariantType*);
extern int g_variant_type_equal(GVariantType*, GVariantType*);
extern GVariantType* g_variant_type_first(GVariantType*);
extern void g_variant_type_free(GVariantType*);
extern uint32_t g_variant_type_get_string_length(GVariantType*);
extern uint32_t g_variant_type_hash(GVariantType*);
extern int g_variant_type_is_array(GVariantType*);
extern int g_variant_type_is_basic(GVariantType*);
extern int g_variant_type_is_container(GVariantType*);
extern int g_variant_type_is_definite(GVariantType*);
extern int g_variant_type_is_dict_entry(GVariantType*);
extern int g_variant_type_is_maybe(GVariantType*);
extern int g_variant_type_is_subtype_of(GVariantType*, GVariantType*);
extern int g_variant_type_is_tuple(GVariantType*);
extern int g_variant_type_is_variant(GVariantType*);
extern GVariantType* g_variant_type_key(GVariantType*);
extern uint32_t g_variant_type_n_items(GVariantType*);
extern GVariantType* g_variant_type_next(GVariantType*);
extern GVariantType* g_variant_type_value(GVariantType*);
extern GVariantType* g_variant_type_checked_(char*);
extern int g_variant_type_string_is_valid(char*);
extern int g_variant_type_string_scan(char*, char*, char**);
extern int32_t g_access(char*, int32_t);
extern int32_t g_ascii_digit_value(int8_t);
extern char* g_ascii_dtostr(char*, int32_t, double);
extern char* g_ascii_formatd(char*, int32_t, char*, double);
extern int32_t g_ascii_strcasecmp(char*, char*);
extern char* g_ascii_strdown(char*, int32_t);
extern int32_t g_ascii_strncasecmp(char*, char*, uint32_t);
extern double g_ascii_strtod(char*, char**);
extern int64_t g_ascii_strtoll(char*, char**, uint32_t);
extern uint64_t g_ascii_strtoull(char*, char**, uint32_t);
extern char* g_ascii_strup(char*, int32_t);
extern int8_t g_ascii_tolower(int8_t);
extern int8_t g_ascii_toupper(int8_t);
extern int32_t g_ascii_xdigit_value(int8_t);
extern void g_assert_warning(char*, char*, int32_t, char*, char*);
extern void g_assertion_message(char*, char*, int32_t, char*, char*);
extern void g_assertion_message_cmpstr(char*, char*, int32_t, char*, char*, char*, char*, char*);
extern void g_assertion_message_error(char*, char*, int32_t, char*, char*, GError*, uint32_t, int32_t);
extern void g_atexit(GVoidFunc);
extern int32_t g_atomic_int_add(int32_t*, int32_t);
extern uint32_t g_atomic_int_and(uint32_t*, uint32_t);
extern int g_atomic_int_compare_and_exchange(int32_t*, int32_t, int32_t);
extern int g_atomic_int_dec_and_test(int32_t*);
extern int32_t g_atomic_int_exchange_and_add(int32_t*, int32_t);
extern int32_t g_atomic_int_get(int32_t*);
extern void g_atomic_int_inc(int32_t*);
extern uint32_t g_atomic_int_or(uint32_t*, uint32_t);
extern void g_atomic_int_set(int32_t*, int32_t);
extern uint32_t g_atomic_int_xor(uint32_t*, uint32_t);
extern int32_t g_atomic_pointer_add(void*, int32_t);
extern uint32_t g_atomic_pointer_and(void*, uint32_t);
extern int g_atomic_pointer_compare_and_exchange(void*, void*, void*);
extern void* g_atomic_pointer_get(void*);
extern uint32_t g_atomic_pointer_or(void*, uint32_t);
extern void g_atomic_pointer_set(void*, void*);
extern uint32_t g_atomic_pointer_xor(void*, uint32_t);
extern uint8_t* g_base64_decode(char*, uint32_t*);
extern uint8_t* g_base64_decode_inplace(uint8_t**, uint32_t*);
extern uint32_t g_base64_decode_step(uint8_t*, uint32_t, uint8_t**, int32_t*, uint32_t*);
extern char* g_base64_encode(uint8_t*, uint32_t);
extern uint32_t g_base64_encode_close(int, uint8_t**, int32_t*, int32_t*);
extern uint32_t g_base64_encode_step(uint8_t*, uint32_t, int, uint8_t**, int32_t*, int32_t*);
extern char* g_basename(char*);
extern void g_bit_lock(int32_t*, int32_t);
extern int32_t g_bit_nth_lsf(uint32_t, int32_t);
extern int32_t g_bit_nth_msf(uint32_t, int32_t);
extern uint32_t g_bit_storage(uint32_t);
extern int g_bit_trylock(int32_t*, int32_t);
extern void g_bit_unlock(int32_t*, int32_t);
extern char* g_build_filenamev(char**);
extern char* g_build_pathv(char*, char**);
extern int32_t g_chdir(char*);
extern char* glib_check_version(uint32_t, uint32_t, uint32_t);
extern uint32_t g_child_watch_add_full(int32_t, int32_t, GChildWatchFunc, void*, GDestroyNotify);
extern GSource* g_child_watch_source_new(int32_t);
extern void g_clear_error(GError**);
extern int g_close(int32_t, GError**);
extern char* g_compute_checksum_for_bytes(GChecksumType, GBytes*);
extern char* g_compute_checksum_for_data(GChecksumType, uint8_t*, uint32_t);
extern char* g_compute_checksum_for_string(GChecksumType, char*, int32_t);
extern char* g_compute_hmac_for_bytes(GChecksumType, GBytes*, GBytes*);
extern char* g_compute_hmac_for_data(GChecksumType, uint8_t*, uint32_t, uint8_t*, uint32_t);
extern char* g_compute_hmac_for_string(GChecksumType, uint8_t*, uint32_t, char*, int32_t);
extern char* g_convert(char*, int32_t, char*, char*, uint32_t*, uint32_t*, GError**);
extern uint32_t g_convert_error_quark();
extern char* g_convert_with_fallback(char*, int32_t, char*, char*, char*, uint32_t*, uint32_t*, GError**);
extern char* g_convert_with_iconv(char*, int32_t, GIConv*, uint32_t*, uint32_t*, GError**);
extern void g_datalist_clear(GData*);
extern void* g_datalist_get_data(GData*, char*);
extern uint32_t g_datalist_get_flags(GData*);
extern void* g_datalist_id_get_data(GData*, uint32_t);
extern void* g_datalist_id_remove_no_notify(GData*, uint32_t);
extern int g_datalist_id_replace_data(GData*, uint32_t, void*, void*, GDestroyNotify, GDestroyNotify*);
extern void g_datalist_id_set_data_full(GData*, uint32_t, void*, GDestroyNotify);
extern void g_datalist_init(GData*);
extern void g_datalist_set_flags(GData*, uint32_t);
extern void g_datalist_unset_flags(GData*, uint32_t);
extern void g_dataset_destroy(void*);
extern void* g_dataset_id_get_data(void*, uint32_t);
extern void* g_dataset_id_remove_no_notify(void*, uint32_t);
extern void g_dataset_id_set_data_full(void*, uint32_t, void*, GDestroyNotify);
extern char* g_dcgettext(char*, char*, int32_t);
extern char* g_dgettext(char*, char*);
extern int g_direct_equal(void*, void*);
extern uint32_t g_direct_hash(void*);
extern char* g_dngettext(char*, char*, char*, uint32_t);
extern int g_double_equal(void*, void*);
extern uint32_t g_double_hash(void*);
extern char* g_dpgettext(char*, char*, uint32_t);
extern char* g_dpgettext2(char*, char*, char*);
extern char* g_environ_getenv(char**, char*);
extern char** g_environ_setenv(char**, char*, char*, int);
extern char** g_environ_unsetenv(char**, char*);
extern GFileError g_file_error_from_errno(int32_t);
extern uint32_t g_file_error_quark();
extern int g_file_get_contents(char*, uint8_t**, uint32_t*, GError**);
extern int32_t g_file_open_tmp(char*, char**, GError**);
extern char* g_file_read_link(char*, GError**);
extern int g_file_set_contents(char*, uint8_t*, int32_t, GError**);
extern int g_file_test(char*, GFileTest);
extern char* g_filename_display_basename(char*);
extern char* g_filename_display_name(char*);
extern char* g_filename_from_uri(char*, char**, GError**);
extern uint8_t* g_filename_from_utf8(char*, int32_t, uint32_t*, uint32_t*, GError**);
extern char* g_filename_to_uri(char*, char*, GError**);
extern char* g_filename_to_utf8(char*, int32_t, uint32_t*, uint32_t*, GError**);
extern char* g_find_program_in_path(char*);
extern char* g_format_size(uint64_t);
extern char* g_format_size_for_display(int64_t);
extern char* g_format_size_full(uint64_t, GFormatSizeFlags);
extern void g_free(void*);
extern char* g_get_application_name();
extern int g_get_charset(char**);
extern char* g_get_codeset();
extern char* g_get_current_dir();
extern void g_get_current_time(GTimeVal*);
extern char** g_get_environ();
extern int g_get_filename_charsets(char*);
extern char* g_get_home_dir();
extern char* g_get_host_name();
extern char** g_get_language_names();
extern char** g_get_locale_variants(char*);
extern int64_t g_get_monotonic_time();
extern uint32_t g_get_num_processors();
extern char* g_get_prgname();
extern char* g_get_real_name();
extern int64_t g_get_real_time();
extern char** g_get_system_config_dirs();
extern char** g_get_system_data_dirs();
extern char* g_get_tmp_dir();
extern char* g_get_user_cache_dir();
extern char* g_get_user_config_dir();
extern char* g_get_user_data_dir();
extern char* g_get_user_name();
extern char* g_get_user_runtime_dir();
extern char* g_get_user_special_dir(GUserDirectory);
extern char* g_getenv(char*);
extern int g_hostname_is_ascii_encoded(char*);
extern int g_hostname_is_ip_address(char*);
extern int g_hostname_is_non_ascii(char*);
extern char* g_hostname_to_ascii(char*);
extern char* g_hostname_to_unicode(char*);
extern uint32_t g_idle_add_full(int32_t, GSourceFunc, void*, GDestroyNotify);
extern int g_idle_remove_by_data(void*);
extern GSource* g_idle_source_new();
extern int g_int64_equal(void*, void*);
extern uint32_t g_int64_hash(void*);
extern int g_int_equal(void*, void*);
extern uint32_t g_int_hash(void*);
extern char* g_intern_static_string(char*);
extern char* g_intern_string(char*);
extern uint32_t g_io_add_watch_full(GIOChannel*, int32_t, GIOCondition, GIOFunc, void*, GDestroyNotify);
extern GSource* g_io_create_watch(GIOChannel*, GIOCondition);
extern char** g_listenv();
extern char* g_locale_from_utf8(char*, int32_t, uint32_t*, uint32_t*, GError**);
extern char* g_locale_to_utf8(char*, int32_t, uint32_t*, uint32_t*, GError**);
extern void g_log_default_handler(char*, GLogLevelFlags, char*, void*);
extern void g_log_remove_handler(char*, uint32_t);
extern GLogLevelFlags g_log_set_always_fatal(GLogLevelFlags);
extern GLogLevelFlags g_log_set_fatal_mask(char*, GLogLevelFlags);
extern uint32_t g_log_set_handler_full(char*, GLogLevelFlags, GLogFunc, void*, GDestroyNotify);
extern void g_log_set_writer_func(GLogWriterFunc, void*, GDestroyNotify);
extern void g_log_structured_array(GLogLevelFlags, GLogField*, uint32_t);
extern void g_log_variant(char*, GLogLevelFlags, GVariant*);
extern GLogWriterOutput g_log_writer_default(GLogLevelFlags, GLogField*, uint32_t, void*);
extern char* g_log_writer_format_fields(GLogLevelFlags, GLogField*, uint32_t, int);
extern int g_log_writer_is_journald(int32_t);
extern GLogWriterOutput g_log_writer_journald(GLogLevelFlags, GLogField*, uint32_t, void*);
extern GLogWriterOutput g_log_writer_standard_streams(GLogLevelFlags, GLogField*, uint32_t, void*);
extern int g_log_writer_supports_color(int32_t);
extern GSource* g_main_current_source();
extern int32_t g_main_depth();
extern void* g_malloc(uint32_t);
extern void* g_malloc0(uint32_t);
extern void* g_malloc0_n(uint32_t, uint32_t);
extern void* g_malloc_n(uint32_t, uint32_t);
extern uint32_t g_markup_error_quark();
extern char* g_markup_escape_text(char*, int32_t);
extern int g_mem_is_system_malloc();
extern void g_mem_profile();
extern void g_mem_set_vtable(GMemVTable*);
extern void* g_memdup(void*, uint32_t);
extern int32_t g_mkdir_with_parents(char*, int32_t);
extern char* g_mkdtemp(char*);
extern char* g_mkdtemp_full(char*, int32_t);
extern int32_t g_mkstemp(char*);
extern int32_t g_mkstemp_full(char*, int32_t, int32_t);
extern void g_nullify_pointer(void*);
extern void g_on_error_query(char*);
extern void g_on_error_stack_trace(char*);
extern uint32_t g_option_error_quark();
extern uint32_t g_parse_debug_string(char*, GDebugKey*, uint32_t);
extern char* g_path_get_basename(char*);
extern char* g_path_get_dirname(char*);
extern int g_path_is_absolute(char*);
extern char* g_path_skip_root(char*);
extern int g_pattern_match(GPatternSpec*, uint32_t, char*, char*);
extern int g_pattern_match_simple(char*, char*);
extern int g_pattern_match_string(GPatternSpec*, char*);
extern void g_pointer_bit_lock(void*, int32_t);
extern int g_pointer_bit_trylock(void*, int32_t);
extern void g_pointer_bit_unlock(void*, int32_t);
extern int32_t g_poll(GPollFD*, uint32_t, int32_t);
extern void g_propagate_error(GError**, GError*);
extern uint32_t g_quark_from_static_string(char*);
extern uint32_t g_quark_from_string(char*);
extern char* g_quark_to_string(uint32_t);
extern uint32_t g_quark_try_string(char*);
extern double g_random_double();
extern double g_random_double_range(double, double);
extern uint32_t g_random_int();
extern int32_t g_random_int_range(int32_t, int32_t);
extern void g_random_set_seed(uint32_t);
extern void* g_realloc(void*, uint32_t);
extern void* g_realloc_n(void*, uint32_t, uint32_t);
extern void g_reload_user_special_dirs_cache();
extern int32_t g_rmdir(char*);
extern void g_set_application_name(char*);
extern void g_set_error_literal(GError**, uint32_t, int32_t, char*);
extern void g_set_prgname(char*);
extern int g_setenv(char*, char*, int);
extern uint32_t g_shell_error_quark();
extern int g_shell_parse_argv(char*, int32_t*, char***, GError**);
extern char* g_shell_quote(char*);
extern char* g_shell_unquote(char*, GError**);
extern void* g_slice_alloc(uint32_t);
extern void* g_slice_alloc0(uint32_t);
extern void* g_slice_copy(uint32_t, void*);
extern void g_slice_free1(uint32_t, void*);
extern void g_slice_free_chain_with_offset(uint32_t, void*, uint32_t);
extern int64_t g_slice_get_config(GSliceConfig);
extern int64_t* g_slice_get_config_state(GSliceConfig, int64_t, uint32_t*);
extern void g_slice_set_config(GSliceConfig, int64_t);
extern uint32_t g_spaced_primes_closest(uint32_t);
extern int g_spawn_async(char*, char**, char**, GSpawnFlags, GSpawnChildSetupFunc, void*, int32_t*, GError**);
extern int g_spawn_async_with_pipes(char*, char**, char**, GSpawnFlags, GSpawnChildSetupFunc, void*, int32_t*, int32_t*, int32_t*, int32_t*, GError**);
extern int g_spawn_check_exit_status(int32_t, GError**);
extern void g_spawn_close_pid(int32_t);
extern int g_spawn_command_line_async(char*, GError**);
extern int g_spawn_command_line_sync(char*, uint8_t**, uint8_t**, int32_t*, GError**);
extern uint32_t g_spawn_error_quark();
extern uint32_t g_spawn_exit_error_quark();
extern int g_spawn_sync(char*, char**, char**, GSpawnFlags, GSpawnChildSetupFunc, void*, uint8_t**, uint8_t**, int32_t*, GError**);
extern char* g_stpcpy(char*, char*);
extern int g_str_equal(void*, void*);
extern int g_str_has_prefix(char*, char*);
extern int g_str_has_suffix(char*, char*);
extern uint32_t g_str_hash(void*);
extern int g_str_is_ascii(char*);
extern int g_str_match_string(char*, char*, int);
extern char* g_str_to_ascii(char*, char*);
extern char** g_str_tokenize_and_fold(char*, char*, char***);
extern char* g_strcanon(char*, char*, int8_t);
extern int32_t g_strcasecmp(char*, char*);
extern char* g_strchomp(char*);
extern char* g_strchug(char*);
extern int32_t g_strcmp0(char*, char*);
extern char* g_strcompress(char*);
extern char* g_strdelimit(char*, char*, int8_t);
extern char* g_strdown(char*);
extern char* g_strdup(char*);
extern char* g_strerror(int32_t);
extern char* g_strescape(char*, char*);
extern void g_strfreev(char*);
extern GString* g_string_new(char*);
extern GString* g_string_new_len(char*, int32_t);
extern GString* g_string_sized_new(uint32_t);
extern char* g_strip_context(char*, char*);
extern char* g_strjoinv(char*, char*);
extern uint32_t g_strlcat(char*, char*, uint32_t);
extern uint32_t g_strlcpy(char*, char*, uint32_t);
extern int32_t g_strncasecmp(char*, char*, uint32_t);
extern char* g_strndup(char*, uint32_t);
extern char* g_strnfill(uint32_t, int8_t);
extern char* g_strreverse(char*);
extern char* g_strrstr(char*, char*);
extern char* g_strrstr_len(char*, int32_t, char*);
extern char* g_strsignal(int32_t);
extern char* g_strstr_len(char*, int32_t, char*);
extern double g_strtod(char*, char**);
extern char* g_strup(char*);
extern int g_strv_contains(char*, char*);
extern GType g_strv_get_type();
extern uint32_t g_strv_length(char*);
extern void g_test_add_data_func(char*, void*, GTestDataFunc);
extern void g_test_add_data_func_full(char*, void*, GTestDataFunc, GDestroyNotify);
extern void g_test_add_func(char*, GTestFunc);
extern void g_test_assert_expected_messages_internal(char*, char*, int32_t, char*);
extern void g_test_bug(char*);
extern void g_test_bug_base(char*);
extern void g_test_expect_message(char*, GLogLevelFlags, char*);
extern void g_test_fail();
extern int g_test_failed();
extern char* g_test_get_dir(GTestFileType);
extern void g_test_incomplete(char*);
extern char* g_test_log_type_name(GTestLogType);
extern void g_test_queue_destroy(GDestroyNotify, void*);
extern void g_test_queue_free(void*);
extern double g_test_rand_double();
extern double g_test_rand_double_range(double, double);
extern int32_t g_test_rand_int();
extern int32_t g_test_rand_int_range(int32_t, int32_t);
extern int32_t g_test_run();
extern int32_t g_test_run_suite(GTestSuite*);
extern void g_test_set_nonfatal_assertions();
extern void g_test_skip(char*);
extern int g_test_subprocess();
extern double g_test_timer_elapsed();
extern double g_test_timer_last();
extern void g_test_timer_start();
extern void g_test_trap_assertions(char*, char*, int32_t, char*, uint64_t, char*);
extern int g_test_trap_fork(uint64_t, GTestTrapFlags);
extern int g_test_trap_has_passed();
extern int g_test_trap_reached_timeout();
extern void g_test_trap_subprocess(char*, uint64_t, GTestSubprocessFlags);
extern uint32_t g_timeout_add_full(int32_t, uint32_t, GSourceFunc, void*, GDestroyNotify);
extern uint32_t g_timeout_add_seconds_full(int32_t, uint32_t, GSourceFunc, void*, GDestroyNotify);
extern GSource* g_timeout_source_new(uint32_t);
extern GSource* g_timeout_source_new_seconds(uint32_t);
extern void* g_try_malloc(uint32_t);
extern void* g_try_malloc0(uint32_t);
extern void* g_try_malloc0_n(uint32_t, uint32_t);
extern void* g_try_malloc_n(uint32_t, uint32_t);
extern void* g_try_realloc(void*, uint32_t);
extern void* g_try_realloc_n(void*, uint32_t, uint32_t);
extern uint16_t* g_ucs4_to_utf16(uint32_t*, int32_t, int32_t*, int32_t*, GError**);
extern char* g_ucs4_to_utf8(uint32_t*, int32_t, int32_t*, int32_t*, GError**);
extern GUnicodeBreakType g_unichar_break_type(uint32_t);
extern int32_t g_unichar_combining_class(uint32_t);
extern int g_unichar_compose(uint32_t, uint32_t, uint32_t*);
extern int g_unichar_decompose(uint32_t, uint32_t*, uint32_t*);
extern int32_t g_unichar_digit_value(uint32_t);
extern uint32_t g_unichar_fully_decompose(uint32_t, int, uint32_t*, uint32_t);
extern int g_unichar_get_mirror_char(uint32_t, uint32_t*);
extern GUnicodeScript g_unichar_get_script(uint32_t);
extern int g_unichar_isalnum(uint32_t);
extern int g_unichar_isalpha(uint32_t);
extern int g_unichar_iscntrl(uint32_t);
extern int g_unichar_isdefined(uint32_t);
extern int g_unichar_isdigit(uint32_t);
extern int g_unichar_isgraph(uint32_t);
extern int g_unichar_islower(uint32_t);
extern int g_unichar_ismark(uint32_t);
extern int g_unichar_isprint(uint32_t);
extern int g_unichar_ispunct(uint32_t);
extern int g_unichar_isspace(uint32_t);
extern int g_unichar_istitle(uint32_t);
extern int g_unichar_isupper(uint32_t);
extern int g_unichar_iswide(uint32_t);
extern int g_unichar_iswide_cjk(uint32_t);
extern int g_unichar_isxdigit(uint32_t);
extern int g_unichar_iszerowidth(uint32_t);
extern int32_t g_unichar_to_utf8(uint32_t, char**);
extern uint32_t g_unichar_tolower(uint32_t);
extern uint32_t g_unichar_totitle(uint32_t);
extern uint32_t g_unichar_toupper(uint32_t);
extern GUnicodeType g_unichar_type(uint32_t);
extern int g_unichar_validate(uint32_t);
extern int32_t g_unichar_xdigit_value(uint32_t);
extern uint32_t* g_unicode_canonical_decomposition(uint32_t, uint32_t*);
extern void g_unicode_canonical_ordering(uint32_t*, uint32_t);
extern GUnicodeScript g_unicode_script_from_iso15924(uint32_t);
extern uint32_t g_unicode_script_to_iso15924(GUnicodeScript);
extern uint32_t g_unix_error_quark();
extern uint32_t g_unix_fd_add_full(int32_t, int32_t, GIOCondition, GUnixFDSourceFunc, void*, GDestroyNotify);
extern GSource* g_unix_fd_source_new(int32_t, GIOCondition);
extern int g_unix_open_pipe(int32_t*, int32_t, GError**);
extern int g_unix_set_fd_nonblocking(int32_t, int, GError**);
extern uint32_t g_unix_signal_add_full(int32_t, int32_t, GSourceFunc, void*, GDestroyNotify);
extern GSource* g_unix_signal_source_new(int32_t);
extern int32_t g_unlink(char*);
extern void g_unsetenv(char*);
extern char* g_uri_escape_string(char*, char*, int);
extern char** g_uri_list_extract_uris(char*);
extern char* g_uri_parse_scheme(char*);
extern char* g_uri_unescape_segment(char*, char*, char*);
extern char* g_uri_unescape_string(char*, char*);
extern void g_usleep(uint32_t);
extern uint32_t* g_utf16_to_ucs4(uint16_t*, int32_t, int32_t*, int32_t*, GError**);
extern char* g_utf16_to_utf8(uint16_t*, int32_t, int32_t*, int32_t*, GError**);
extern char* g_utf8_casefold(char*, int32_t);
extern int32_t g_utf8_collate(char*, char*);
extern char* g_utf8_collate_key(char*, int32_t);
extern char* g_utf8_collate_key_for_filename(char*, int32_t);
extern char* g_utf8_find_next_char(char*, char*);
extern char* g_utf8_find_prev_char(char*, char*);
extern uint32_t g_utf8_get_char(char*);
extern uint32_t g_utf8_get_char_validated(char*, int32_t);
extern char* g_utf8_normalize(char*, int32_t, GNormalizeMode);
extern char* g_utf8_offset_to_pointer(char*, int32_t);
extern int32_t g_utf8_pointer_to_offset(char*, char*);
extern char* g_utf8_prev_char(char*);
extern char* g_utf8_strchr(char*, int32_t, uint32_t);
extern char* g_utf8_strdown(char*, int32_t);
extern int32_t g_utf8_strlen(char*, int32_t);
extern char* g_utf8_strncpy(char*, char*, uint32_t);
extern char* g_utf8_strrchr(char*, int32_t, uint32_t);
extern char* g_utf8_strreverse(char*, int32_t);
extern char* g_utf8_strup(char*, int32_t);
extern char* g_utf8_substring(char*, int32_t, int32_t);
extern uint32_t* g_utf8_to_ucs4(char*, int32_t, int32_t*, int32_t*, GError**);
extern uint32_t* g_utf8_to_ucs4_fast(char*, int32_t, int32_t*);
extern uint16_t* g_utf8_to_utf16(char*, int32_t, int32_t*, int32_t*, GError**);
extern int g_utf8_validate(uint8_t*, int32_t, char**);
extern GType g_variant_get_gtype();
struct _GArray { uint8_t _data[8]; };
struct _GAsyncQueue {};
struct _GBookmarkFile {};
struct _GByteArray { uint8_t _data[8]; };
struct _GBytes {};
struct _GChecksum {};
struct _GCond { uint8_t _data[12]; };
struct _GData {};
struct _GDate { uint8_t _data[24]; };
struct _GDateTime {};
struct _GDebugKey { uint8_t _data[8]; };
struct _GDir {};
struct _GDoubleIEEE754 { uint8_t _data[8]; };
struct _GError { uint8_t _data[12]; };
struct _GFloatIEEE754 { uint8_t _data[4]; };
struct _GHashTable {};
struct _GHashTableIter { uint8_t _data[24]; };
struct _GHmac {};
struct _GHook { uint8_t _data[32]; };
struct _GHookList { uint8_t _data[32]; };
struct _GIConv {};
struct _GIOChannel { uint8_t _data[84]; };
struct _GIOFuncs { uint8_t _data[32]; };
struct _GKeyFile {};
struct _GList { uint8_t _data[12]; };
struct _GLogField { uint8_t _data[12]; };
struct _GMainContext {};
struct _GMainLoop {};
struct _GMappedFile {};
struct _GMarkupParseContext {};
struct _GMarkupParser { uint8_t _data[20]; };
struct _GMatchInfo {};
struct _GMemVTable { uint8_t _data[24]; };
struct _GMutex { uint8_t _data[8]; };
struct _GNode { uint8_t _data[20]; };
struct _GOnce { uint8_t _data[8]; };
struct _GOptionContext {};
struct _GOptionEntry { uint8_t _data[28]; };
struct _GOptionGroup {};
struct _GPatternSpec {};
struct _GPollFD { uint8_t _data[8]; };
struct _GPrivate { uint8_t _data[16]; };
struct _GPtrArray { uint8_t _data[8]; };
struct _GQueue { uint8_t _data[12]; };
struct _GRWLock { uint8_t _data[12]; };
struct _GRand {};
struct _GRecMutex { uint8_t _data[12]; };
struct _GRegex {};
struct _GSList { uint8_t _data[8]; };
struct _GScanner { uint8_t _data[104]; };
struct _GScannerConfig { uint8_t _data[108]; };
struct _GSequence {};
struct _GSequenceIter {};
struct _GSource { uint8_t _data[52]; };
struct _GSourceCallbackFuncs { uint8_t _data[12]; };
struct _GSourceFuncs { uint8_t _data[24]; };
struct _GSourcePrivate {};
struct _GStatBuf {};
struct _GString { uint8_t _data[12]; };
struct _GStringChunk {};
struct _GTestCase {};
struct _GTestConfig { uint8_t _data[24]; };
struct _GTestLogBuffer { uint8_t _data[8]; };
struct _GTestLogMsg { uint8_t _data[20]; };
struct _GTestSuite {};
struct _GThread {};
struct _GThreadPool { uint8_t _data[12]; };
struct _GTimeVal { uint8_t _data[8]; };
struct _GTimeZone {};
struct _GTimer {};
struct _GTokenValue { uint8_t _data[8]; };
struct _GTrashStack { uint8_t _data[4]; };
struct _GTree {};
struct _GVariant {};
struct _GVariantBuilder {};
struct _GVariantDict {};
struct _GVariantType {};
