/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.List;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.index.shard.ShardId;

public class FailedRerouteAllocation
extends RoutingAllocation {
    private final List<FailedShard> failedShards;

    public FailedRerouteAllocation(AllocationDeciders deciders, RoutingNodes routingNodes, ClusterState clusterState, List<FailedShard> failedShards, ClusterInfo clusterInfo, long currentNanoTime) {
        super(deciders, routingNodes, clusterState, clusterInfo, currentNanoTime, false);
        this.failedShards = failedShards;
    }

    public List<FailedShard> failedShards() {
        return this.failedShards;
    }

    public static class StaleShard {
        public final ShardId shardId;
        public final String allocationId;

        public StaleShard(ShardId shardId, String allocationId) {
            this.shardId = shardId;
            this.allocationId = allocationId;
        }

        public String toString() {
            return "stale shard, shard " + this.shardId + ", alloc. id [" + this.allocationId + "]";
        }
    }

    public static class FailedShard {
        public final ShardRouting routingEntry;
        public final String message;
        public final Exception failure;

        public FailedShard(ShardRouting routingEntry, String message, Exception failure) {
            assert (routingEntry.assignedToNode()) : "only assigned shards can be failed " + routingEntry;
            this.routingEntry = routingEntry;
            this.message = message;
            this.failure = failure;
        }

        public String toString() {
            return "failed shard, shard " + this.routingEntry + ", message [" + this.message + "], failure [" + ExceptionsHelper.detailedMessage(this.failure) + "]";
        }
    }
}

