/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.model.internal.Exceptions;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginClasspathInjectionSupportedCheckModelProducer
implements ModelProducer {
    private final String providerVersion;
    private final ModelProducer delegate;
    private static final GradleVersion SUPPORTED_VERSION = GradleVersion.version("2.8-rc-1");

    public PluginClasspathInjectionSupportedCheckModelProducer(String providerVersion, ModelProducer delegate) {
        this.providerVersion = providerVersion;
        this.delegate = delegate;
    }

    @Override
    public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
        if (!operationParameters.getInjectedPluginClasspath().isEmpty() && !this.isSupported()) {
            throw Exceptions.unsupportedFeature("plugin classpath injection feature", this.providerVersion, "2.8");
        }
        return this.delegate.produceModel(type, operationParameters);
    }

    private boolean isSupported() {
        return GradleVersion.version(this.providerVersion).compareTo(SUPPORTED_VERSION) >= 0;
    }
}

