/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.List;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.util.PriorityQueue;

public class DocIDMerger<T extends Sub> {
    private final List<T> subs;
    private final PriorityQueue<T> queue;
    private boolean first;
    private T current;
    private int nextIndex;

    public DocIDMerger(List<T> subs, int maxCount, boolean indexIsSorted) {
        this.subs = subs;
        this.queue = indexIsSorted && maxCount > 1 ? new PriorityQueue<T>(maxCount){

            @Override
            protected boolean lessThan(Sub a, Sub b) {
                assert (a.mappedDocID != b.mappedDocID);
                return a.mappedDocID < b.mappedDocID;
            }
        } : null;
        this.reset();
    }

    public DocIDMerger(List<T> subs, boolean indexIsSorted) {
        this(subs, subs.size(), indexIsSorted);
    }

    public void reset() {
        if (this.queue != null) {
            this.queue.clear();
            block0: for (Sub sub : this.subs) {
                int docID;
                while ((docID = sub.nextDoc()) != Integer.MAX_VALUE) {
                    int mappedDocID = sub.docMap.get(docID);
                    if (mappedDocID == -1) continue;
                    sub.mappedDocID = mappedDocID;
                    this.queue.add(sub);
                    continue block0;
                }
            }
            this.first = true;
        } else if (this.subs.size() > 0) {
            this.current = (Sub)this.subs.get(0);
            this.nextIndex = 1;
        } else {
            this.current = null;
            this.nextIndex = 0;
        }
    }

    public T next() {
        int mappedDocID;
        if (this.queue != null) {
            Sub top;
            block8: {
                top = (Sub)this.queue.top();
                if (top == null) {
                    return null;
                }
                if (!this.first) {
                    int docID;
                    int mappedDocID2;
                    do {
                        if ((docID = top.nextDoc()) != Integer.MAX_VALUE) continue;
                        this.queue.pop();
                        top = (Sub)this.queue.top();
                        break block8;
                    } while ((mappedDocID2 = top.docMap.get(docID)) == -1);
                    top.mappedDocID = mappedDocID2;
                    top = (Sub)this.queue.updateTop();
                }
            }
            this.first = false;
            return (T)top;
        }
        while (true) {
            if (this.current == null) {
                return null;
            }
            int docID = ((Sub)this.current).nextDoc();
            if (docID == Integer.MAX_VALUE) {
                if (this.nextIndex == this.subs.size()) {
                    this.current = null;
                    return null;
                }
                this.current = (Sub)this.subs.get(this.nextIndex);
                ++this.nextIndex;
                continue;
            }
            mappedDocID = ((Sub)this.current).docMap.get(docID);
            if (mappedDocID != -1) break;
        }
        ((Sub)this.current).mappedDocID = mappedDocID;
        return this.current;
    }

    public static abstract class Sub {
        public int mappedDocID;
        final MergeState.DocMap docMap;

        public Sub(MergeState.DocMap docMap) {
            this.docMap = docMap;
        }

        public abstract int nextDoc();
    }
}

