/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.lucene.spatial3d.geom.GeoBasePolygon;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoPolygon;
import org.apache.lucene.spatial3d.geom.Membership;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.lucene.spatial3d.geom.Vector;

class GeoConcavePolygon
extends GeoBasePolygon {
    protected final List<GeoPoint> points;
    protected final BitSet isInternalEdges;
    protected final List<GeoPolygon> holes;
    protected SidedPlane[] edges = null;
    protected SidedPlane[] invertedEdges = null;
    protected GeoPoint[][] notableEdgePoints = null;
    protected GeoPoint[] edgePoints = null;
    protected boolean isDone = false;
    protected Map<SidedPlane, Membership> eitherBounds = null;
    protected Map<SidedPlane, Plane> edgePlanes = null;
    protected Map<SidedPlane, Membership> intersectionBounds = null;

    public GeoConcavePolygon(PlanetModel planetModel, List<GeoPoint> pointList) {
        this(planetModel, pointList, null);
    }

    public GeoConcavePolygon(PlanetModel planetModel, List<GeoPoint> pointList, List<GeoPolygon> holes) {
        super(planetModel);
        this.points = pointList;
        this.holes = holes;
        this.isInternalEdges = new BitSet();
        this.done(false);
    }

    public GeoConcavePolygon(PlanetModel planetModel, List<GeoPoint> pointList, BitSet internalEdgeFlags, boolean returnEdgeInternal) {
        this(planetModel, pointList, null, internalEdgeFlags, returnEdgeInternal);
    }

    public GeoConcavePolygon(PlanetModel planetModel, List<GeoPoint> pointList, List<GeoPolygon> holes, BitSet internalEdgeFlags, boolean returnEdgeInternal) {
        super(planetModel);
        this.points = pointList;
        this.holes = holes;
        this.isInternalEdges = internalEdgeFlags;
        this.done(returnEdgeInternal);
    }

    public GeoConcavePolygon(PlanetModel planetModel, double startLatitude, double startLongitude) {
        this(planetModel, startLatitude, startLongitude, null);
    }

    public GeoConcavePolygon(PlanetModel planetModel, double startLatitude, double startLongitude, List<GeoPolygon> holes) {
        super(planetModel);
        this.points = new ArrayList<GeoPoint>();
        this.holes = holes;
        this.isInternalEdges = new BitSet();
        this.points.add(new GeoPoint(planetModel, startLatitude, startLongitude));
    }

    public void addPoint(double latitude, double longitude, boolean isInternalEdge) {
        if (this.isDone) {
            throw new IllegalStateException("Can't call addPoint() if done() already called");
        }
        if (isInternalEdge) {
            this.isInternalEdges.set(this.points.size() - 1);
        }
        this.points.add(new GeoPoint(this.planetModel, latitude, longitude));
    }

    public void done(boolean isInternalReturnEdge) {
        if (this.isDone) {
            throw new IllegalStateException("Can't call done() more than once");
        }
        if (this.points.size() < 3) {
            throw new IllegalArgumentException("Polygon needs at least three points.");
        }
        if (isInternalReturnEdge) {
            this.isInternalEdges.set(this.points.size() - 1);
        }
        this.isDone = true;
        this.edges = new SidedPlane[this.points.size()];
        this.invertedEdges = new SidedPlane[this.points.size()];
        this.notableEdgePoints = new GeoPoint[this.points.size()][];
        for (int i = 0; i < this.points.size(); ++i) {
            GeoPoint start = this.points.get(i);
            GeoPoint end = this.points.get(this.legalIndex(i + 1));
            Plane planeToFind = new Plane((Vector)start, end);
            int endPointIndex = -1;
            for (int j = 0; j < this.points.size(); ++j) {
                int index = this.legalIndex(j + i + 2);
                if (planeToFind.evaluateIsZero(this.points.get(index))) continue;
                endPointIndex = index;
                break;
            }
            if (endPointIndex == -1) {
                throw new IllegalArgumentException("Polygon points are all coplanar");
            }
            GeoPoint check = this.points.get(endPointIndex);
            this.edges[i] = new SidedPlane((Vector)check, false, start, end);
            this.invertedEdges[i] = new SidedPlane(this.edges[i]);
            this.notableEdgePoints[i] = new GeoPoint[]{start, end};
        }
        this.eitherBounds = new HashMap<SidedPlane, Membership>(this.edges.length);
        this.intersectionBounds = new HashMap<SidedPlane, Membership>(this.edges.length);
        this.edgePlanes = new HashMap<SidedPlane, Plane>(this.edges.length);
        for (int edgeIndex = 0; edgeIndex < this.edges.length; ++edgeIndex) {
            SidedPlane otherEdge;
            SidedPlane otherInvertedEdge;
            SidedPlane edge = this.edges[edgeIndex];
            SidedPlane invertedEdge = this.invertedEdges[edgeIndex];
            int bound1Index = this.legalIndex(edgeIndex + 1);
            while (this.invertedEdges[this.legalIndex(bound1Index)].isNumericallyIdentical(invertedEdge)) {
                ++bound1Index;
            }
            int bound2Index = this.legalIndex(edgeIndex - 1);
            int otherIndex = bound2Index;
            if (this.invertedEdges[this.legalIndex(otherIndex)].isNumericallyIdentical(invertedEdge)) {
                otherInvertedEdge = null;
                otherEdge = null;
            } else {
                otherInvertedEdge = this.invertedEdges[this.legalIndex(otherIndex)];
                otherEdge = this.edges[this.legalIndex(otherIndex)];
            }
            while (this.invertedEdges[this.legalIndex(bound2Index)].isNumericallyIdentical(invertedEdge)) {
                --bound2Index;
            }
            this.eitherBounds.put(edge, new EitherBound(this.invertedEdges[this.legalIndex(bound1Index)], this.invertedEdges[this.legalIndex(bound2Index)]));
            if (otherInvertedEdge == null) continue;
            while (this.invertedEdges[this.legalIndex(otherIndex)].isNumericallyIdentical(otherInvertedEdge)) {
                --otherIndex;
            }
            this.intersectionBounds.put(edge, new EitherBound(this.invertedEdges[this.legalIndex(otherIndex)], this.invertedEdges[this.legalIndex(bound2Index)]));
            this.edgePlanes.put(edge, otherEdge);
        }
        int edgePointCount = 1;
        if (this.holes != null) {
            for (GeoPolygon hole : this.holes) {
                edgePointCount += hole.getEdgePoints().length;
            }
        }
        this.edgePoints = new GeoPoint[edgePointCount];
        edgePointCount = 0;
        this.edgePoints[edgePointCount++] = this.points.get(0);
        if (this.holes != null) {
            for (GeoPolygon hole : this.holes) {
                GeoPoint[] holeEdgePoints;
                for (GeoPoint p : holeEdgePoints = hole.getEdgePoints()) {
                    this.edgePoints[edgePointCount++] = p;
                }
            }
        }
        if (this.isWithinHoles(this.points.get(0))) {
            throw new IllegalArgumentException("Polygon edge intersects a polygon hole; not allowed");
        }
    }

    protected boolean isWithinHoles(GeoPoint point) {
        if (this.holes != null) {
            for (GeoPolygon hole : this.holes) {
                if (hole.isWithin(point)) continue;
                return true;
            }
        }
        return false;
    }

    protected int legalIndex(int index) {
        while (index >= this.points.size()) {
            index -= this.points.size();
        }
        while (index < 0) {
            index += this.points.size();
        }
        return index;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        if (!this.localIsWithin(x, y, z)) {
            return false;
        }
        if (this.holes != null) {
            for (GeoPolygon polygon : this.holes) {
                if (polygon.isWithin(x, y, z)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean localIsWithin(Vector v) {
        return this.localIsWithin(v.x, v.y, v.z);
    }

    protected boolean localIsWithin(double x, double y, double z) {
        boolean isMember = false;
        for (SidedPlane edge : this.edges) {
            if (!edge.isWithin(x, y, z)) continue;
            isMember = true;
            break;
        }
        return isMember;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        for (int edgeIndex = 0; edgeIndex < this.edges.length; ++edgeIndex) {
            SidedPlane edge = this.edges[edgeIndex];
            SidedPlane invertedEdge = this.invertedEdges[edgeIndex];
            GeoPoint[] points = this.notableEdgePoints[edgeIndex];
            if (this.isInternalEdges.get(edgeIndex) || !invertedEdge.intersects(this.planetModel, p, notablePoints, points, bounds, this.eitherBounds.get(edge))) continue;
            return true;
        }
        if (this.holes != null) {
            for (GeoPolygon hole : this.holes) {
                if (!hole.intersects(p, notablePoints, bounds)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void getBounds(Bounds bounds) {
        if (this.localIsWithin(this.planetModel.NORTH_POLE)) {
            bounds.noTopLatitudeBound().noLongitudeBound().addPoint(this.planetModel.NORTH_POLE);
        }
        if (this.localIsWithin(this.planetModel.SOUTH_POLE)) {
            bounds.noBottomLatitudeBound().noLongitudeBound().addPoint(this.planetModel.SOUTH_POLE);
        }
        if (this.localIsWithin(this.planetModel.MIN_X_POLE)) {
            bounds.addPoint(this.planetModel.MIN_X_POLE);
        }
        if (this.localIsWithin(this.planetModel.MAX_X_POLE)) {
            bounds.addPoint(this.planetModel.MAX_X_POLE);
        }
        if (this.localIsWithin(this.planetModel.MIN_Y_POLE)) {
            bounds.addPoint(this.planetModel.MIN_Y_POLE);
        }
        if (this.localIsWithin(this.planetModel.MAX_Y_POLE)) {
            bounds.addPoint(this.planetModel.MAX_Y_POLE);
        }
        bounds.isWide();
        for (GeoPoint point : this.points) {
            bounds.addPoint(point);
        }
        for (SidedPlane edge : this.edges) {
            bounds.addPlane(this.planetModel, edge, this.eitherBounds.get(edge));
            Membership m = this.intersectionBounds.get(edge);
            if (m == null) continue;
            bounds.addIntersection(this.planetModel, this.edgePlanes.get(edge), edge, m);
        }
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double minimumDistance = Double.POSITIVE_INFINITY;
        for (GeoPoint edgePoint : this.points) {
            double newDist = distanceStyle.computeDistance(edgePoint, x, y, z);
            if (!(newDist < minimumDistance)) continue;
            minimumDistance = newDist;
        }
        for (SidedPlane edgePlane : this.edges) {
            Membership[] membershipArray = new Membership[]{this.eitherBounds.get(edgePlane)};
            double newDist = distanceStyle.computeDistance(this.planetModel, (Plane)edgePlane, x, y, z, membershipArray);
            if (!(newDist < minimumDistance)) continue;
            minimumDistance = newDist;
        }
        if (this.holes != null) {
            for (GeoPolygon hole : this.holes) {
                double holeDistance = hole.computeOutsideDistance(distanceStyle, x, y, z);
                if (holeDistance == 0.0 || !(holeDistance < minimumDistance)) continue;
                minimumDistance = holeDistance;
            }
        }
        return minimumDistance;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoConcavePolygon)) {
            return false;
        }
        GeoConcavePolygon other = (GeoConcavePolygon)o;
        if (!super.equals(other)) {
            return false;
        }
        if (!other.isInternalEdges.equals(this.isInternalEdges)) {
            return false;
        }
        if (other.holes != null || this.holes != null) {
            if (other.holes == null || this.holes == null) {
                return false;
            }
            if (!other.holes.equals(this.holes)) {
                return false;
            }
        }
        return other.points.equals(this.points);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.points.hashCode();
        if (this.holes != null) {
            result = 31 * result + this.holes.hashCode();
        }
        return result;
    }

    public String toString() {
        return "GeoConcavePolygon: {planetmodel=" + this.planetModel + ", points=" + this.points + ", internalEdges=" + this.isInternalEdges + (this.holes == null ? "" : ", holes=" + this.holes) + "}";
    }

    protected class EitherBound
    implements Membership {
        protected final SidedPlane sideBound1;
        protected final SidedPlane sideBound2;

        public EitherBound(SidedPlane sideBound1, SidedPlane sideBound2) {
            this.sideBound1 = sideBound1;
            this.sideBound2 = sideBound2;
        }

        @Override
        public boolean isWithin(Vector v) {
            return this.sideBound1.isWithin(v) && this.sideBound2.isWithin(v);
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            return this.sideBound1.isWithin(x, y, z) && this.sideBound2.isWithin(x, y, z);
        }
    }
}

